/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cp4ba;

import com.filenet.api.admin.CmDirectoryConfigurationSCIM;
import com.filenet.api.admin.DirectoryConfiguration;
import com.filenet.api.constants.RefreshMode;
import com.filenet.api.core.Connection;
import com.filenet.api.core.Domain;
import com.filenet.api.core.Factory;
import com.filenet.api.util.UserContext;
import com.ibm.cp4ba.Option;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.security.auth.Subject;

public class UpdateDirectory {
    String cpeServerUrl;
    String cpePort;
    String userName;
    String password;
    String cpeConnectionString;
    String oldDirectoryServerHost = "icp-management-ingress";
    String iamIdmanagementServerName = "platform-identity-management";
    String directoryServerPort = "443";
    String iamIdproviderServerName = "platform-identity-provider";
    String iamIdproviderServerPort = "4300";
    String iamAuthUrlToken = "/v1/auth/token";
    String iamOldAuthUrlToken = "/idprovider/v1/auth/token";
    String iamAuthUrl;
    String iamScimInfoContextPath = "identity/api/v1/scim/";
    String iamOldScimInfoContextPath = "idmgmt/identity/api/v1/scim/";
    String namespace;
    String service = "svc";
    Option option = null;
    Domain p8Domain;
    List<CmDirectoryConfigurationSCIM> scimDirList = new ArrayList<CmDirectoryConfigurationSCIM>();
    Connection connection;
    UserContext uc;
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$com$ibm$cp4ba$Option;

    public UpdateDirectory(String cpeServerUrl, String cpePort, String userName, String password, String namespace) {
        this.cpeServerUrl = cpeServerUrl;
        this.cpePort = cpePort;
        this.userName = userName;
        this.password = password;
        this.namespace = namespace;
        this.cpeConnectionString = "https://" + this.cpeServerUrl + ":" + this.cpePort + "/wsi/FNCEWS40MTOM/";
        this.iamAuthUrl = "https://" + this.iamIdproviderServerName + "." + this.namespace + "." + this.service + ":" + this.iamIdproviderServerPort + this.iamAuthUrlToken;
    }

    public UpdateDirectory(String cpeServerUrl, String cpePort, String userName, String password, String oldDirectoryServerHost, String namespace) {
        this.cpeServerUrl = cpeServerUrl;
        this.cpePort = cpePort;
        this.userName = userName;
        this.password = password;
        this.namespace = namespace;
        this.cpeConnectionString = "https://" + this.cpeServerUrl + ":" + this.cpePort + "/wsi/FNCEWS40MTOM/";
        this.oldDirectoryServerHost = oldDirectoryServerHost;
        this.iamAuthUrl = "https://" + this.iamIdproviderServerName + "." + this.namespace + "." + this.service + ":" + this.iamIdproviderServerPort + this.iamAuthUrlToken;
    }

    public UpdateDirectory(String cpeServerUrl, String cpePort, String userName, String password, String oldDirectoryServerHost, String newDirectoryServerHost, String directoryServerPort, String iamIdproviderServerName, String iamIdproviderServerPort, String iamAuthUrlToken, String namespace) {
        this.cpeServerUrl = cpeServerUrl;
        this.cpePort = cpePort;
        this.userName = userName;
        this.password = password;
        this.cpeConnectionString = "https://" + this.cpeServerUrl + ":" + this.cpePort + "/wsi/FNCEWS40MTOM/";
        this.oldDirectoryServerHost = oldDirectoryServerHost;
        this.iamIdmanagementServerName = newDirectoryServerHost;
        this.directoryServerPort = directoryServerPort;
        this.iamIdproviderServerName = iamIdproviderServerName;
        this.iamIdproviderServerPort = iamIdproviderServerPort;
        this.iamAuthUrlToken = iamAuthUrlToken;
        this.namespace = namespace;
        this.iamAuthUrl = "https://" + this.iamIdproviderServerName + "." + this.namespace + "." + this.service + ":" + this.iamIdproviderServerPort + this.iamAuthUrlToken;
    }

    protected boolean isConnected(String domain) {
        try {
            this.uc = UserContext.get();
            this.connection = Factory.Connection.getConnection(this.cpeConnectionString);
            Subject sub = UserContext.createSubject(this.connection, this.userName, this.password, null);
            this.uc.pushSubject(sub);
            this.p8Domain = domain == null ? Factory.Domain.fetchInstance(this.connection, null, null) : Factory.Domain.fetchInstance(this.connection, domain, null);
        }
        catch (Exception e) {
            System.out.println("FAILED: To establish connection.");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    protected boolean updateDirectoryScim(List<CmDirectoryConfigurationSCIM> scimDirs, String oldHost, String oldAuthUrl, String newHost, String newAuthUrl, String scimInfoContextPath, String authUrlToken) {
        try {
            for (CmDirectoryConfigurationSCIM scim : scimDirs) {
                if (scim.get_DirectoryServerHost().toLowerCase().contains(oldHost.toLowerCase()) || !scim.get_DirectoryServerHost().toLowerCase().contains(newHost.toLowerCase())) {
                    scim.set_DirectoryServerHost(newHost);
                }
                if (scim.get_SCIMAuthenticationURL().toLowerCase().contains(oldAuthUrl.toLowerCase()) || !scim.get_SCIMAuthenticationURL().toLowerCase().contains(newAuthUrl.toLowerCase())) {
                    scim.set_SCIMAuthenticationURL("https://" + newAuthUrl + authUrlToken);
                }
                if (this.getOption().toString().toLowerCase().equalsIgnoreCase("POSTUPGRADE")) {
                    scim.set_SCIMContextPath(scimInfoContextPath);
                }
                this.p8Domain.save(RefreshMode.REFRESH);
            }
        }
        catch (Exception e) {
            System.out.println("FAILED: To update scim directory");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    protected boolean updateDirectoryScim() {
        try {
            Iterator dirConfigs = this.p8Domain.get_DirectoryConfigurations().iterator();
            CmDirectoryConfigurationSCIM scimDir = null;
            while (dirConfigs != null && dirConfigs.hasNext()) {
                DirectoryConfiguration dir = (DirectoryConfiguration)dirConfigs.next();
                System.out.println(dir.get_SymbolicName());
                System.out.println(dir.get_DirectoryServerHost());
                System.out.println(dir.get_DirectoryServerType());
                System.out.println(dir.get_DirectoryServerPort());
                if (!(dir instanceof CmDirectoryConfigurationSCIM)) continue;
                scimDir = (CmDirectoryConfigurationSCIM)dir;
                System.out.println(scimDir.get_DirectoryServerHost());
                System.out.println(scimDir.get_SCIMAuthenticationURL());
                System.out.println(scimDir.get_SCIMContextPath());
            }
        }
        catch (Exception e) {
            System.out.println("FAILED: To update scim directory");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    protected List<CmDirectoryConfigurationSCIM> getScimConfiguration() {
        return this.scimDirList;
    }

    protected void setScimConfiguration() {
        try {
            Iterator dirConfigs = this.p8Domain.get_DirectoryConfigurations().iterator();
            while (dirConfigs != null && dirConfigs.hasNext()) {
                DirectoryConfiguration dir = (DirectoryConfiguration)dirConfigs.next();
                if (!(dir instanceof CmDirectoryConfigurationSCIM)) continue;
                this.scimDirList.add((CmDirectoryConfigurationSCIM)dir);
            }
        }
        catch (Exception e) {
            this.scimDirList = null;
            System.out.println("FAILED: Failed to get directory configuration.");
            e.printStackTrace();
        }
    }

    protected static boolean isValidOption(String opt) {
        try {
            Option.valueOf(opt);
        }
        catch (Exception e) {
            System.out.println("FAILED: Not a valid option " + opt);
            System.out.println("Valid options: " + (Object)((Object)Option.SCIMENABLED) + ", " + (Object)((Object)Option.POSTUPGRADE) + ", " + (Object)((Object)Option.PREUPGRADE));
            return false;
        }
        return true;
    }

    protected void setOption(Option opt) {
        this.option = opt;
    }

    protected Option getOption() {
        return this.option;
    }

    public static void main(String[] args) {
        block18: {
            block16: {
                block17: {
                    UpdateDirectory updateDirectory = null;
                    if (args.length <= 0) break block16;
                    if (args.length != 8 && (args.length != 6 || !Option.valueOf(args[0].toUpperCase()).equals((Object)Option.SCIMENABLED)) && (args.length != 6 || !Option.valueOf(args[0].toUpperCase()).equals((Object)Option.POSTUPGRADE))) break block17;
                    if (!UpdateDirectory.isValidOption(args[0])) break block18;
                    Option opt = Option.valueOf(args[0].toUpperCase());
                    switch (UpdateDirectory.$SWITCH_TABLE$com$ibm$cp4ba$Option()[opt.ordinal()]) {
                        case 1: {
                            updateDirectory = new UpdateDirectory(args[1], args[2], args[3], args[4], args[5]);
                            updateDirectory.setOption(opt);
                            if (updateDirectory.isConnected(null)) {
                                updateDirectory.setScimConfiguration();
                                if (updateDirectory.getScimConfiguration() != null && updateDirectory.getScimConfiguration().size() > 0) {
                                    System.out.println("TRUE : The p8domain is configured with a scim directory");
                                    break;
                                }
                                System.out.println("FALSE : The p8domain is not configured with a scim directory");
                                break;
                            }
                            break block18;
                        }
                        case 3: {
                            updateDirectory = new UpdateDirectory(args[1], args[2], args[3], args[4], args[5]);
                            updateDirectory.setOption(opt);
                            if (updateDirectory.isConnected(null)) {
                                updateDirectory.setScimConfiguration();
                                if (updateDirectory.getScimConfiguration() != null && updateDirectory.getScimConfiguration().size() > 0) {
                                    String newHost = args[6];
                                    String newAuthUrl = args[7];
                                    if (updateDirectory.updateDirectoryScim(updateDirectory.getScimConfiguration(), updateDirectory.oldDirectoryServerHost, updateDirectory.oldDirectoryServerHost, newHost, newAuthUrl, null, updateDirectory.iamOldAuthUrlToken)) {
                                        System.out.println("Successfully updated scim configuration");
                                        break;
                                    }
                                    System.out.println("Failed to update scim configuration");
                                    break;
                                }
                                System.out.println("FALSE : The p8domain is not configured with a scim directory");
                                break;
                            }
                            break block18;
                        }
                        case 2: {
                            updateDirectory = new UpdateDirectory(args[1], args[2], args[3], args[4], args[5]);
                            String oldHost = "";
                            String oldAuthUrl = "";
                            updateDirectory.setOption(opt);
                            if (!updateDirectory.isConnected(null)) break block18;
                            updateDirectory.setScimConfiguration();
                            if (updateDirectory.getScimConfiguration() != null && updateDirectory.getScimConfiguration().size() > 0) {
                                if (args.length == 8) {
                                    oldHost = args[6];
                                    oldAuthUrl = args[7];
                                }
                                String idpAuthUrl = String.valueOf(updateDirectory.iamIdproviderServerName) + "." + updateDirectory.namespace + "." + updateDirectory.service + ":" + updateDirectory.iamIdproviderServerPort;
                                String imMgmtServer = String.valueOf(updateDirectory.iamIdmanagementServerName) + "." + updateDirectory.namespace + "." + updateDirectory.service;
                                if (updateDirectory.updateDirectoryScim(updateDirectory.getScimConfiguration(), oldHost, oldAuthUrl, imMgmtServer, idpAuthUrl, updateDirectory.iamScimInfoContextPath, updateDirectory.iamAuthUrlToken)) {
                                    System.out.println("Successfully updated scim configuration");
                                    break;
                                }
                                System.out.println("Failed to update scim configuration");
                                break;
                            }
                            System.out.println("FALSE : The p8domain is not configured with a scim directory");
                        }
                        default: {
                            break;
                        }
                        {
                            break block18;
                        }
                    }
                    break block18;
                }
                System.out.println("FAILED: Missing arguments");
                break block18;
            }
            System.out.println("FAILED: Missing arguments");
        }
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$ibm$cp4ba$Option() {
        if ($SWITCH_TABLE$com$ibm$cp4ba$Option != null) {
            return $SWITCH_TABLE$com$ibm$cp4ba$Option;
        }
        int[] nArray = new int[Option.values().length];
        try {
            nArray[Option.POSTUPGRADE.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Option.PREUPGRADE.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Option.SCIMENABLED.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$ibm$cp4ba$Option = nArray;
        return nArray;
    }
}

