/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.api.authentication;

import com.filenet.api.authentication.SubjectCredentials;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.util.J2EEUtil;
import com.filenet.apiimpl.util.UnifiedContext;
import com.filenet.apiimpl.util.UserContextImpl;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;

public abstract class Credentials {
    private static UnifiedContextCredentials UNI_CREDS = new UnifiedContextCredentials();

    public <T> T doAs(PrivilegedExceptionAction<T> pea) {
        this.push();
        try {
            T t = pea.run();
            return t;
        }
        catch (Throwable t) {
            if (t.getCause() instanceof EngineRuntimeException) {
                throw (EngineRuntimeException)t.getCause();
            }
            if (t instanceof EngineRuntimeException) {
                throw (EngineRuntimeException)t;
            }
            throw new EngineRuntimeException(t, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
        finally {
            this.pop();
        }
    }

    public static Credentials getCurrent() {
        if (UnifiedContext.get() != null) {
            return UNI_CREDS;
        }
        UserContextImpl uci = UserContextImpl.getImpl();
        Credentials cr = uci.getTopCredentials();
        if (cr != null) {
            return cr;
        }
        Subject sub = J2EEUtil.getInstance().getCurrentSubject();
        if (sub != null) {
            return new SubjectCredentials(sub);
        }
        return null;
    }

    protected void push() {
        UserContextImpl uc = UserContextImpl.getImpl();
        uc.pushCredentials(this);
    }

    protected void pop() {
        UserContextImpl uc = UserContextImpl.getImpl();
        uc.popCredentials();
    }

    private static class UnifiedContextCredentials
    extends Credentials {
        private UnifiedContextCredentials() {
        }

        @Override
        public <T> T doAs(PrivilegedExceptionAction<T> pea) {
            try {
                return pea.run();
            }
            catch (Throwable t) {
                if (t.getCause() instanceof EngineRuntimeException) {
                    throw (EngineRuntimeException)t.getCause();
                }
                if (t instanceof EngineRuntimeException) {
                    throw (EngineRuntimeException)t;
                }
                throw new EngineRuntimeException(t, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
            }
        }
    }
}

