/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.api.authentication;

import com.filenet.api.authentication.Credentials;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.util.J2EEUtil;
import java.security.Principal;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import javax.security.auth.Subject;

public class SubjectCredentials
extends Credentials {
    private Subject subject;

    public SubjectCredentials(Subject subject) {
        if (subject == null) {
            throw new EngineRuntimeException(ExceptionCode.E_INVALID_ARGUMENT, "subject");
        }
        this.subject = subject;
    }

    public Subject getSubject() {
        return this.subject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T doAs(PrivilegedExceptionAction<T> pea) {
        J2EEUtil j2ee = J2EEUtil.getInstance();
        this.push();
        try {
            Object object = j2ee.doAs(this.subject, pea);
            return (T)object;
        }
        finally {
            this.pop();
        }
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof SubjectCredentials)) {
            return false;
        }
        return this.subject.equals(((SubjectCredentials)other).subject);
    }

    public int hashCode() {
        return this.subject.hashCode();
    }

    public String toString() {
        return "Subject credentials: " + this.subject.toString() + " " + SubjectCredentials.getPrincipal(this.subject);
    }

    private static String getPrincipal(Subject sub) {
        if (sub == null || sub.getPrincipals() == null || sub.getPrincipals().isEmpty()) {
            return "";
        }
        StringBuffer principals = new StringBuffer();
        int i = 0;
        Iterator<Principal> iter = sub.getPrincipals().iterator();
        while (iter.hasNext()) {
            if (i > 0) {
                principals.append("; ");
            }
            Principal principal = iter.next();
            principals.append("Principal[" + i++ + "]=" + principal.toString());
        }
        return principals.toString();
    }
}

