/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.api.core;

import com.filenet.api.constants.RefreshMode;
import com.filenet.api.core.Batch;
import com.filenet.api.core.BatchItemHandle;
import com.filenet.api.core.Connection;
import com.filenet.api.core.Domain;
import com.filenet.api.core.IndependentObject;
import com.filenet.api.core.IndependentlyPersistableObject;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.property.PropertyFilter;
import com.filenet.apiimpl.core.BatchItemHandleImpl;
import com.filenet.apiimpl.core.ConnectionImpl;
import com.filenet.apiimpl.core.Session;
import com.filenet.apiimpl.exception.Exceptions;
import com.filenet.apiimpl.util.SessionLocator;
import com.filenet.apiimpl.util.classloader.CRCLHelper;
import java.util.Iterator;

public class UpdatingBatch
extends Batch {
    private RefreshMode refresh = null;
    private static final String UB_CLASS_NAME = UpdatingBatch.class.getName();
    private static final Class[] types_dr = new Class[]{Domain.class, RefreshMode.class};
    private static final Class[] types_ip = new Class[]{IndependentlyPersistableObject.class, PropertyFilter.class};
    private static final Class[] types_void = new Class[0];

    private UpdatingBatch(Domain domain, RefreshMode refreshVal) {
        super(domain);
        this.refresh = refreshVal;
    }

    public static UpdatingBatch createUpdatingBatchInstance(Domain domain, RefreshMode refresh) {
        UpdatingBatch ub = new UpdatingBatch(domain, refresh);
        Object crclResult = CRCLHelper.doCRCLcall(UB_CLASS_NAME, "createUpdatingBatchInstance", types_dr, domain, refresh);
        if (crclResult != "CRCL not used") {
            ub.crclDelegate = crclResult;
        }
        return ub;
    }

    public BatchItemHandle add(IndependentlyPersistableObject object, PropertyFilter filter) {
        if (this.crclDelegate != null) {
            Object crclResult = CRCLHelper.doCRCLcall(this.crclDelegate, UB_CLASS_NAME, "add", types_ip, object, filter);
            return (BatchItemHandle)crclResult;
        }
        BatchItemHandleImpl item = new BatchItemHandleImpl(object, filter);
        this.addHandle(item);
        return item;
    }

    public boolean hasPendingExecute() {
        if (this.crclDelegate != null) {
            Object crclResult = CRCLHelper.doCRCLcall(this.crclDelegate, UB_CLASS_NAME, "hasPendingExecute", types_void, new Object[0]);
            return (Boolean)crclResult;
        }
        boolean hasPending = false;
        Iterator iter = super.getBatchList().iterator();
        while (iter.hasNext()) {
            IndependentObject obj = ((BatchItemHandle)iter.next()).getObject();
            if (!(obj instanceof IndependentlyPersistableObject) || ((IndependentlyPersistableObject)obj).getPendingActions().length <= 0 && !((IndependentlyPersistableObject)obj).getProperties().isDirty()) continue;
            hasPending = true;
            break;
        }
        return hasPending;
    }

    public void updateBatch() {
        if (this.crclDelegate != null) {
            CRCLHelper.doCRCLcall(this.crclDelegate, UB_CLASS_NAME, "updateBatch", types_void, new Object[0]);
            return;
        }
        if (super.getBatchList().size() == 0) {
            throw new EngineRuntimeException(ExceptionCode.API_EMPTY_BATCH, null);
        }
        BatchItemHandleImpl[] batch = super.getBatchList().toArray(new BatchItemHandleImpl[0]);
        Connection connection = super.getDomain().getConnection();
        Session session = SessionLocator.getSession(connection);
        try {
            session.executeChanges((ConnectionImpl)connection, this.refresh, batch);
        }
        catch (EngineRuntimeException ere) {
            int failedBatchItem = Exceptions.detectFailedBatchItem(ere);
            if (failedBatchItem >= 0 && failedBatchItem < batch.length) {
                BatchItemHandleImpl item = batch[failedBatchItem];
                item.setException(ere);
            }
            throw ere;
        }
    }
}

