/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.api.engine;

import com.filenet.api.admin.CmStorageDevice;
import com.filenet.api.constants.AreaDeleteMethod;
import com.filenet.api.util.Id;
import java.io.InputStream;

public interface StorageDeviceHandler {
    public void load(CmStorageDevice var1);

    public int capabilitySupported(Capability var1);

    public boolean testConnectivity(boolean var1);

    public void initializeStorage(int var1);

    public ContentCreationResult createContent(InputStream var1, Id var2, long var3, boolean var5);

    public InputStream openContent(Id var1, long var2, long var4, String var6);

    public boolean deleteContent(Id var1, long var2, AreaDeleteMethod var4, String var5);

    public boolean backoutContent(Id var1, long var2, AreaDeleteMethod var4);

    public ContentValidationResult validateContent(Id var1, long var2, long var4, boolean var6, String var7, boolean var8);

    public void disconnect();

    public static class ContentValidationResult {
        private ValidationStatus status;
        private long actualSize;
        private String message;

        public ContentValidationResult(ValidationStatus status, long actualSize, String message) {
            this.status = status;
            this.actualSize = actualSize;
            this.message = message;
        }

        public ValidationStatus status() {
            return this.status;
        }

        public long actualSize() {
            return this.actualSize;
        }

        public String message() {
            return this.message;
        }
    }

    public static class ContentCreationResult {
        private boolean existed;
        private long size;
        private String deviceIdentity;

        public ContentCreationResult(boolean existed, long size, String deviceIdentity) {
            this.existed = existed;
            this.size = size;
            this.deviceIdentity = deviceIdentity;
        }

        public boolean existed() {
            return this.existed;
        }

        public long size() {
            return this.size;
        }

        public String deviceIdentity() {
            return this.deviceIdentity;
        }
    }

    public static enum ValidationStatus {
        SUCCESS,
        MISSING,
        WRONG_SIZE,
        FAILED;

    }

    public static enum Capability {
        SYNCHRONOUS_REPLICATION,
        DELETE_METHOD;

    }
}

