/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.api.util;

import com.filenet.api.constants.ConfigurationParameter;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.meta.MetadataCache;
import com.filenet.apiimpl.exception.ExceptionContext;
import com.filenet.apiimpl.util.BaseLogger;
import com.filenet.apiimpl.util.SubSystem;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ConfigurationParameters
implements Serializable {
    private Map values;
    private static final String KEY_PREFIX = "FileNet.".toLowerCase();
    private static final BaseLogger logger = BaseLogger.getBaseLogger(ConfigurationParameters.class, SubSystem.API);
    private static final long serialVersionUID = -852297649502989438L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0];

    public ConfigurationParameters() {
        this.values = new HashMap();
    }

    public ConfigurationParameters(ConfigurationParameters parameters) {
        if (parameters == null) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_ARGUMENT, "parameters");
        }
        this.values = new HashMap(parameters.values);
    }

    public Object getParameter(ConfigurationParameter parameter) {
        if (parameter == null) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_ARGUMENT, "parameter");
        }
        return this.values.get(parameter);
    }

    public Object setParameter(ConfigurationParameter parameter, Object value) {
        if (parameter == null) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_ARGUMENT, "parameter");
        }
        if (value == null) {
            return this.values.remove(parameter);
        }
        Class[] types = parameter.getValueTypes();
        boolean validType = types.length == 0;
        for (int i = 0; i < types.length && !validType; ++i) {
            validType = types[i].isInstance(value);
        }
        if (!validType) {
            throw new EngineRuntimeException(ExceptionCode.API_INVALID_CONFIGURATION_PARAMETER, new Object[]{parameter.toString()}, ExceptionContext.API_INVALID_CONFIGURATION_PARAMETER_VALUE_TYPE, new Object[]{ConfigurationParameters.getClassNames(types), value.getClass().getName()});
        }
        return this.values.put(parameter, value);
    }

    public void setParameters(ConfigurationParameters parameters) {
        if (parameters == null) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_ARGUMENT, "parameters");
        }
        this.values.putAll(parameters.values);
    }

    private static String getClassNames(Class[] types) {
        StringBuffer buffer = new StringBuffer(128 * types.length);
        buffer.append(types[0].getName());
        for (int i = 1; i < types.length; ++i) {
            buffer.append(", ").append(types[i].getName());
        }
        return buffer.toString();
    }

    public void loadMap(Map map) {
        if (map == null) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_ARGUMENT, "map");
        }
        ConfigurationParameters parameters = new ConfigurationParameters(this);
        for (Map.Entry entry : map.entrySet()) {
            ConfigurationParameter parameter = ConfigurationParameters.parseKey(entry.getKey());
            if (parameter == null) continue;
            Object value = ConfigurationParameters.parseValue(parameter, entry.getValue());
            parameters.setParameter(parameter, value);
        }
        this.values = parameters.values;
    }

    private static ConfigurationParameter parseKey(Object key) {
        if (key instanceof ConfigurationParameter) {
            return (ConfigurationParameter)key;
        }
        if (key instanceof String) {
            String string = key.toString().toLowerCase();
            if (!string.startsWith(KEY_PREFIX)) {
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail("loadMap: skipping unknown key=" + key);
                }
                return null;
            }
            return ConfigurationParameter.getInstanceFromString(string);
        }
        throw new EngineRuntimeException(ExceptionCode.API_INVALID_CONFIGURATION_PARAMETER, String.valueOf(key));
    }

    private static Object parseValue(ConfigurationParameter parameter, Object value) {
        if (value == null) {
            return null;
        }
        Class[] types = parameter.getValueTypes();
        if (types.length == 0) {
            return value;
        }
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].isInstance(value)) continue;
            return value;
        }
        if (!(value instanceof String)) {
            return value;
        }
        String string = ((String)value).trim();
        if (string.length() == 0) {
            return null;
        }
        for (int i = 0; i < types.length; ++i) {
            Class type = types[i];
            try {
                if (type == Boolean.class) {
                    return Boolean.valueOf(string);
                }
                if (type == Integer.class) {
                    return Integer.valueOf(string);
                }
                if (type == Long.class) {
                    return Long.valueOf(string);
                }
                if (type == MetadataCache.class) continue;
                throw new InternalError();
            }
            catch (Throwable e) {
                throw new EngineRuntimeException(e, ExceptionCode.API_INVALID_CONFIGURATION_PARAMETER, new Object[]{parameter.toString()}, ExceptionContext.API_INVALID_CONFIGURATION_PARAMETER_STRING_VALUE, new Object[]{type.getName(), string});
            }
        }
        return value;
    }

    public String toString() {
        return this.values.toString();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeInt(20);
        s.writeInt(this.values.size());
        for (Map.Entry entry : this.values.entrySet()) {
            ConfigurationParameter parameter = (ConfigurationParameter)entry.getKey();
            s.writeInt(parameter.getIntValue());
            s.writeObject(entry.getValue());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.readInt();
        this.values = new HashMap();
        for (int size = s.readInt(); size > 0; --size) {
            ConfigurationParameter parameter = ConfigurationParameter.getInstanceFromInt(s.readInt());
            this.values.put(parameter, s.readObject());
        }
    }
}

