/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.api.util;

import com.filenet.apiimpl.wsi.WSICredential;
import java.io.IOException;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class WSILoginModule
implements LoginModule {
    private static final String PARAM_PW = "javax.security.auth.login.password";
    private static final String PARAM_NAME = "javax.security.auth.login.name";
    private static final String PARAM_DEBUG_L = "debug";
    private static final String PARAM_DEBUG_U = "debug".toUpperCase();
    private Subject subj = null;
    private CallbackHandler cbh = null;
    private Map ss = null;
    private Map opts = null;
    private WSICredential wsiCredential = null;
    private boolean isDebug = false;
    private String simpleName = this.getClass().getSimpleName();

    private void d(Object o) {
        String s = o instanceof String ? (String)o : o.toString();
        System.out.println(this.simpleName + ": " + s);
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subj = subject;
        this.cbh = callbackHandler;
        this.ss = sharedState;
        this.opts = options;
        this.isDebug = WSILoginModule.getIsDebug(this.opts);
        if (this.isDebug) {
            this.d("initialize() called");
            this.d(this.subj.toString().replaceAll("\n", "\\\\n").replaceAll("\r", "\\\\r"));
            this.d(this.cbh);
            this.d("shared state: " + this.ss);
            this.d("options: " + this.opts);
        }
    }

    private static boolean getIsDebug(Map options) {
        if (options == null) {
            return false;
        }
        if (options.containsKey(PARAM_DEBUG_L)) {
            String dLval = (String)options.get(PARAM_DEBUG_L);
            if (dLval == null) {
                return true;
            }
            return Boolean.valueOf(dLval);
        }
        String dUval = (String)options.get(PARAM_DEBUG_U);
        return Boolean.valueOf(dUval);
    }

    @Override
    public boolean login() throws LoginException {
        String password;
        Object pwObj;
        String username;
        if (this.isDebug) {
            this.d("login() called");
        }
        if ((username = (String)this.ss.get(PARAM_NAME)) == null) {
            this.getInfoViaCallbacks();
        }
        username = (String)this.ss.get(PARAM_NAME);
        if (this.isDebug) {
            this.d("username: " + username);
        }
        if ((pwObj = this.ss.get(PARAM_PW)) instanceof String || pwObj == null) {
            password = (String)pwObj;
        } else if (pwObj instanceof char[]) {
            password = new String((char[])pwObj);
        } else {
            Class<?> pwObjClass = pwObj.getClass();
            if (this.isDebug) {
                this.d("shared state password is of type " + pwObjClass);
            }
            throw new LoginException("Unexpected JAAS password object of type " + pwObjClass);
        }
        pwObj = null;
        if (this.isDebug) {
            if (password == null) {
                this.d("password is null");
            } else {
                this.d("password length " + password.length());
            }
        }
        this.wsiCredential = new WSICredential(username, password);
        password = null;
        return true;
    }

    private void getInfoViaCallbacks() throws LoginException {
        if (this.isDebug) {
            this.d("getInfoViaCallbacks() called, CBH: " + this.cbh);
        }
        if (this.cbh == null) {
            throw new LoginException("No JAAS CallbackHandler available to get authentication information");
        }
        NameCallback nameCallback = new NameCallback("FileNet user name:");
        PasswordCallback passwordCallback = new PasswordCallback("FileNet password:", false);
        Callback[] callbacks = new Callback[]{nameCallback, passwordCallback};
        try {
            this.cbh.handle(callbacks);
        }
        catch (IOException ioe) {
            if (this.isDebug) {
                this.d(ioe);
            }
            LoginException le = new LoginException();
            le.initCause(ioe);
            throw le;
        }
        catch (UnsupportedCallbackException uce) {
            Callback unhandled;
            if (this.isDebug) {
                this.d(uce);
            }
            String unhandledType = (unhandled = uce.getCallback()) == null ? "null" : unhandled.getClass().toString();
            LoginException le = new LoginException("No JAAS CallbackHandler for " + unhandledType);
            le.initCause(uce);
            throw le;
        }
        this.ss.put(PARAM_NAME, nameCallback.getName());
        this.ss.put(PARAM_PW, passwordCallback.getPassword());
        passwordCallback.clearPassword();
    }

    @Override
    public boolean commit() {
        if (this.isDebug) {
            this.d("commit() called");
        }
        if (this.wsiCredential == null) {
            return false;
        }
        if (!this.subj.getPrivateCredentials().contains(this.wsiCredential)) {
            this.subj.getPrivateCredentials().add(this.wsiCredential);
        }
        if (this.isDebug) {
            this.d(this.subj.toString().replaceAll("\n", "\\\\n").replaceAll("\r", "\\\\r"));
        }
        return true;
    }

    @Override
    public boolean abort() {
        if (this.isDebug) {
            this.d("abort() called");
        }
        if (this.wsiCredential == null) {
            return false;
        }
        this.wsiCredential = null;
        return true;
    }

    @Override
    public boolean logout() {
        if (this.isDebug) {
            this.d("logout() called");
        }
        this.subj.getPrivateCredentials().remove(this.wsiCredential);
        this.wsiCredential = null;
        return true;
    }
}

