/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.authentication.util;

import com.filenet.apiimpl.authentication.FnceCallbackHandler;
import com.filenet.apiimpl.authentication.util.AuthnUtil;
import com.filenet.apiimpl.authentication.util.DynLoginContext;
import com.filenet.apiimpl.authentication.util.LmState;
import com.filenet.apiimpl.exception.ExceptionAuthn;
import com.filenet.apiimpl.util.J2EEType;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public class J2EEAuthnUtil {
    private static J2EEAuthnUtil util;
    private static int appServerType;
    private static final String FNAME = "[J2EEAuthnUtil] ";
    protected static String fname;
    protected static final String CLIENT_LOGIN_CONFIG = "FileNetP8";
    protected String krb5LoginModuleClass = "com.sun.security.auth.module.Krb5LoginModule";
    protected String[] krb5NormalClientLoginOptions = new String[]{"storeKey=true"};
    protected String[] krb5CachedClientLoginOptions = new String[]{"useTicketCache=true"};
    protected String[] krb5ServiceLoginOptions = new String[]{"useKeyTab=true", "storeKey=true"};
    protected String[] krb5ServiceLoginOptionsKeytab = this.krb5ServiceLoginOptions;
    protected String krb5KeytabOption = "keyTab";
    protected String krb5KeytabPrefix = "";

    protected J2EEAuthnUtil() {
    }

    public static J2EEAuthnUtil getInstance() {
        if (util == null) {
            util = Init.util;
            appServerType = Init.appServerType;
        }
        return util;
    }

    public static int getAppServerType() {
        if (appServerType == -1) {
            util = Init.util;
            appServerType = Init.appServerType;
        }
        return appServerType;
    }

    public static String getProviderURL() {
        return J2EEType.getProviderURL();
    }

    public Subject doServerLogin(String config, String username, char[] password, boolean isDebug) throws LoginException {
        if (isDebug) {
            AuthnUtil.log(fname + "doServerLogin for '" + username + '\'');
        }
        FnceCallbackHandler handler = new FnceCallbackHandler(username, password);
        LoginContext lc = new LoginContext(config, handler);
        lc.login();
        return lc.getSubject();
    }

    public Subject doServerLogin(String config, CallbackHandler handler, boolean isDebug) throws LoginException {
        if (isDebug) {
            AuthnUtil.log(fname + "doServerLogin using a callback handler");
        }
        LoginContext lc = new LoginContext(config, handler);
        lc.login();
        return lc.getSubject();
    }

    public boolean handleServerCallbacks(LmState state, Callback[] callbacks) throws UnsupportedCallbackException, IOException {
        state.callbackHandler.handle(callbacks);
        return true;
    }

    public boolean precommitClientLogin(LmState state, char[] credential) throws LoginException, IOException {
        return this.precommitLogin(state);
    }

    public boolean precommitServerLogin(LmState state) throws LoginException, IOException {
        return this.precommitLogin(state);
    }

    public boolean precommitLogin(LmState state) throws LoginException, IOException {
        this.addUserPrincipal(state, state.princName);
        if (state.realm != null) {
            this.addGroupPrincipal(state, state.realm);
        }
        if (state.extraCred != null) {
            state.newPrivateCredentials.add(state.extraCred);
        }
        return true;
    }

    public boolean commitClientLogin(LmState state) {
        return this.commitLogin(state);
    }

    public boolean commitServerLogin(LmState state) {
        return this.commitLogin(state);
    }

    public boolean commitLogin(LmState state) {
        state.subject.getPrincipals().addAll(state.newPrincipals);
        state.subject.getPublicCredentials().addAll(state.newPublicCredentials);
        state.subject.getPrivateCredentials().addAll(state.newPrivateCredentials);
        if (state.isDebug) {
            AuthnUtil.log(fname + "commit successful");
        }
        return true;
    }

    public void cleanupLogin(LmState state) {
        Subject subject = state.subject;
        Iterator it = state.newPrincipals.iterator();
        while (it.hasNext()) {
            subject.getPrincipals().remove(it.next());
        }
        state.newPrincipals.clear();
        J2EEAuthnUtil.zapCreds(subject.getPublicCredentials(), state.newPublicCredentials);
        J2EEAuthnUtil.zapCreds(subject.getPrivateCredentials(), state.newPrivateCredentials);
        if (state.isDebug) {
            AuthnUtil.log(fname + "cleanup successful");
        }
    }

    public Subject defaultTgtLogin(String user, char[] password, String keytab, boolean isDebug) throws LoginException {
        if (isDebug) {
            AuthnUtil.log(fname + "defaultTgtLogin");
        }
        FnceCallbackHandler handler = new FnceCallbackHandler(user != null ? user : "", password != null ? password : new char[]{});
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("debug", isDebug ? "true" : "false");
        String[] opts = null;
        if (user != null && user.length() > 0) {
            if (password == null) {
                options.put("principal", user);
                if (keytab != null) {
                    int plen = this.krb5KeytabPrefix.length();
                    if (plen > 0 && plen < keytab.length() && !this.krb5KeytabPrefix.equals(keytab.substring(0, plen).toUpperCase(Locale.ENGLISH))) {
                        keytab = this.krb5KeytabPrefix + keytab;
                    }
                    options.put(this.krb5KeytabOption, keytab);
                    opts = this.krb5ServiceLoginOptionsKeytab;
                } else {
                    opts = this.krb5ServiceLoginOptions;
                }
            } else {
                opts = this.krb5NormalClientLoginOptions;
            }
        } else {
            opts = this.krb5CachedClientLoginOptions;
        }
        Subject subject = null;
        try {
            AppConfigurationEntry conf = DynLoginContext.buildConf(this.krb5LoginModuleClass, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options, opts);
            DynLoginContext lc = new DynLoginContext((Subject)null, (CallbackHandler)handler, conf, isDebug);
            lc.login();
            subject = lc.getSubject();
        }
        catch (Exception e) {
            if (isDebug) {
                AuthnUtil.log("[J2EEAuthnUtil] TGT login failure", e);
            }
            if (e instanceof LoginException) {
                throw (LoginException)e;
            }
            String msg = ExceptionAuthn.SECURITY_FAILED_DEFAULT_TGT_LOGIN.toString(new Object[]{e.getLocalizedMessage()});
            LoginException ex = new LoginException(msg);
            ex.initCause(e);
            throw ex;
        }
        if (subject == null) {
            String msg = ExceptionAuthn.SECURITY_FAILED_DEFAULT_TGT_LOGIN.toString(new Object[]{ExceptionAuthn.SECURITY_SUBJECT_NULL.toString()});
            if (isDebug) {
                AuthnUtil.log(FNAME + msg);
            }
            throw new LoginException(msg);
        }
        return subject;
    }

    public void addUserPrincipal(LmState state, String name) {
        throw new UnsupportedOperationException();
    }

    public void addGroupPrincipal(LmState state, String name) {
        throw new UnsupportedOperationException();
    }

    public Object runAs(Subject subject, PrivilegedAction action) {
        return Subject.doAs(subject, action);
    }

    public Object runAs(Subject subject, PrivilegedExceptionAction action) throws Exception {
        return Subject.doAs(subject, action);
    }

    public Subject getCurrentSubject() {
        return Subject.getSubject(AccessController.getContext());
    }

    public void fixupCachedSubject(Subject subject) {
    }

    public void handleCallback(Callback callback, Map textValues) throws UnsupportedCallbackException {
        throw new UnsupportedCallbackException(callback);
    }

    public boolean isTicketsSPNToMatchLogins() {
        return false;
    }

    public boolean isCachingNeeded() {
        return false;
    }

    public boolean setupSubjectSecurity(Subject subject) {
        return false;
    }

    protected static void fetchStaticConstants(Class cls, HashMap map) {
        Field[] ff = cls.getDeclaredFields();
        for (int i = 0; i < ff.length; ++i) {
            Field f = ff[i];
            int mod = f.getModifiers();
            if (!Modifier.isStatic(mod) || !Modifier.isPublic(mod)) continue;
            try {
                map.put(f.getName(), f.get(null));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static Object reflectionCall(Method method, Object obj, Object[] args) {
        try {
            return method.invoke(obj, args);
        }
        catch (Exception e) {
            throw J2EEAuthnUtil.processedException(e, method.getDeclaringClass(), method.getName());
        }
    }

    public static Object reflectionConstructor(Class cls) {
        try {
            return cls.newInstance();
        }
        catch (Exception e) {
            throw J2EEAuthnUtil.processedException(e, cls, "<ctor>");
        }
    }

    public static Object reflectionConstructor(Constructor ctor, Object[] args) {
        try {
            return ctor.newInstance(args);
        }
        catch (Exception e) {
            throw J2EEAuthnUtil.processedException(e, ctor.getDeclaringClass(), "<ctor>");
        }
    }

    protected static RuntimeException processedException(Exception e, Class cls, String name) {
        String className = cls.getName();
        int dot = className.lastIndexOf(46);
        if (dot >= 0) {
            className = className.substring(dot + 1);
        }
        String f = util != null ? fname : FNAME;
        Throwable cause = e;
        if (e instanceof InvocationTargetException && e.getCause() != null) {
            cause = e.getCause();
        }
        AuthnUtil.error(f + className + '.' + name + ": " + cause.getLocalizedMessage());
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return J2EEAuthnUtil.wrappedException(e);
    }

    public static IllegalStateException wrappedException(Exception e) {
        return (IllegalStateException)new IllegalStateException(ExceptionAuthn.E_AUTHN_UNEXPECTED_EXCEPTION.toString(new Object[]{e.getLocalizedMessage()})).initCause(e);
    }

    private static void zapCreds(Collection subjCreds, Collection newCreds) {
        for (Object c : newCreds) {
            subjCreds.remove(c);
            AuthnUtil.destroyCred(c);
        }
        newCreds.clear();
    }

    private static final String getPrivilegedProperty(final String propertyName) {
        PrivilegedAction paProp = new PrivilegedAction(){

            public Object run() {
                return System.getProperty(propertyName);
            }
        };
        try {
            return (String)AccessController.doPrivileged(paProp);
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    static {
        appServerType = -1;
        fname = FNAME;
    }

    private static class Init {
        static int appServerType = J2EEType.getAppServerType();
        static J2EEAuthnUtil util;
        static boolean isAlreadyDetected;

        private Init() {
        }

        static {
            if (J2EEType.isUndetermined()) {
                String givenInitCxtFactory = J2EEAuthnUtil.getPrivilegedProperty("java.naming.factory.initial");
                String givenAppServerType = J2EEAuthnUtil.getPrivilegedProperty("com.filenet.AppServerType");
                if (givenAppServerType == null) {
                    givenAppServerType = J2EEAuthnUtil.getPrivilegedProperty("com.filenet.AppServer");
                }
                if (givenAppServerType == null) {
                    try {
                        Properties props = new Properties();
                        URL url = ClassLoader.getSystemResource("FileNet.properties");
                        props.load(url.openStream());
                        givenAppServerType = props.getProperty("com.filenet.AppServerType");
                        if (givenAppServerType == null) {
                            givenAppServerType = props.getProperty("com.filenet.AppServer");
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                appServerType = J2EEType.getAppServerType(givenAppServerType, givenInitCxtFactory);
                isAlreadyDetected = false;
            } else {
                appServerType = J2EEType.getAppServerType();
                isAlreadyDetected = true;
            }
            String handler = null;
            switch (appServerType) {
                case 2: {
                    handler = "com.filenet.apiimpl.authentication.util.J2EEAuthnUtilWL";
                    break;
                }
                case 3: {
                    handler = "com.filenet.apiimpl.authentication.util.J2EEAuthnUtilWS";
                }
            }
            if (handler != null) {
                try {
                    util = (J2EEAuthnUtil)Class.forName(handler).newInstance();
                }
                catch (Exception e) {
                    AuthnUtil.error("[J2EEAuthnUtil] creation of handler failed: " + e.getLocalizedMessage());
                    throw J2EEAuthnUtil.wrappedException(e);
                }
            }
            if (util == null) {
                String msg = ExceptionAuthn.SECURITY_APP_SERVER_NOT_RECOGNIZED.toString(new Object[]{J2EEAuthnUtil.getProviderURL()});
                AuthnUtil.warn(J2EEAuthnUtil.FNAME + msg);
                util = new J2EEAuthnUtil();
                appServerType = 1;
            }
        }
    }
}

