/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.authentication.util;

import com.filenet.apiimpl.authentication.util.AuthnUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class LString
implements Serializable {
    private static final String RES_BASE_NAME = "res/LString";
    protected static final Locale stDefaultLocale = Locale.getDefault();
    private static final String FNAME = "[LString(Authn)] ";
    protected String mKey;
    protected String mEnglishString;
    private static final long serialVersionUID = -4846791583317622768L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0];

    protected LString(String englishString) {
        this.mEnglishString = englishString;
    }

    public String getKey() {
        return this.mKey;
    }

    public String getDefaultEnglishString() {
        return this.mEnglishString;
    }

    public String toString() {
        return this.toString(RES_BASE_NAME, stDefaultLocale, null);
    }

    public static String toString(String englishName, String key, String baseName, Locale locale, Object[] args) {
        LString lString = new LString(englishName);
        lString.setKey(key);
        return lString.toString(baseName, locale, args);
    }

    public String toString(Object[] args) {
        return this.toString(RES_BASE_NAME, stDefaultLocale, args);
    }

    public synchronized String toString(String baseName, Locale le, Object[] args) {
        String formattedString;
        String patternString;
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(baseName, le);
            patternString = bundle.getString(this.mKey);
        }
        catch (MissingResourceException ex) {
            patternString = this.mEnglishString;
            le = Locale.US;
            AuthnUtil.warn("[LString(Authn)] Missing resource file or entry for '" + this.mKey + "': " + ex.getLocalizedMessage());
        }
        try {
            MessageFormat form = new MessageFormat(patternString, le);
            formattedString = form.format(args);
        }
        catch (Exception ex) {
            formattedString = this.mEnglishString;
            AuthnUtil.error("[LString(Authn)] Failed formating resource string:" + patternString + ": " + ex.getLocalizedMessage());
        }
        return formattedString;
    }

    public String toLogString(Object[] args) {
        return this.toString(RES_BASE_NAME, stDefaultLocale, args) + " (" + this.mKey + ")";
    }

    protected String getBaseName() {
        return RES_BASE_NAME;
    }

    protected void setKey(String key) {
        this.mKey = key;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeObject(this.mKey);
        s.writeObject(this.mEnglishString);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.mKey = (String)s.readObject();
        this.mEnglishString = (String)s.readObject();
    }
}

