/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.core;

import com.filenet.api.constants.ConfigurationParameter;
import com.filenet.api.constants.ConnectionType;
import com.filenet.api.core.Connection;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.util.ConfigurationParameters;
import com.filenet.apiimpl.exception.ExceptionContext;
import com.filenet.apiimpl.transport.TraceDetail;
import com.filenet.apiimpl.util.BaseLogger;
import com.filenet.apiimpl.util.ConfigValueLookup;
import com.filenet.apiimpl.util.SubSystem;
import com.filenet.apiimpl.util.classloader.CRCLHelper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.net.URI;
import java.net.URISyntaxException;

public class ConnectionImpl
implements Connection {
    private static final BaseLogger logger = BaseLogger.getBaseLogger(ConnectionImpl.class, SubSystem.API);
    private String uri;
    private transient URI asURI;
    private ConfigurationParameters parameters;
    private String tenant;
    private boolean useBasicAuth = false;
    private boolean allowRemoteConnectionInServer = false;
    private CookieMode cookieMode = CookieMode.BOTH;
    private Integer basePathElemCount = 0;
    private static final String PARAM_TENANTID = "tenantId";
    private static final String PARAM_USEBASICAUTH = "useBasicAuth";
    private static final String PARAM_COOKIEMODE = "cookieMode";
    private static final String PARAM_BASEPATHELEMENTS = "basePathElements";
    private String pathPart = null;
    private String queryPart = null;
    private String providerURLPart = null;
    private boolean isParsedPQ = false;
    private Connection realConnection = null;
    private static boolean saveLastERE = false;
    private static ThreadLocal<EngineRuntimeException> lastERE = new ThreadLocal();
    private static final long serialVersionUID = -689050182764384929L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0];

    public ConnectionImpl() {
        this.init();
    }

    public ConnectionImpl(String URI2) {
        this.setURI(URI2);
    }

    public ConnectionImpl(String URI2, ConfigurationParameters parameters) {
        if (parameters != null) {
            parameters = new ConfigurationParameters(parameters);
        }
        this.parameters = parameters;
        this.setURI(URI2);
    }

    public void setURI(String URI2) {
        if (this.realConnection != null) {
            ((ConnectionImpl)this.realConnection).setURI(URI2);
            return;
        }
        this.uri = URI2;
        this.asURI = null;
        this.init();
    }

    private void init() {
        this.tenant = null;
        this.useBasicAuth = false;
        this.cookieMode = CookieMode.BOTH;
        this.basePathElemCount = 0;
        this.uri = this.uri != null ? this.uri.trim() : null;
        try {
            if (this.uri != null && this.asURI == null) {
                this.asURI = new URI(this.uri);
            } else if (this.asURI != null && this.uri == null) {
                this.uri = this.asURI.toString();
            }
        }
        catch (URISyntaxException e) {
            throw new EngineRuntimeException(e, ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, new Object[]{"overRideURI"});
        }
        if (this.parameters == null) {
            this.parameters = new ConfigurationParameters();
        } else {
            this.validateParameters(this.parameters);
        }
        String query = this.getQuery();
        if (query != null) {
            String[] queryParts = query.split("&");
            for (int i = 0; i < queryParts.length; ++i) {
                String candidate;
                String[] queryPart = queryParts[i].split("=");
                if (queryPart.length <= 1) continue;
                if (queryPart[0].equals(PARAM_TENANTID)) {
                    int slashInx = (candidate = queryPart[1].trim()).indexOf("/");
                    this.tenant = candidate.substring(0, slashInx >= 0 ? slashInx : candidate.length());
                    continue;
                }
                if (queryPart[0].equals(PARAM_USEBASICAUTH)) {
                    candidate = queryPart[1].trim();
                    this.useBasicAuth = candidate.equalsIgnoreCase("true") || candidate.equalsIgnoreCase("yes");
                    continue;
                }
                if (queryPart[0].equals(PARAM_COOKIEMODE)) {
                    this.parseCookieMode(queryPart[1].trim());
                    continue;
                }
                if (!queryPart[0].equals(PARAM_BASEPATHELEMENTS)) continue;
                candidate = queryPart[1].trim();
                try {
                    this.basePathElemCount = Integer.parseInt(candidate);
                    if (this.basePathElemCount >= 0 && this.basePathElemCount <= 5) continue;
                    throw new NumberFormatException();
                }
                catch (NumberFormatException e) {
                    throw new EngineRuntimeException(e, ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, new Object[]{PARAM_BASEPATHELEMENTS});
                }
            }
        }
        if (logger.isDetailTraceEnabled()) {
            Throwable t = new Throwable();
            StackTraceElement caller = TraceDetail.getClientMethodInfo(t);
            if (caller != null) {
                logger.traceDetail("conn:(from " + caller + ") " + this);
            } else {
                String fCaller = TraceDetail.getNearestCallers(t, 2, 3);
                logger.traceDetail("conn:(from " + fCaller + ") " + this);
            }
        }
    }

    private void parseCookieMode(String mode) {
        if (mode.equalsIgnoreCase("both")) {
            this.cookieMode = CookieMode.BOTH;
        } else if (mode.equalsIgnoreCase("exclusive")) {
            this.cookieMode = CookieMode.EXCLUSIVE;
        } else if (mode.equalsIgnoreCase("never")) {
            this.cookieMode = CookieMode.NEVER;
        }
    }

    public boolean useBasicAuth() {
        return this.useBasicAuth;
    }

    public CookieMode getCookieMode() {
        return this.cookieMode;
    }

    public Integer getBasePathElemCount() {
        return this.basePathElemCount;
    }

    @Override
    public synchronized Object getParameter(ConfigurationParameter parameter) {
        if (this.realConnection != null) {
            return this.realConnection.getParameter(parameter);
        }
        if (parameter == ConfigurationParameter.WSI_TRANSPORT_CONNECTION_TIMEOUT) {
            CRCLHelper.finesseWsiCredential(this);
        }
        return this.parameters.getParameter(parameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Object setParameter(ConfigurationParameter parameter, Object value) {
        if (this.realConnection != null) {
            return this.realConnection.setParameter(parameter, value);
        }
        Object previous = this.parameters.getParameter(parameter);
        boolean failed = true;
        try {
            this.parameters.setParameter(parameter, value);
            this.validateParameters(this.parameters);
            failed = false;
        }
        finally {
            if (failed) {
                this.parameters.setParameter(parameter, previous);
            }
        }
        return previous;
    }

    @Override
    public synchronized void setParameters(ConfigurationParameters parameters) {
        if (this.realConnection != null) {
            this.realConnection.setParameters(parameters);
            return;
        }
        if (parameters == null) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_ARGUMENT, "parameters");
        }
        ConfigurationParameters candidate = new ConfigurationParameters(this.parameters);
        candidate.setParameters(parameters);
        this.validateParameters(candidate);
        this.parameters = candidate;
    }

    public synchronized ConfigurationParameters getParameters() {
        if (this.realConnection != null) {
            return ((ConnectionImpl)this.realConnection).getParameters();
        }
        if (this.parameters == null) {
            return null;
        }
        return new ConfigurationParameters(this.parameters);
    }

    private void validateParameters(ConfigurationParameters parms) {
        ConnectionType connectionType;
        boolean soap;
        if (this.realConnection != null) {
            ((ConnectionImpl)this.realConnection).validateParameters(parms);
        }
        boolean bl = soap = (connectionType = this.getConnectionType()) == ConnectionType.SOAP;
        if (soap && ConfigValueLookup.getBoolean(parms, ConfigurationParameter.CONNECTION_PARTICIPATES_IN_TRANSACTION, false)) {
            throw new EngineRuntimeException(ExceptionCode.API_INVALID_CONNECTION_PARAMETER, new Object[]{ConfigurationParameter.CONNECTION_PARTICIPATES_IN_TRANSACTION.toString()}, ExceptionContext.API_CONNECTION_PARAMETER_NOT_SUPPORTED_FOR_URI, new Object[]{this.uri});
        }
    }

    private void parsePathAndQuery() {
        if (this.isParsedPQ) {
            return;
        }
        if (this.asURI == null) {
            return;
        }
        String schemaSpecificPart = this.asURI.getRawSchemeSpecificPart();
        if (schemaSpecificPart == null) {
            return;
        }
        if (!this.asURI.isOpaque()) {
            this.pathPart = this.asURI.getPath();
            this.queryPart = this.asURI.getQuery();
            this.providerURLPart = this.asURI.getScheme() + "://" + this.asURI.getAuthority();
        } else {
            int firstSlash = schemaSpecificPart.indexOf(47);
            int firstQuestionMark = schemaSpecificPart.indexOf(63);
            if (firstSlash < 0 && firstQuestionMark < 0) {
                this.pathPart = null;
                this.queryPart = null;
                this.providerURLPart = this.asURI.toString();
            } else {
                int firstSorQ = 0;
                firstSorQ = firstSlash >= 0 ? (firstQuestionMark >= 0 ? Math.min(firstQuestionMark, firstSlash) : firstSlash) : firstQuestionMark;
                this.providerURLPart = this.asURI.getScheme() + ":" + schemaSpecificPart.substring(0, firstSorQ);
                String crudless = schemaSpecificPart.substring(firstSorQ);
                if (crudless.charAt(0) == '?') {
                    this.pathPart = null;
                    this.queryPart = crudless.substring(1);
                } else {
                    URI fakeFileURI;
                    try {
                        fakeFileURI = new URI("file:" + crudless);
                    }
                    catch (URISyntaxException e) {
                        throw new EngineRuntimeException(e, ExceptionCode.API_INVALID_URI, new Object[]{this.asURI.toString()});
                    }
                    this.pathPart = fakeFileURI.getPath();
                    this.queryPart = fakeFileURI.getQuery();
                }
            }
        }
        this.isParsedPQ = true;
    }

    public String getPath() {
        if (this.realConnection != null) {
            return ((ConnectionImpl)this.realConnection).getPath();
        }
        this.parsePathAndQuery();
        return this.pathPart;
    }

    public String getQuery() {
        if (this.realConnection != null) {
            return ((ConnectionImpl)this.realConnection).getQuery();
        }
        this.parsePathAndQuery();
        return this.queryPart;
    }

    public String getProviderURL() {
        if (this.realConnection != null) {
            return ((ConnectionImpl)this.realConnection).getProviderURL();
        }
        this.parsePathAndQuery();
        return this.providerURLPart;
    }

    @Override
    public String getURI() {
        if (this.realConnection != null) {
            return this.realConnection.getURI();
        }
        return this.uri;
    }

    public URI getAsURI() {
        if (this.realConnection != null) {
            return ((ConnectionImpl)this.realConnection).getAsURI();
        }
        return this.asURI;
    }

    public String getTenant() {
        if (this.realConnection != null) {
            return ((ConnectionImpl)this.realConnection).getTenant();
        }
        return this.tenant;
    }

    public synchronized boolean participatesInTransaction() {
        if (this.realConnection != null) {
            return ((ConnectionImpl)this.realConnection).participatesInTransaction();
        }
        if (this.getConnectionType() == ConnectionType.SOAP) {
            return false;
        }
        return ConfigValueLookup.getBooleanDefault(this.parameters, ConfigurationParameter.CONNECTION_PARTICIPATES_IN_TRANSACTION, false);
    }

    @Override
    public ConnectionType getConnectionType() {
        if (this.realConnection != null) {
            return this.realConnection.getConnectionType();
        }
        if (this.uri == null || this.uri.length() < 4) {
            return null;
        }
        if (this.uri.substring(0, 4).equalsIgnoreCase("http")) {
            return ConnectionType.SOAP;
        }
        return ConnectionType.EJB;
    }

    public void setAllowRemoteConnectionInServer(boolean allowRemoteConnectionInServer) {
        this.allowRemoteConnectionInServer = allowRemoteConnectionInServer;
    }

    public boolean allowRemoteConnectionInServer() {
        return this.allowRemoteConnectionInServer;
    }

    public boolean equals(Object object) {
        if (this.realConnection != null) {
            return this.realConnection.equals(object);
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof ConnectionImpl)) {
            return false;
        }
        ConnectionImpl other = (ConnectionImpl)object;
        return this.uri == other.uri || this.uri != null && this.uri.equalsIgnoreCase(other.uri);
    }

    public int hashCode() {
        if (this.realConnection != null) {
            return this.realConnection.hashCode();
        }
        int result = 17;
        result = 37 * result + (this.uri != null ? this.uri.toLowerCase().hashCode() : 0);
        return result;
    }

    public synchronized String toString() {
        if (this.realConnection != null) {
            return "@" + this.realConnection.toString();
        }
        StringBuffer sb = new StringBuffer(128);
        sb.append(this.getClass().getSimpleName()).append("@0x").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(" URI=").append(this.uri);
        sb.append(" tenant=").append(this.tenant);
        sb.append(" Parameters=").append(this.parameters);
        return sb.toString();
    }

    public void setRealConnection(Connection realConnection) {
        this.realConnection = realConnection;
    }

    public Connection getRealConnection() {
        return this.realConnection;
    }

    public static synchronized void setSaveLastERE(boolean saveLastERE) {
        ConnectionImpl.saveLastERE = saveLastERE;
    }

    public static boolean isSaveLastERE() {
        return saveLastERE;
    }

    public static void setLastERE(EngineRuntimeException theERE) {
        lastERE.set(theERE);
    }

    public static EngineRuntimeException getLastERE() {
        EngineRuntimeException ere = lastERE.get();
        ConnectionImpl.setLastERE(null);
        return ere;
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.writeInt(20);
        s.writeObject(this.uri);
        s.writeObject(this.parameters);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.readInt();
        this.uri = (String)s.readObject();
        this.parameters = (ConfigurationParameters)s.readObject();
        this.init();
    }

    public static enum CookieMode {
        EXCLUSIVE,
        BOTH,
        NEVER;

    }
}

