/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.core;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.util.ConfigValueLookup;
import java.lang.reflect.Method;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextOutputCallback;

class UserPasswordCallback
implements CallbackHandler {
    private String userName;
    private String password;
    private String providerURL;
    final boolean useLocalAuthentication = ConfigValueLookup.getValueAsBoolean("com.filenet.api.useLocalAuthentication", false);
    private static String webLogicCallBackClassName = "weblogic.security.auth.callback.URLCallback";

    public UserPasswordCallback(String userName, String password, String providerURL) {
        this.userName = userName;
        this.password = password;
        this.providerURL = providerURL;
    }

    @Override
    public void handle(Callback[] callbacks) {
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof TextOutputCallback) {
                TextOutputCallback toc = (TextOutputCallback)callbacks[i];
                switch (toc.getMessageType()) {
                    case 0: {
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                continue;
            }
            if (callbacks[i].getClass().getName().equals(webLogicCallBackClassName)) {
                this.callWebLogicSetURL(callbacks[i]);
                continue;
            }
            if (callbacks[i] instanceof NameCallback) {
                NameCallback nc = (NameCallback)callbacks[i];
                nc.setName(this.userName);
                continue;
            }
            if (!(callbacks[i] instanceof PasswordCallback)) continue;
            PasswordCallback pc = (PasswordCallback)callbacks[i];
            pc.setPassword(this.password.toCharArray());
        }
    }

    private void callWebLogicSetURL(Callback obj) {
        if (this.useLocalAuthentication) {
            return;
        }
        Class<?> webLogicCallBack = null;
        Class[] params = new Class[]{String.class};
        Method method = null;
        String providerURLToUse = this.providerURL != null ? this.providerURL : ConfigValueLookup.getValue("Engine", null);
        try {
            webLogicCallBack = obj.getClass();
            method = webLogicCallBack.getMethod("setURL", params);
            Object[] args = new Object[]{providerURLToUse};
            method.invoke((Object)obj, args);
        }
        catch (Throwable t) {
            if (t instanceof EngineRuntimeException) {
                throw (EngineRuntimeException)t;
            }
            if (t.getCause() instanceof EngineRuntimeException) {
                throw (EngineRuntimeException)t.getCause();
            }
            throw new EngineRuntimeException(t, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
    }
}

