/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.jdbc;

import com.filenet.api.collection.ClassDescriptionSet;
import com.filenet.api.collection.PropertyDescriptionList;
import com.filenet.api.collection.RepositoryRowSet;
import com.filenet.api.constants.MergeMode;
import com.filenet.api.core.Domain;
import com.filenet.api.core.Factory;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.jdbc.Driver;
import com.filenet.api.meta.ClassDescription;
import com.filenet.api.meta.MetadataCache;
import com.filenet.api.meta.PropertyDescription;
import com.filenet.api.meta.PropertyDescriptionBinary;
import com.filenet.api.meta.PropertyDescriptionBoolean;
import com.filenet.api.meta.PropertyDescriptionDateTime;
import com.filenet.api.meta.PropertyDescriptionFloat64;
import com.filenet.api.meta.PropertyDescriptionId;
import com.filenet.api.meta.PropertyDescriptionInteger32;
import com.filenet.api.meta.PropertyDescriptionObject;
import com.filenet.api.meta.PropertyDescriptionString;
import com.filenet.api.property.FilterElement;
import com.filenet.api.property.Property;
import com.filenet.api.property.PropertyBinary;
import com.filenet.api.property.PropertyBinaryList;
import com.filenet.api.property.PropertyBoolean;
import com.filenet.api.property.PropertyBooleanList;
import com.filenet.api.property.PropertyDateTime;
import com.filenet.api.property.PropertyDateTimeList;
import com.filenet.api.property.PropertyDependentObjectList;
import com.filenet.api.property.PropertyEngineObject;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.property.PropertyFloat64;
import com.filenet.api.property.PropertyFloat64List;
import com.filenet.api.property.PropertyId;
import com.filenet.api.property.PropertyIdList;
import com.filenet.api.property.PropertyIndependentObjectSet;
import com.filenet.api.property.PropertyInteger32;
import com.filenet.api.property.PropertyInteger32List;
import com.filenet.api.property.PropertyString;
import com.filenet.api.property.PropertyStringList;
import com.filenet.api.query.RepositoryRow;
import com.filenet.api.query.SearchSQL;
import com.filenet.api.query.SearchScope;
import com.filenet.api.util.UserContext;
import com.filenet.apiimpl.jdbc.DaphneConnection;
import com.filenet.apiimpl.jdbc.DatabaseMetaData;
import com.filenet.apiimpl.jdbc.Field;
import com.filenet.apiimpl.jdbc.NotImplemented;
import com.filenet.apiimpl.jdbc.NotSupported;
import com.filenet.apiimpl.jdbc.QueryParser;
import com.filenet.apiimpl.jdbc.ResultSet;
import com.filenet.apiimpl.jdbc.Statement;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.Subject;

public class Connection
implements InvocationHandler {
    private java.sql.Connection proxiedInstance = null;
    private java.sql.DatabaseMetaData dbmd = null;
    private boolean isClosed = false;
    private boolean readOnly = true;
    private DaphneConnection dConn = null;
    private SearchScope scope = null;
    private MergeMode mergeMode = MergeMode.UNION;
    private String[] objectStoresList = null;
    private static final PropertyFilter OS_PF = new PropertyFilter();
    private Map typeMap = new HashMap();
    private static final PropertyFilter QUERY_PF;
    private static MetadataCache CMC;
    private static final PropertyFilter SCD_PF;
    private static final Pattern localePattern;

    public static java.sql.Connection newInstance(Properties p, String s, Driver d) throws SQLException {
        Connection instance = new Connection(p, s, d);
        instance.proxiedInstance = (java.sql.Connection)Proxy.newProxyInstance(instance.getClass().getClassLoader(), new Class[]{java.sql.Connection.class}, (InvocationHandler)instance);
        return instance.proxiedInstance;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws SQLException {
        return Connection.invokeProxiedMethod(proxy, method, args);
    }

    java.sql.Connection getProxiedInstance() {
        return this.proxiedInstance;
    }

    protected static Object invokeProxiedMethod(Object proxy, Method method, Object[] args) throws SQLException {
        String methodName = method.getName();
        InvocationHandler h = Proxy.getInvocationHandler(proxy);
        Class<?> hClass = h.getClass();
        Method[] hMethods = hClass.getMethods();
        for (int mm = 0; mm < hMethods.length; ++mm) {
            Class<?>[] hParamTypes;
            Class<?>[] paramTypes;
            Method hMethod = hMethods[mm];
            if (!hMethod.getName().equals(methodName)) continue;
            Class<?> hReturnType = hMethod.getReturnType();
            Class<?> returnType = method.getReturnType();
            if (!returnType.isAssignableFrom(hReturnType) || (paramTypes = method.getParameterTypes()).length != (hParamTypes = hMethod.getParameterTypes()).length) continue;
            boolean paramTypesOK = true;
            for (int cc = 0; cc < hParamTypes.length; ++cc) {
                Class<?> paramType = paramTypes[cc];
                Class<?> hParamtype = hParamTypes[cc];
                if (paramType.isAssignableFrom(hParamtype)) continue;
                paramTypesOK = false;
                break;
            }
            if (!paramTypesOK) continue;
            return Connection.invokeRealMethod(h, hMethod, args);
        }
        throw new NotImplemented(h, method.getName());
    }

    private static Object invokeRealMethod(InvocationHandler h, Method hMethod, Object[] args) throws SQLException {
        try {
            return hMethod.invoke((Object)h, args);
        }
        catch (InvocationTargetException e) {
            Throwable tgt = e.getTargetException();
            if (tgt instanceof SQLException) {
                throw (SQLException)tgt;
            }
            SQLException sqlException = new SQLException();
            sqlException.initCause(tgt);
            throw sqlException;
        }
        catch (Throwable t) {
            if (t instanceof SQLException) {
                throw (SQLException)t;
            }
            SQLException sqlException = new SQLException();
            sqlException.initCause(t);
            throw sqlException;
        }
    }

    private Connection(Properties info, String url, Driver d) throws SQLException {
        try {
            String user = info.getProperty("user");
            String password = info.getProperty("password");
            String objectStoresString = info.getProperty("objectstores");
            this.objectStoresList = objectStoresString.split("\\|");
            String uri = info.getProperty("uri");
            String propMergeMode = info.getProperty("mergemode");
            if ("INTERSECTION".equalsIgnoreCase(propMergeMode)) {
                this.mergeMode = MergeMode.INTERSECTION;
            }
            String jassConfigName = info.getProperty("jaasconfigname");
            String localeString = info.getProperty("locale");
            Locale locale = Connection.toLocale(localeString);
            this.dConn = new DaphneConnection(uri, user, password, jassConfigName, locale);
            this.connect();
        }
        catch (SQLException sqlEx) {
            throw sqlEx;
        }
        catch (EngineRuntimeException eRe) {
            SQLException sqlEx = new SQLException(eRe.getLocalizedMessage());
            sqlEx.initCause(eRe);
            throw sqlEx;
        }
        catch (Exception ex) {
            Object[] params = new Object[]{url};
            EngineRuntimeException eRe = new EngineRuntimeException(ExceptionCode.JDBC_CONNECT_ERROR, params);
            eRe.initCause(ex);
            SQLException sqlEx = new SQLException(eRe.getLocalizedMessage());
            sqlEx.initCause(eRe);
            throw sqlEx;
        }
    }

    private void connect() throws SQLException {
        try {
            this.scope = this.createSearchScope(this.dConn.getDomain());
            this.dbmd = DatabaseMetaData.newInstance(this, this.scope);
        }
        catch (SQLException sqlEx) {
            throw sqlEx;
        }
        catch (EngineRuntimeException eRe) {
            SQLException sqlEx = new SQLException(eRe.getLocalizedMessage());
            sqlEx.initCause(eRe);
            throw sqlEx;
        }
        catch (Exception ex) {
            Object[] params = new Object[]{this.dConn.getConnection().getURI()};
            EngineRuntimeException eRe = new EngineRuntimeException(ExceptionCode.JDBC_CONNECT_ERROR, params);
            eRe.initCause(ex);
            SQLException sqlEx = new SQLException(eRe.getLocalizedMessage());
            sqlEx.initCause(eRe);
            throw sqlEx;
        }
    }

    private SearchScope createSearchScope(Domain domain) throws SQLException {
        SearchScope newScope = null;
        UserContext uc = UserContext.get();
        uc.setLocale(this.dConn.getLocale());
        Subject pushedSubject = this.dConn.getSubject();
        try {
            int objectStoreArraySize = this.objectStoresList.length;
            ObjectStore[] objectStores = new ObjectStore[objectStoreArraySize];
            int j = 0;
            if (pushedSubject != null) {
                uc.pushSubject(pushedSubject);
            }
            ObjectStore objStore1 = null;
            for (int i = 0; i < this.objectStoresList.length; ++i) {
                String objectStoreName = this.objectStoresList[i];
                objStore1 = Factory.ObjectStore.fetchInstance(domain, objectStoreName, OS_PF);
                int accessAllowed = objStore1.getAccessAllowed();
                if ((accessAllowed & 0x100000) != 0x100000) {
                    Object[] params = new Object[]{objectStoreName};
                    EngineRuntimeException eRe = new EngineRuntimeException(ExceptionCode.JDBC_CONNECT_ACCESS_ERROR, params);
                    SQLException sqlEx = new SQLException(eRe.getLocalizedMessage());
                    sqlEx.initCause(eRe);
                    throw sqlEx;
                }
                objectStores[j++] = objStore1;
            }
            newScope = objectStores.length > 1 ? new SearchScope(objectStores, this.mergeMode) : new SearchScope(objStore1);
        }
        catch (EngineRuntimeException eRe) {
            SQLException sqlEx = new SQLException(eRe.getLocalizedMessage());
            sqlEx.initCause(eRe);
            throw sqlEx;
        }
        catch (Exception ex) {
            Object[] params = new Object[]{this.dConn.getConnection().getURI()};
            EngineRuntimeException eRe = new EngineRuntimeException(ExceptionCode.JDBC_CONNECT_ERROR, params);
            eRe.initCause(ex);
            SQLException sqlEx = new SQLException(eRe.getLocalizedMessage());
            throw sqlEx;
        }
        finally {
            if (pushedSubject != null) {
                uc.popSubject();
            }
        }
        return newScope;
    }

    public void changeUser(String userName, String newPassword) throws SQLException {
        String url = this.dConn.getConnection().getURI();
        String jaasConfigName = this.dConn.getJaasConfigName();
        this.dConn = new DaphneConnection(url, userName, newPassword, jaasConfigName, this.dConn.getLocale());
    }

    public void clearWarnings() {
    }

    public synchronized void close() {
        this.isClosed = true;
    }

    public void commit() {
    }

    public java.sql.Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007, 2);
    }

    public java.sql.Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createStatement(resultSetType, resultSetConcurrency, 2);
    }

    public java.sql.Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return Statement.newInstance(this, null, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public boolean getAutoCommit() {
        return false;
    }

    public void setAutoCommit(boolean autoCommitFlag) {
    }

    public String getCatalog() {
        return null;
    }

    public int getHoldability() {
        return 1;
    }

    public java.sql.DatabaseMetaData getMetaData() {
        return this.dbmd;
    }

    public int getTransactionIsolation() {
        return 0;
    }

    public synchronized Map getTypeMap() {
        return this.typeMap;
    }

    public synchronized boolean isClosed() {
        return this.isClosed;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public String nativeSQL(String sql) {
        return sql;
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.prepareCall(sql, 0, 0, 0);
    }

    public synchronized CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareCall(sql, resultSetType, resultSetConcurrency, 0);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new NotImplemented(this, "prepareCall").getSE();
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 0);
    }

    public PreparedStatement prepareStatement(String sql, int autoGenKeyIndex) throws SQLException {
        throw new NotImplemented(this, "prepareStatement").getSE();
    }

    public synchronized PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, 0);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new NotImplemented(this, "prepareStatement").getSE();
    }

    public PreparedStatement prepareStatement(String sql, int[] autoGenKeyIndexes) throws SQLException {
        throw new NotImplemented(this, "prepareStatement").getSE();
    }

    public PreparedStatement prepareStatement(String sql, String[] autoGenKeyColNames) throws SQLException {
        throw new NotImplemented(this, "prepareStatement").getSE();
    }

    public void rollback() {
    }

    public void setCatalog(String catalog) {
    }

    public void setHoldability(int arg0) {
    }

    public void setReadOnly(boolean readOnlyFlag) {
        this.readOnly = readOnlyFlag;
    }

    public Savepoint setSavepoint() throws SQLException {
        throw new NotSupported(this, "setSavepoint").getSE();
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        throw new NotSupported(this, "setSavepoint").getSE();
    }

    public void setTransactionIsolation(int level) {
    }

    public synchronized void setTypeMap(Map map) {
        this.typeMap = map;
    }

    public SQLWarning getWarnings() {
        return null;
    }

    public void releaseSavepoint(Savepoint arg0) throws SQLException {
        throw new NotSupported(this, "releaseSavePoint").getSE();
    }

    public void rollback(Savepoint arg0) throws SQLException {
        throw new NotSupported(this, "rollback").getSE();
    }

    public java.sql.ResultSet execSQL(Statement callingStatement, String sql) throws SQLException {
        UserContext uc = UserContext.get();
        uc.setLocale(this.dConn.getLocale());
        Subject pushedSubject = this.dConn.getSubject();
        try {
            if (pushedSubject != null) {
                uc.pushSubject(pushedSubject);
            }
            java.sql.ResultSet resultSet = this.execSQLInternal(callingStatement, sql);
            return resultSet;
        }
        catch (SQLException sqlEx) {
            throw sqlEx;
        }
        catch (EngineRuntimeException eRe) {
            SQLException sqlEx = new SQLException(eRe.getLocalizedMessage());
            sqlEx.initCause(eRe);
            throw sqlEx;
        }
        catch (Exception ex) {
            Object[] params = new Object[]{sql};
            EngineRuntimeException eRe = new EngineRuntimeException(ExceptionCode.JDBC_QUERY_NOT_EXECUTED_ERROR, params);
            eRe.initCause(ex);
            SQLException sqlEx = new SQLException(eRe.getLocalizedMessage());
            sqlEx.initCause(eRe);
            throw sqlEx;
        }
        finally {
            if (pushedSubject != null) {
                uc.popSubject();
            }
        }
    }

    private java.sql.ResultSet execSQLInternal(Statement callingStatement, String sql) throws SQLException {
        SearchSQL searchSQL = new SearchSQL();
        searchSQL.setQueryString(sql);
        RepositoryRowSet rowCollection = this.getSearchScope().fetchRows(searchSQL, null, QUERY_PF, Boolean.TRUE);
        Iterator iter = rowCollection.iterator();
        Field[] fields = this.getFields(rowCollection, sql);
        java.sql.ResultSet results = ResultSet.newInstance(fields, this, callingStatement, iter);
        return results;
    }

    private Field[] getFields(RepositoryRowSet rowCollection, String sql) throws SQLException {
        Field[] fields = null;
        try {
            Iterator iter = rowCollection.iterator();
            if (iter.hasNext()) {
                String[] fromClasses = new QueryParser(sql).getFromClasses();
                SearchScope sscope = this.getSearchScope();
                Vector scdVector = Connection.buildSCDVector(sscope, fromClasses);
                fields = this.getFieldsFromFirstResultRow((RepositoryRow)iter.next(), scdVector);
            } else {
                fields = this.getFieldsFromParsedSql(sql);
            }
        }
        catch (EngineRuntimeException eRe) {
            SQLException sqlEx = new SQLException(eRe.getLocalizedMessage());
            sqlEx.initCause(eRe);
            throw sqlEx;
        }
        return fields;
    }

    private Field[] getFieldsForStar(QueryParser.SelectItem selectItem, String[] fromClasses, Vector scdVector) throws SQLException {
        SearchScope sscope = this.getSearchScope();
        ObjectStore[] objectStores = sscope.getObjectStores();
        for (int odex = 0; odex < objectStores.length; ++odex) {
            ObjectStore objectStore = objectStores[odex];
            for (int i = 0; i < fromClasses.length; ++i) {
                ClassDescription cd = CMC.getClassDescription(objectStore, fromClasses[i]);
                if (cd == null) continue;
                PropertyDescriptionList pds = cd.get_PropertyDescriptions();
                PropertyDescriptionList spds = cd.get_ProperSubclassPropertyDescriptions();
                ArrayList theBigList = new ArrayList();
                theBigList.addAll(pds);
                theBigList.addAll(spds);
                Field[] fields = new Field[theBigList.size()];
                int fieldNum = 0;
                for (PropertyDescription pd : theBigList) {
                    String name = pd.get_SymbolicName();
                    int type = Connection.daphnePropertyDescriptionClassToSqlDataType(pd);
                    int maxLen = Connection.daphnePropertyDescriptionClassToSqlLength(name, scdVector);
                    fields[fieldNum++] = new Field("", name, type, maxLen);
                }
                return fields;
            }
        }
        return new Field[0];
    }

    private PropertyDescription getFieldPD(String name, String[] fromClasses) throws SQLException {
        SearchScope sscope = this.getSearchScope();
        ObjectStore[] objectStores = sscope.getObjectStores();
        for (int odex = 0; odex < objectStores.length; ++odex) {
            ObjectStore objectStore = objectStores[odex];
            for (int i = 0; i < fromClasses.length; ++i) {
                ClassDescription cd = CMC.getClassDescription(objectStore, fromClasses[i]);
                if (cd == null) {
                    return null;
                }
                PropertyDescriptionList pds = cd.get_PropertyDescriptions();
                for (PropertyDescription pd : pds) {
                    if (!name.equalsIgnoreCase(pd.get_SymbolicName())) continue;
                    return pd;
                }
            }
        }
        return null;
    }

    private Field[] getFieldsFromParsedSql(String sql) throws SQLException {
        QueryParser qp = new QueryParser(sql);
        QueryParser.SelectItem[] selectItems = qp.getSelectList();
        if (selectItems == null || selectItems.length == 0) {
            return null;
        }
        Field[] fields = new Field[selectItems.length];
        String[] fromClasses = qp.getFromClasses();
        int fieldNum = 0;
        SearchScope sscope = this.getSearchScope();
        Vector scdVector = Connection.buildSCDVector(sscope, fromClasses);
        for (int i = 0; i < selectItems.length; ++i) {
            QueryParser.SelectItem selectItem = selectItems[i];
            if (selectItem.propName.indexOf(42) >= 0) {
                Field[] starFields = this.getFieldsForStar(selectItem, fromClasses, scdVector);
                Field[] newFields = new Field[fields.length + starFields.length - 1];
                System.arraycopy(fields, 0, newFields, 0, fieldNum);
                System.arraycopy(starFields, 0, newFields, fieldNum, starFields.length);
                fieldNum += starFields.length;
                fields = newFields;
                continue;
            }
            String name = selectItem.alias;
            if (name == null || name.length() == 0) {
                name = selectItem.propName;
            }
            PropertyDescription pd = this.getFieldPD(selectItem.propName, fromClasses);
            int type = Connection.daphnePropertyDescriptionClassToSqlDataType(pd);
            int maxLen = Connection.daphnePropertyDescriptionClassToSqlLength(name, scdVector);
            fields[fieldNum++] = new Field("", name, type, maxLen);
        }
        return fields;
    }

    private static int daphnePropertyDescriptionClassToSqlDataType(PropertyDescription pd) {
        int type = 12;
        if (pd instanceof PropertyDescriptionString) {
            type = 12;
        } else if (pd instanceof PropertyDescriptionInteger32) {
            type = 4;
        } else if (pd instanceof PropertyDescriptionBinary) {
            type = -2;
        } else if (pd instanceof PropertyDescriptionBoolean) {
            type = 16;
        } else if (pd instanceof PropertyDescriptionDateTime) {
            type = 93;
        } else if (pd instanceof PropertyDescriptionId) {
            type = 12;
        } else if (pd instanceof PropertyDescriptionFloat64) {
            type = 6;
        } else if (pd instanceof PropertyDescriptionObject) {
            type = 12;
        }
        return type;
    }

    private static int daphnePropertyClassToSqlDataType(Property property) {
        int type = 12;
        if (property instanceof PropertyString || property instanceof PropertyStringList) {
            type = 12;
        } else if (property instanceof PropertyInteger32 || property instanceof PropertyInteger32List) {
            type = 4;
        } else if (property instanceof PropertyBinary || property instanceof PropertyBinaryList) {
            type = -2;
        } else if (property instanceof PropertyBoolean || property instanceof PropertyBooleanList) {
            type = 16;
        } else if (property instanceof PropertyDateTime || property instanceof PropertyDateTimeList) {
            type = 93;
        } else if (property instanceof PropertyId || property instanceof PropertyIdList) {
            type = 12;
        } else if (property instanceof PropertyFloat64 || property instanceof PropertyFloat64List) {
            type = 6;
        } else if (property instanceof PropertyEngineObject || property instanceof PropertyIndependentObjectSet || property instanceof PropertyDependentObjectList) {
            type = 12;
        }
        return type;
    }

    private Field[] getFieldsFromFirstResultRow(RepositoryRow rr, Vector scdVector) {
        com.filenet.api.property.Properties props = rr.getProperties();
        Iterator propIter = props.iterator();
        int numOfProperties = props.size();
        Field[] fields = new Field[numOfProperties];
        int fieldNum = 0;
        while (propIter.hasNext()) {
            Property property = (Property)propIter.next();
            String name = property.getPropertyName();
            int type = Connection.daphnePropertyClassToSqlDataType(property);
            int maxLen = Connection.daphnePropertyDescriptionClassToSqlLength(name, scdVector);
            fields[fieldNum++] = new Field("", name, type, maxLen);
        }
        return fields;
    }

    private static int daphnePropertyDescriptionClassToSqlLength(String propName, Vector scdVector) {
        int maxLen = 255;
        boolean bFound = false;
        for (ArrayList pdList : scdVector) {
            for (PropertyDescription pd : pdList) {
                if (!(pd instanceof PropertyDescriptionString) && !(pd instanceof PropertyDescriptionBinary) || !propName.equalsIgnoreCase(pd.get_SymbolicName())) continue;
                Integer length = null;
                com.filenet.api.property.Properties props = pd.getProperties();
                if (pd instanceof PropertyDescriptionString && props.isPropertyPresent("MaximumLengthString")) {
                    length = props.getInteger32Value("MaximumLengthString");
                } else if (pd instanceof PropertyDescriptionBinary && props.isPropertyPresent("MaximumLengthBinary")) {
                    length = props.getInteger32Value("MaximumLengthBinary");
                }
                if (length == null) break;
                maxLen = length;
                bFound = true;
                break;
            }
            if (!bFound) continue;
            break;
        }
        return maxLen;
    }

    private static Vector buildSCDVector(SearchScope sscope, String[] fromClasses) {
        ClassDescriptionSet scd = sscope.fetchSearchableClassDescriptions(fromClasses, SCD_PF);
        Vector scdVector = new Vector();
        Iterator cdIter = scd.iterator();
        while (cdIter.hasNext()) {
            ClassDescription cd = (ClassDescription)cdIter.next();
            ArrayList pdList = new ArrayList();
            PropertyDescriptionList pds = cd.get_PropertyDescriptions();
            pdList.addAll(pds);
            pds = cd.get_ProperSubclassPropertyDescriptions();
            pdList.addAll(pds);
            scdVector.add(pdList);
        }
        return scdVector;
    }

    protected String getUser() {
        return this.dConn.getUser();
    }

    private SearchScope getSearchScope() throws SQLException {
        if (this.scope == null) {
            this.scope = this.createSearchScope(this.dConn.getDomain());
        }
        return this.scope;
    }

    protected Subject getSubject() {
        return this.dConn.getSubject();
    }

    protected Locale getLocale() {
        return this.dConn.getLocale();
    }

    private static final Locale toLocale(String localeString) {
        if (localeString == null) {
            return null;
        }
        Matcher m = localePattern.matcher(localeString);
        Locale locale = null;
        if (m.matches()) {
            String variant;
            String region;
            String lang = m.group(1);
            if (lang == null) {
                lang = "";
            }
            if ((region = m.group(2)) == null) {
                region = "";
            }
            if ((variant = m.group(3)) == null) {
                variant = "";
            }
            locale = new Locale(lang, region, variant);
            return locale;
        }
        EngineRuntimeException ere = new EngineRuntimeException(ExceptionCode.E_INVALID_LOCALE_FORMAT, localeString);
        throw ere;
    }

    static {
        OS_PF.addIncludeProperty(1, null, null, "Id", null);
        QUERY_PF = new PropertyFilter();
        QUERY_PF.setMaxRecursion(1);
        QUERY_PF.addIncludeProperty(new FilterElement((Integer)1, null, null, ".fake.scalar.to.limit.results.", null));
        CMC = Factory.MetadataCache.getDefaultInstance();
        SCD_PF = new PropertyFilter();
        SCD_PF.addIncludeProperty(2, null, null, "PropertyDescriptions", null);
        SCD_PF.addIncludeProperty(2, null, null, "ProperSubclassPropertyDescriptions", null);
        SCD_PF.addIncludeProperty(2, null, null, "SymbolicName", null);
        SCD_PF.addIncludeProperty(2, null, null, "MaximumLengthString", null);
        SCD_PF.addIncludeProperty(2, null, null, "MaximumLengthBinary", null);
        localePattern = Pattern.compile("^(\\p{Alpha}{0,8})(?:[-_](\\p{Alnum}{0,8}))?(?:[-_](.*))?$");
    }
}

