/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.jdbc;

import com.filenet.api.core.Connection;
import com.filenet.api.core.Domain;
import com.filenet.api.core.Factory;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.util.UserContext;
import java.sql.SQLException;
import java.util.Locale;
import javax.security.auth.Subject;

class DaphneConnection {
    private Domain domain = null;
    private Subject subject = null;
    private String user = null;
    private String jaasConfigName = null;
    private Locale locale = null;

    protected DaphneConnection(String url, String username, String password, String jaasConfigName, Locale locale) throws SQLException {
        this.jaasConfigName = jaasConfigName;
        this.user = username;
        this.locale = locale;
        try {
            Connection conn2 = Factory.Connection.getConnection(url);
            if (!jaasConfigName.equals("!")) {
                this.subject = UserContext.createSubject(conn2, username, password, jaasConfigName);
            }
            this.domain = Factory.Domain.getInstance(conn2, null);
        }
        catch (EngineRuntimeException eRe) {
            SQLException sqlEx = new SQLException(eRe.getLocalizedMessage());
            sqlEx.initCause(eRe);
            throw sqlEx;
        }
        catch (Exception ex) {
            Object[] params = new Object[]{url, username, password};
            EngineRuntimeException eRe = new EngineRuntimeException(ExceptionCode.JDBC_QUERY_NOT_EXECUTED_ERROR, params);
            eRe.initCause(ex);
            SQLException sqlEx = new SQLException(eRe.getLocalizedMessage());
            sqlEx.initCause(eRe);
            throw sqlEx;
        }
    }

    protected Domain getDomain() {
        return this.domain;
    }

    protected String getUser() {
        return this.user;
    }

    protected String getJaasConfigName() {
        return this.jaasConfigName;
    }

    protected Subject getSubject() {
        return this.subject;
    }

    protected Connection getConnection() {
        return this.domain.getConnection();
    }

    public Locale getLocale() {
        return this.locale != null ? this.locale : Locale.getDefault();
    }
}

