/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.property;

import com.filenet.api.collection.BinaryList;
import com.filenet.api.collection.BooleanList;
import com.filenet.api.collection.DateTimeList;
import com.filenet.api.collection.DependentObjectList;
import com.filenet.api.collection.EngineCollection;
import com.filenet.api.collection.Float64List;
import com.filenet.api.collection.IdList;
import com.filenet.api.collection.IndependentObjectSet;
import com.filenet.api.collection.Integer32List;
import com.filenet.api.collection.StringList;
import com.filenet.api.constants.PropertyState;
import com.filenet.api.core.Connection;
import com.filenet.api.core.EngineObject;
import com.filenet.api.core.ObjectReference;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.property.FilterElement;
import com.filenet.api.property.Property;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.util.Id;
import com.filenet.apiimpl.collection.Lists;
import com.filenet.apiimpl.constants.ListMode;
import com.filenet.apiimpl.core.ConnectionImpl;
import com.filenet.apiimpl.core.EngineObjectImpl;
import com.filenet.apiimpl.core.GlobalIdentity;
import com.filenet.apiimpl.core.ListImpl;
import com.filenet.apiimpl.core.ObjectReferenceBase;
import com.filenet.apiimpl.core.ObjectRetriever;
import com.filenet.apiimpl.core.RepositoryIdentity;
import com.filenet.apiimpl.core.Session;
import com.filenet.apiimpl.core.SetImpl;
import com.filenet.apiimpl.property.PropertiesImpl;
import com.filenet.apiimpl.property.PropertyBinaryImpl;
import com.filenet.apiimpl.property.PropertyBinaryListImpl;
import com.filenet.apiimpl.property.PropertyBooleanImpl;
import com.filenet.apiimpl.property.PropertyBooleanListImpl;
import com.filenet.apiimpl.property.PropertyContentImpl;
import com.filenet.apiimpl.property.PropertyDateTimeImpl;
import com.filenet.apiimpl.property.PropertyDateTimeListImpl;
import com.filenet.apiimpl.property.PropertyEngineObjectImpl;
import com.filenet.apiimpl.property.PropertyEngineObjectListImpl;
import com.filenet.apiimpl.property.PropertyFloat64Impl;
import com.filenet.apiimpl.property.PropertyFloat64ListImpl;
import com.filenet.apiimpl.property.PropertyIdImpl;
import com.filenet.apiimpl.property.PropertyIdListImpl;
import com.filenet.apiimpl.property.PropertyInteger32Impl;
import com.filenet.apiimpl.property.PropertyInteger32ListImpl;
import com.filenet.apiimpl.property.PropertyStringImpl;
import com.filenet.apiimpl.property.PropertyStringListImpl;
import com.filenet.apiimpl.property.PropertyUpdateList;
import com.filenet.apiimpl.property.UnevaluatedPropertyValue;
import com.filenet.apiimpl.util.BinaryInputStream;
import com.filenet.apiimpl.util.BinaryOutputStream;
import com.filenet.apiimpl.util.DelegateInputStream;
import com.filenet.apiimpl.util.DelegateOutputStream;
import com.filenet.apiimpl.util.SessionLocator;
import com.filenet.apiimpl.util.UtilityMap;
import com.filenet.apiimpl.util.XMLTraceReader;
import com.filenet.apiimpl.util.XMLTraceable;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public abstract class PropertyImpl
extends UtilityMap.SelfKeyedMember
implements Property,
Cloneable,
XMLTraceable,
Comparable {
    protected boolean isDirty;
    protected byte access;
    protected Object value;
    protected String propertyName;
    protected Connection connection;
    private boolean readOnly = false;
    private static final long serialVersionUID = -8346445280909594938L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0];
    public static final short IS_NULL = 16;
    public static final short IS_DIRTY = 32;
    public static final short IS_MULTI_VALUE = 64;
    public static final short IS_DEPENDENT = 128;
    public static final short IS_TYPE_BINARY = 1;
    public static final short IS_TYPE_BOOLEAN = 2;
    public static final short IS_TYPE_DATETIME = 3;
    public static final short IS_TYPE_FLOAT64 = 4;
    public static final short IS_TYPE_ID = 5;
    public static final short IS_TYPE_INTEGER32 = 6;
    public static final short IS_TYPE_ENGINEOBJECT = 7;
    public static final short IS_TYPE_STRING = 8;
    public static final short IS_TYPE_CONTENT = 9;
    public static final short IS_TYPE_UPDATE = 10;

    protected PropertyImpl(String pName, Object val, byte accessMask) {
        this.value = val;
        this.access = accessMask;
        this.propertyName = pName;
        this.isDirty = true;
    }

    protected PropertyImpl(PropertyImpl source) {
        this.access = source.access;
        this.connection = source.connection;
        this.isDirty = source.isDirty;
        this.propertyName = source.propertyName;
        this.value = source.value;
    }

    public Object clone() {
        try {
            PropertyImpl clone = (PropertyImpl)super.clone();
            if (this.value != null) {
                if (this.value instanceof EngineObjectImpl) {
                    clone.value = ((EngineObjectImpl)this.value).clone();
                } else if (this.value instanceof ListImpl) {
                    clone.value = ((ListImpl)this.value).clone();
                } else if (this.value instanceof ObjectReferenceBase) {
                    clone.value = ((ObjectReferenceBase)this.value).clone();
                }
            }
            return clone;
        }
        catch (Throwable t) {
            throw new EngineRuntimeException(t, ExceptionCode.E_OBJECT_CLONE_FAILED, null);
        }
    }

    @Override
    public Object getMembershipKey() {
        return this.propertyName;
    }

    @Override
    public void setObjectValue(Object val) {
        if (!(val == null || val instanceof String || val instanceof Date || val instanceof Integer || val instanceof Boolean || val instanceof Double || val instanceof byte[] || val instanceof Id || val instanceof EngineObject || val instanceof InputStream || val instanceof ListImpl || val instanceof ObjectReferenceBase)) {
            throw new EngineRuntimeException(ExceptionCode.API_UNSUPPORTED_PROPERTY_TYPE, val.getClass().getName());
        }
        this.setValue(val);
    }

    protected void setValue(Object val) {
        this.checkSettable();
        this.value = val;
        this.isDirty = true;
    }

    protected void checkSettable() {
        PropertiesImpl.checkSettable(this);
    }

    protected List initListValue(List list, Class type) {
        if (list == null) {
            list = Lists.createList(type, null);
        }
        if (list instanceof ListImpl) {
            ListImpl internal = (ListImpl)list;
            if (internal.hasBeenAttached()) {
                internal = (ListImpl)internal.clone();
                list = internal;
                internal.setDirty(true);
            }
            internal.setHasBeenAttached(true);
            internal.setListMode(ListMode.REPLACE);
        }
        return list;
    }

    protected void constructListValue(List list, Class type) {
        this.value = this.initListValue(list, type);
    }

    protected void setListValue(List list, Class type) {
        this.setValue(this.initListValue(list, type));
    }

    PropertyImpl getModifiedData(EngineObject parent) {
        return this.isDirty() ? this : null;
    }

    public ListImpl.ListUpdates getUpdateListValue() {
        if (this instanceof PropertyUpdateList) {
            return (ListImpl.ListUpdates)this.value;
        }
        if (this.value instanceof ListImpl) {
            return ((ListImpl)this.value).getListUpdates();
        }
        return null;
    }

    public ListImpl.ListUpdates getUpdateListValueWithImplicitMoves() {
        if (this.value instanceof ListImpl) {
            return ((ListImpl)this.value).getListUpdatesWithImplicitMoves();
        }
        if (this.value instanceof ListImpl.ListUpdates) {
            return (ListImpl.ListUpdates)this.value;
        }
        return null;
    }

    @Override
    public synchronized Object getObjectValue() {
        this.value = this.getObjectValue(this.value);
        return this.value;
    }

    protected Object getObjectValue(Object v) {
        ListImpl list;
        if (v instanceof ObjectReferenceBase) {
            v = this.fetchValue(v);
        } else if (v instanceof EngineRuntimeException) {
            throw (EngineRuntimeException)v;
        }
        if (v instanceof ListImpl && !PropertiesImpl.isSettable(this) && !(list = (ListImpl)v).isReadOnly()) {
            list.setReadOnly(true);
            this.propagatePropertyAccess();
        }
        return v;
    }

    protected Object fetchValue(Object v) {
        if (v instanceof ObjectRetriever) {
            PropertyImpl pi = this.fetchProperty((ObjectRetriever)v, this.getPropertyName());
            return pi.value;
        }
        if (v instanceof UnevaluatedPropertyValue) {
            PropertyImpl tProp;
            UnevaluatedPropertyValue up = (UnevaluatedPropertyValue)v;
            if (up.getParentReference() instanceof ObjectRetriever) {
                PropertyImpl pi = this.fetchProperty((ObjectRetriever)((Object)up.getParentReference()), up.getPropertyName());
                return pi.value;
            }
            PropertyFilter pf = null;
            if (this instanceof PropertyEngineObjectListImpl) {
                pf = new PropertyFilter();
                pf.setLevelDependents(true);
            }
            return (tProp = this.getSession().getProperty((ConnectionImpl)this.connection, up, null, pf, null)) != null ? tProp.value : null;
        }
        if (v instanceof ObjectReferenceBase) {
            return this.getSession().getObject((ConnectionImpl)this.connection, (ObjectReferenceBase)v, null, null);
        }
        throw new EngineRuntimeException(ExceptionCode.API_PROPERTY_FETCH_FAILED, this.getPropertyName());
    }

    public void resetPropertyAccess(byte accessMask) {
        this.access = accessMask;
    }

    public void setPropertyAccess(byte accessMask) {
        this.access = (byte)(this.access & accessMask);
    }

    public byte getPropertyAccess() {
        return this.access;
    }

    public void propagatePropertyAccess() {
    }

    private PropertyImpl fetchProperty(ObjectRetriever or, String pName) {
        EngineObject eo = or.getObject(this.connection, this.getFilter(pName));
        if (eo.getProperties().isPropertyPresent(this.getPropertyName())) {
            return (PropertyImpl)eo.getProperties().get(pName);
        }
        return null;
    }

    private PropertyFilter getFilter(String pName) {
        PropertyFilter filter = new PropertyFilter();
        filter.addIncludeProperty(new FilterElement(null, null, null, pName, null));
        filter.setMaxRecursion(1);
        return filter;
    }

    protected Session getSession() {
        return SessionLocator.getSession(this.connection);
    }

    @Override
    public String getStringValue() {
        if (this.value == null) {
            return null;
        }
        if (!(this.value instanceof String) || !(this instanceof PropertyStringImpl)) {
            throw new EngineRuntimeException(ExceptionCode.API_INVALID_PROPERTY_TYPE, new Object[]{this.getClass().getName(), PropertyStringImpl.class.getName()});
        }
        return (String)this.value;
    }

    @Override
    public Date getDateTimeValue() {
        if (this.value == null) {
            return null;
        }
        if (!(this.value instanceof Date) || !(this instanceof PropertyDateTimeImpl)) {
            throw new EngineRuntimeException(ExceptionCode.API_INVALID_PROPERTY_TYPE, new Object[]{this.getClass().getName(), PropertyDateTimeImpl.class.getName()});
        }
        return (Date)this.value;
    }

    @Override
    public Integer getInteger32Value() {
        if (this.value == null) {
            return null;
        }
        if (!(this.value instanceof Integer) || !(this instanceof PropertyInteger32Impl)) {
            throw new EngineRuntimeException(ExceptionCode.API_INVALID_PROPERTY_TYPE, new Object[]{this.getClass().getName(), PropertyInteger32Impl.class.getName()});
        }
        return (Integer)this.value;
    }

    @Override
    public Boolean getBooleanValue() {
        if (this.value == null) {
            return null;
        }
        if (!(this.value instanceof Boolean) || !(this instanceof PropertyBooleanImpl)) {
            throw new EngineRuntimeException(ExceptionCode.API_INVALID_PROPERTY_TYPE, new Object[]{this.getClass().getName(), PropertyBooleanImpl.class.getName()});
        }
        return (Boolean)this.value;
    }

    @Override
    public Double getFloat64Value() {
        if (this.value == null) {
            return null;
        }
        if (!(this.value instanceof Double) || !(this instanceof PropertyFloat64Impl)) {
            throw new EngineRuntimeException(ExceptionCode.API_INVALID_PROPERTY_TYPE, new Object[]{this.getClass().getName(), PropertyFloat64Impl.class.getName()});
        }
        return (Double)this.value;
    }

    @Override
    public byte[] getBinaryValue() {
        if (this.value == null) {
            return null;
        }
        if (!(this.value instanceof byte[]) || !(this instanceof PropertyBinaryImpl)) {
            throw new EngineRuntimeException(ExceptionCode.API_INVALID_PROPERTY_TYPE, new Object[]{this.getClass().getName(), PropertyBinaryImpl.class.getName()});
        }
        return (byte[])this.value;
    }

    @Override
    public Id getIdValue() {
        if (this.value == null) {
            return null;
        }
        if (this.value instanceof Id) {
            return (Id)this.value;
        }
        if (this.value instanceof RepositoryIdentity) {
            return ((RepositoryIdentity)this.value).getObjectId();
        }
        if (this.value instanceof GlobalIdentity) {
            return ((GlobalIdentity)this.value).getObjectId();
        }
        if (this.value instanceof EngineObjectImpl) {
            return ((EngineObjectImpl)this.value).getObjectId();
        }
        throw new EngineRuntimeException(ExceptionCode.API_INVALID_PROPERTY_TYPE, new Object[]{this.getClass().getName(), PropertyIdImpl.class.getName()});
    }

    @Override
    public EngineObject getEngineObjectValue() {
        Object v = this.getObjectValue();
        if (v == null) {
            return null;
        }
        if (!(v instanceof EngineObject) || !(this instanceof PropertyEngineObjectImpl)) {
            throw new EngineRuntimeException(ExceptionCode.API_INVALID_PROPERTY_TYPE, new Object[]{this.getClass().getName(), PropertyEngineObjectImpl.class.getName()});
        }
        return (EngineObject)v;
    }

    @Override
    public DependentObjectList getDependentObjectListValue() {
        Object v = this.getObjectValue();
        if (v == null) {
            return null;
        }
        if (!(v instanceof DependentObjectList)) {
            throw new EngineRuntimeException(ExceptionCode.API_INVALID_PROPERTY_TYPE, new Object[]{this.getClass().getName(), DependentObjectList.class.getName()});
        }
        return (DependentObjectList)v;
    }

    @Override
    public IndependentObjectSet getIndependentObjectSetValue() {
        Object v = this.getObjectValue();
        if (v == null) {
            return null;
        }
        if (!(v instanceof IndependentObjectSet)) {
            throw new EngineRuntimeException(ExceptionCode.API_INVALID_PROPERTY_TYPE, new Object[]{this.getClass().getName(), IndependentObjectSet.class.getName()});
        }
        return (IndependentObjectSet)v;
    }

    @Override
    public StringList getStringListValue() {
        if (this.getObjectValue(this.value) == null) {
            return null;
        }
        if (!(this.value instanceof StringList) || !(this instanceof PropertyStringListImpl)) {
            throw new EngineRuntimeException(ExceptionCode.API_INVALID_PROPERTY_TYPE, new Object[]{this.getClass().getName(), PropertyStringListImpl.class.getName()});
        }
        return (StringList)this.value;
    }

    @Override
    public BooleanList getBooleanListValue() {
        if (this.getObjectValue(this.value) == null) {
            return null;
        }
        if (!(this.value instanceof BooleanList) || !(this instanceof PropertyBooleanListImpl)) {
            throw new EngineRuntimeException(ExceptionCode.API_INVALID_PROPERTY_TYPE, new Object[]{this.getClass().getName(), PropertyBooleanListImpl.class.getName()});
        }
        return (BooleanList)this.value;
    }

    @Override
    public Integer32List getInteger32ListValue() {
        if (this.getObjectValue(this.value) == null) {
            return null;
        }
        if (!(this.value instanceof Integer32List) || !(this instanceof PropertyInteger32ListImpl)) {
            throw new EngineRuntimeException(ExceptionCode.API_INVALID_PROPERTY_TYPE, new Object[]{this.getClass().getName(), PropertyInteger32ListImpl.class.getName()});
        }
        return (Integer32List)this.value;
    }

    @Override
    public Float64List getFloat64ListValue() {
        if (this.getObjectValue(this.value) == null) {
            return null;
        }
        if (!(this.value instanceof Float64List) || !(this instanceof PropertyFloat64ListImpl)) {
            throw new EngineRuntimeException(ExceptionCode.API_INVALID_PROPERTY_TYPE, new Object[]{this.getClass().getName(), PropertyFloat64ListImpl.class.getName()});
        }
        return (Float64List)this.value;
    }

    @Override
    public DateTimeList getDateTimeListValue() {
        if (this.getObjectValue(this.value) == null) {
            return null;
        }
        if (!(this.value instanceof DateTimeList) || !(this instanceof PropertyDateTimeListImpl)) {
            throw new EngineRuntimeException(ExceptionCode.API_INVALID_PROPERTY_TYPE, new Object[]{this.getClass().getName(), PropertyDateTimeListImpl.class.getName()});
        }
        return (DateTimeList)this.value;
    }

    @Override
    public BinaryList getBinaryListValue() {
        if (this.getObjectValue(this.value) == null) {
            return null;
        }
        if (!(this.value instanceof BinaryList) || !(this instanceof PropertyBinaryListImpl)) {
            throw new EngineRuntimeException(ExceptionCode.API_INVALID_PROPERTY_TYPE, new Object[]{this.getClass().getName(), PropertyBinaryListImpl.class.getName()});
        }
        return (BinaryList)this.value;
    }

    @Override
    public IdList getIdListValue() {
        if (this.getObjectValue(this.value) == null) {
            return null;
        }
        if (!(this.value instanceof IdList) || !(this instanceof PropertyIdListImpl)) {
            throw new EngineRuntimeException(ExceptionCode.API_INVALID_PROPERTY_TYPE, new Object[]{this.getClass().getName(), PropertyIdListImpl.class.getName()});
        }
        return (IdList)this.value;
    }

    @Override
    public InputStream getInputStreamValue() {
        if (this.value == null) {
            return null;
        }
        if (this instanceof PropertyContentImpl && this.value instanceof byte[]) {
            this.value = new ByteArrayInputStream((byte[])this.value);
        }
        if (!(this.value instanceof InputStream) || !(this instanceof PropertyContentImpl)) {
            throw new EngineRuntimeException(ExceptionCode.API_INVALID_PROPERTY_TYPE, new Object[]{this.getClass().getName(), PropertyContentImpl.class.getName()});
        }
        return (InputStream)this.value;
    }

    @Override
    public EngineRuntimeException getRetrievalErrorValue() {
        if (this.value instanceof EngineRuntimeException) {
            return (EngineRuntimeException)this.value;
        }
        return null;
    }

    public ObjectReference getObjectReference() {
        if (this.value instanceof ObjectReference) {
            return (ObjectReference)this.value;
        }
        if (this.value instanceof EngineObjectImpl) {
            return ((EngineObjectImpl)this.value).getObjectReference();
        }
        if (this.value == null) {
            return null;
        }
        throw new EngineRuntimeException(ExceptionCode.API_INVALID_PROPERTY_TYPE, new Object[]{this.value.getClass().getName(), this.getClass().getName()});
    }

    public int hashCode() {
        int hash = this.propertyName.hashCode();
        if (this.value != null) {
            hash ^= this.value.hashCode();
        }
        return hash;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof PropertyImpl)) {
            return false;
        }
        PropertyImpl v = (PropertyImpl)object;
        String vpropName = v.propertyName;
        if (this.propertyName == null && vpropName != null) {
            return false;
        }
        if (this.propertyName != null && vpropName == null) {
            return false;
        }
        if (this.propertyName != null && !this.propertyName.equalsIgnoreCase(vpropName)) {
            return false;
        }
        Object vvalue = v.value;
        if (vvalue == this.value) {
            return true;
        }
        if (this.value == null && vvalue != null) {
            return false;
        }
        if (this.value != null && vvalue == null) {
            return false;
        }
        if (this.value != null) {
            return this.value.equals(vvalue);
        }
        return true;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propName) {
        this.propertyName = propName;
    }

    @Override
    public boolean isSettable() {
        if (this.value instanceof SetImpl) {
            return false;
        }
        return this.access != 1;
    }

    @Override
    public boolean isDirty() {
        if (this.value instanceof ListImpl) {
            return this.isDirty ? this.isDirty : ((ListImpl)this.value).isDirty();
        }
        return this.isDirty;
    }

    public void setDirty(boolean val) {
        if (this.value instanceof ListImpl) {
            ((ListImpl)this.value).setDirty(val);
        }
        this.isDirty = val;
    }

    @Override
    public PropertyState getState() {
        if (this.value == null) {
            return PropertyState.NO_VALUE;
        }
        if (this.value instanceof ListImpl.ListUpdates) {
            return PropertyState.VALUE;
        }
        if (this.value instanceof EngineCollection && ((EngineCollection)this.value).isEmpty()) {
            return PropertyState.NO_VALUE;
        }
        if (this.value instanceof UnevaluatedPropertyValue) {
            return PropertyState.UNEVALUATED;
        }
        if (this.value instanceof ObjectReference) {
            return PropertyState.REFERENCE;
        }
        if (this.value instanceof EngineRuntimeException) {
            return PropertyState.RETRIEVAL_ERROR;
        }
        return PropertyState.VALUE;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(128);
        sb.append(" Class=");
        sb.append(this.getClass().getName());
        sb.append(" PropertyName=");
        sb.append(this.propertyName);
        sb.append(" Value=");
        sb.append(this.value);
        sb.append(" IsDirty=");
        sb.append(this.isDirty);
        sb.append(" Access=");
        sb.append(this.access);
        sb.append(" State=(");
        sb.append(this.getState());
        sb.append(") Connection=(");
        sb.append(this.connection);
        sb.append(")");
        return sb.toString();
    }

    public Object getInstanceValue() {
        return this.value;
    }

    public void setInstanceValue(Object v) {
        this.value = v;
    }

    public Connection getConnection() {
        return this.connection;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeShort(20);
        s.writeObject(this.connection);
        DelegateOutputStream tos = null;
        tos = s instanceof DelegateOutputStream ? (DelegateOutputStream)s : BinaryOutputStream.getInstance((short)20, s);
        tos.putProperty(this);
        tos.flush();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        short version = s.readShort();
        this.connection = (Connection)s.readObject();
        DelegateInputStream tis = null;
        tis = s instanceof DelegateInputStream ? (DelegateInputStream)s : BinaryInputStream.getInstance(version, s, this.connection);
        PropertyImpl n = tis.getProperty();
        this.isDirty = n.isDirty;
        this.access = n.access;
        this.value = n.value;
        this.propertyName = n.propertyName;
    }

    public int getSerializeMask() {
        return (this.getPropertyAccess() | (this.isDirty() ? 32 : 0) | (this.value == null ? 16 : 0)) << 16;
    }

    public abstract void serializeValue(DelegateOutputStream var1) throws IOException;

    public abstract void deserializeValue(DelegateInputStream var1, Connection var2) throws IOException, ClassNotFoundException;

    @Override
    public void trace(XMLTraceReader reader, String element) throws Exception {
        reader.addAttribute("name", this.propertyName);
        reader.addAttribute("dirty", String.valueOf(this.isDirty));
        reader.addAttribute("access", String.valueOf(this.access));
        reader.startElement(element, this);
        if (this.value == null) {
            reader.addAttribute("null", "true");
            reader.startElement("value");
            reader.endElement("value");
        } else {
            reader.visitObject("value", this.value);
        }
        reader.endElement(element);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public int compareTo(Object obj) {
        if (this == obj) {
            return 0;
        }
        if (obj == null) {
            throw new NullPointerException();
        }
        PropertyImpl that = (PropertyImpl)obj;
        if (this.propertyName != that.propertyName) {
            if (this.propertyName == null) {
                return -1;
            }
            if (that.propertyName == null) {
                return 1;
            }
            int cmpName = this.propertyName.compareToIgnoreCase(that.propertyName);
            if (cmpName != 0) {
                return cmpName;
            }
        }
        return PropertyImpl.compareVal(this.value, that.value, 0);
    }

    private static int compareVal(Object thisVal, Object thatVal, int level) {
        block17: {
            if (thisVal == thatVal) {
                return 0;
            }
            if (thisVal == null) {
                return -1;
            }
            if (thatVal == null) {
                return 1;
            }
            int cmp = 0;
            if (thisVal instanceof Comparable && thatVal instanceof Comparable) {
                Comparable thisComparable = (Comparable)thisVal;
                try {
                    cmp = thisComparable.compareTo(thatVal);
                    if (cmp != 0) {
                        return cmp;
                    }
                    break block17;
                }
                catch (Exception e) {
                    throw new UnsupportedOperationException("Not comparable " + thisVal + " -vs- " + thatVal, e);
                }
            }
            if (level == 0 && thisVal instanceof List && thatVal instanceof List) {
                List thisList = (List)thisVal;
                List thatList = (List)thatVal;
                Iterator thisIter = thisList.iterator();
                Iterator thatIter = thatList.iterator();
                while (thisIter.hasNext()) {
                    if (!thatIter.hasNext()) {
                        return 1;
                    }
                    cmp = PropertyImpl.compareVal(thisIter.next(), thatIter.next(), ++level);
                    if (cmp == 0) continue;
                    return cmp;
                }
                if (thatIter.hasNext()) {
                    return -1;
                }
            } else if (thisVal instanceof byte[] && thatVal instanceof byte[]) {
                cmp = PropertyImpl.compareBytes((byte[])thisVal, (byte[])thatVal);
                if (cmp != 0) {
                    return cmp;
                }
            } else {
                if (thisVal instanceof ObjectReferenceBase && thatVal instanceof ObjectReferenceBase) {
                    ObjectReferenceBase thisOrb = (ObjectReferenceBase)thisVal;
                    ObjectReferenceBase thatOrb = (ObjectReferenceBase)thatVal;
                    return thisOrb.compareTo(thatOrb);
                }
                if (thisVal instanceof EngineObjectImpl && thatVal instanceof EngineObjectImpl) {
                    EngineObjectImpl thisEo = (EngineObjectImpl)thisVal;
                    EngineObjectImpl thatEo = (EngineObjectImpl)thatVal;
                    ObjectReferenceBase thisOrb = (ObjectReferenceBase)thisEo.getObjectReference();
                    ObjectReferenceBase thatOrb = (ObjectReferenceBase)thatEo.getObjectReference();
                    return thisOrb.compareTo(thatOrb);
                }
                throw new UnsupportedOperationException("compareTo " + thisVal + " , " + thatVal);
            }
        }
        return 0;
    }

    private static int compareBytes(byte[] thisBytes, byte[] thatBytes) {
        int thisLen = thisBytes.length;
        int thatLen = thatBytes.length;
        int len = thisLen <= thatLen ? thisLen : thatLen;
        for (int i = 0; i < len; ++i) {
            int cmp = (thisBytes[i] & 0xFF) - (thatBytes[i] & 0xFF);
            if (cmp == 0) continue;
            return cmp;
        }
        return thisLen - thatLen;
    }
}

