/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.query;

import com.filenet.api.collection.ClassDescriptionSet;
import com.filenet.api.collection.IndependentObjectSet;
import com.filenet.api.collection.RepositoryRowSet;
import com.filenet.api.constants.MergeMode;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.query.SearchSQL;
import com.filenet.apiimpl.core.ConnectionImpl;
import com.filenet.apiimpl.core.ObjectStoreImpl;
import com.filenet.apiimpl.core.Session;
import com.filenet.apiimpl.query.Search;
import com.filenet.apiimpl.util.SessionLocator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class RepositorySearch
extends Search {
    private String searchSQL = null;
    private static final long serialVersionUID = -6025344242498636592L;

    public ClassDescriptionSet fetchSearchableClassDescriptions(ObjectStore objectStore, String[] classNames, PropertyFilter filter) {
        if (objectStore == null) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "objectStore");
        }
        if (filter != null) {
            this.setPropertyFilter(filter);
        }
        Session session = SessionLocator.getSession(objectStore.getConnection());
        return session.getSearchMetadata((ConnectionImpl)objectStore.getConnection(), (ObjectStoreImpl)objectStore, classNames, filter);
    }

    public ClassDescriptionSet fetchSearchableClassDescriptions(ObjectStore[] objectStores, MergeMode mergeMode, String[] classNames, PropertyFilter filter) {
        if (objectStores == null || objectStores.length < 1) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "objectStores");
        }
        if (filter != null) {
            this.setPropertyFilter(filter);
        }
        Session session = SessionLocator.getSession(objectStores[0].getConnection());
        ObjectStoreImpl[] osi = new ObjectStoreImpl[objectStores.length];
        for (int lp = 0; lp < objectStores.length; ++lp) {
            osi[lp] = (ObjectStoreImpl)objectStores[lp];
        }
        return session.getSearchMetadata((ConnectionImpl)objectStores[0].getConnection(), osi, mergeMode, classNames, filter);
    }

    public final RepositoryRowSet fetchRows(ObjectStore objectStore, SearchSQL searchSQLVal, Integer pageSize, PropertyFilter filter, Boolean continuable) {
        if (pageSize != null && pageSize < 0) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "pageSize");
        }
        if (objectStore == null) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "objectStore");
        }
        this.searchSQL = searchSQLVal.toString();
        if (filter != null) {
            this.setPropertyFilter(filter);
        }
        if (continuable == null) {
            continuable = Boolean.FALSE;
        }
        Session session = SessionLocator.getSession(objectStore.getConnection());
        return session.fetchRows((ConnectionImpl)objectStore.getConnection(), this, (ObjectStoreImpl)objectStore, pageSize, continuable, null);
    }

    public final RepositoryRowSet fetchRows(ObjectStore[] objectStores, SearchSQL searchSQLVal, MergeMode mergeMode, Integer pageSize, PropertyFilter filter, Boolean continuable) {
        if (pageSize != null && pageSize < 0) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "pageSize");
        }
        if (objectStores == null || objectStores.length < 1) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "objectStores");
        }
        this.searchSQL = searchSQLVal.toString();
        if (filter != null) {
            this.setPropertyFilter(filter);
        }
        if (continuable == null) {
            continuable = Boolean.FALSE;
        }
        Session session = SessionLocator.getSession(objectStores[0].getConnection());
        ObjectStoreImpl[] osi = new ObjectStoreImpl[objectStores.length];
        for (int lp = 0; lp < objectStores.length; ++lp) {
            osi[lp] = (ObjectStoreImpl)objectStores[lp];
        }
        return session.fetchRows((ConnectionImpl)objectStores[0].getConnection(), this, osi, mergeMode, pageSize, continuable, null);
    }

    public final IndependentObjectSet fetchObjects(ObjectStore objectStore, SearchSQL searchSQLVal, Integer pageSize, PropertyFilter filter, Boolean continuable) {
        if (pageSize != null && pageSize < 0) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "pageSize");
        }
        if (objectStore == null) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "objectStore");
        }
        this.searchSQL = searchSQLVal.toString();
        if (filter != null) {
            this.setPropertyFilter(filter);
        }
        if (continuable == null) {
            continuable = Boolean.FALSE;
        }
        Session session = SessionLocator.getSession(objectStore.getConnection());
        return session.fetchObjects((ConnectionImpl)objectStore.getConnection(), this, (ObjectStoreImpl)objectStore, pageSize, continuable, null);
    }

    public final IndependentObjectSet fetchObjects(ObjectStore[] objectStores, SearchSQL searchSQLVal, MergeMode mergeMode, Integer pageSize, PropertyFilter filter, Boolean continuable) {
        if (pageSize != null && pageSize < 0) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "pageSize");
        }
        if (objectStores == null || objectStores.length < 1) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "objectStores");
        }
        this.searchSQL = searchSQLVal.toString();
        if (filter != null) {
            this.setPropertyFilter(filter);
        }
        if (continuable == null) {
            continuable = Boolean.FALSE;
        }
        Session session = SessionLocator.getSession(objectStores[0].getConnection());
        return session.fetchObjects((ConnectionImpl)objectStores[0].getConnection(), this, objectStores, mergeMode, pageSize, continuable, null);
    }

    public final String getSQL() {
        return this.searchSQL;
    }

    public final void setSQL(String searchSQLVal) {
        this.searchSQL = searchSQLVal;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(256);
        sb.append(super.toString());
        sb.append(" Class=");
        sb.append(this.getClass().getName());
        sb.append(" SearchSQL=");
        sb.append(this.searchSQL);
        return sb.toString();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.searchSQL = (String)s.readObject();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeObject(this.searchSQL);
    }
}

