/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.smm;

import com.filenet.apiimpl.smm.Measurement;
import com.filenet.apiimpl.smm.PerformanceTimer;

public class TimerMeasurement
extends Measurement {
    private long startTicks;
    private long stopTicks;

    private static long getCurrentMillisValue() {
        return PerformanceTimer.getMillis();
    }

    public static long getMicros() {
        return TimerMeasurement.getCurrentMillisValue() * 1000L;
    }

    public static long getMillis() {
        return TimerMeasurement.getCurrentMillisValue();
    }

    public TimerMeasurement() {
        this.reset();
    }

    public void reset() {
        this.stopTicks = 0L;
        this.startTicks = 0L;
    }

    public void start() {
        this.startTicks = TimerMeasurement.getCurrentMillisValue();
    }

    public void stop() {
        this.stopTicks = TimerMeasurement.getCurrentMillisValue();
    }

    @Override
    public double getMeasurementValue() {
        return this.getElapsedMillis();
    }

    public long getElapsedMillis() {
        if (this.stopTicks > this.startTicks) {
            return this.stopTicks - this.startTicks;
        }
        return 0L;
    }
}

