/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.transport;

import com.filenet.apiimpl.transport.ClientCallContext;
import com.filenet.apiimpl.transport.Message;
import com.filenet.apiimpl.util.SessionLocator;
import com.filenet.apiimpl.util.XMLHelper;
import com.filenet.apiimpl.util.XMLTraceReader;
import com.filenet.apiimpl.util.XMLTraceable;

public class TraceDetail
implements XMLTraceable {
    private final Message message;
    private final Throwable exception;
    private final long elapsed;
    private final ClientCallContext ccc;
    private boolean clientCallInfo = false;
    private final Throwable callStackWhenConstructed = new Throwable();
    private static String[] excludePackages = new String[]{"com.filenet.apiimpl", "com.filenet.api", "com.filenet.engine", "java", "javax", "org.apache", "sun"};

    TraceDetail(ClientCallContext cccVal, Message request) {
        this.message = request;
        this.exception = null;
        this.elapsed = -1L;
        this.ccc = cccVal;
    }

    TraceDetail(ClientCallContext cccVal, Message request, boolean clientCallInfo) {
        this.message = request;
        this.exception = null;
        this.elapsed = -1L;
        this.ccc = cccVal;
        this.clientCallInfo = clientCallInfo;
    }

    TraceDetail(ClientCallContext cccVal, Message responseVal, long elapsedVal) {
        this.message = responseVal;
        this.exception = null;
        this.elapsed = elapsedVal;
        this.ccc = cccVal;
    }

    TraceDetail(ClientCallContext cccVal, Throwable exceptionVal, long elapsedVal) {
        this.message = null;
        this.exception = exceptionVal;
        this.elapsed = elapsedVal;
        this.ccc = cccVal;
    }

    @Override
    public void trace(XMLTraceReader reader, String element) throws Exception {
        StackTraceElement methodInfo;
        if (this.elapsed == -1L) {
            element = element.trim() + "Request";
        } else {
            element = element.trim() + "Response";
            reader.addAttribute("elapsed", String.valueOf(this.elapsed));
        }
        if (this.ccc != null) {
            if (this.ccc.getParam("tenid") != null) {
                reader.addAttribute("tenantId", (String)((Object)this.ccc.getParam("tenid")));
            }
            reader.addAttribute("clientVersion", String.valueOf(this.ccc.getClientVersion()));
            if (this.ccc.getParam("clitype") != null) {
                reader.addAttribute("clientType", (String)((Object)this.ccc.getParam("clitype")));
            }
            if (this.ccc.getParam("clibuild") != null) {
                reader.addAttribute("clientBuild", (String)((Object)this.ccc.getParam("clibuild")));
            }
            if (this.ccc.getParam("ctid") != null) {
                reader.addAttribute("clientId", (String)((Object)this.ccc.getParam("ctid")));
            }
        }
        if (this.clientCallInfo && (methodInfo = TraceDetail.getClientMethodInfo(this.callStackWhenConstructed)) != null && !SessionLocator.isExecutingInServer()) {
            reader.addAttribute("clientCaller", XMLHelper.encodeText(methodInfo.toString()));
        }
        if (this.exception == null) {
            reader.visitValue(element, this.message);
        } else {
            reader.visitThrowable(element, this.exception);
        }
    }

    public static StackTraceElement getClientMethodInfo(Throwable t) {
        StackTraceElement methodInfo = null;
        if (SessionLocator.isExecutingInServer()) {
            return methodInfo;
        }
        StackTraceElement[] elems = t.getStackTrace();
        for (int i = 0; i < elems.length; ++i) {
            boolean found = false;
            StackTraceElement caller = elems[i];
            for (int j = 0; j < excludePackages.length; ++j) {
                if (!caller.getClassName().startsWith(excludePackages[j])) continue;
                found = true;
                break;
            }
            if (found) continue;
            methodInfo = caller;
            break;
        }
        return methodInfo;
    }

    public static String getNearestCallers(Throwable t, int startAt, int howMany) {
        if (t == null || howMany < 1 || startAt < 0) {
            return null;
        }
        StackTraceElement[] elems = t.getStackTrace();
        if (elems.length == 0) {
            return null;
        }
        howMany = Math.min(howMany, elems.length - startAt);
        String result = null;
        for (int ii = startAt; ii < howMany + startAt; ++ii) {
            StackTraceElement elem = elems[ii];
            result = ii == startAt ? elem.toString() : elem + "=>" + result;
        }
        return result;
    }
}

