/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.transport.comm;

import com.filenet.api.core.Connection;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.util.Id;
import com.filenet.apiimpl.transport.DuplicateObjectCache;
import com.filenet.apiimpl.transport.Message;
import com.filenet.apiimpl.transport.Response;
import com.filenet.apiimpl.transport.comm.CommResponse;
import com.filenet.apiimpl.util.DelegateInputStream;
import com.filenet.apiimpl.util.DelegateOutputStream;
import com.filenet.apiimpl.util.XMLTraceReader;
import com.filenet.apiimpl.util.XMLTraceable;
import java.io.IOException;
import java.io.ObjectStreamField;

public class CommBatchResponse
extends Message
implements Response,
XMLTraceable {
    protected transient CommResponse[] batch;
    protected EngineRuntimeException ert;
    protected Id destServerId;
    protected Long destServerEndTime;
    protected Long destServerElapsedTime;
    private static final long serialVersionUID = 8192086040736208858L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0];

    public CommBatchResponse() {
    }

    public CommBatchResponse(CommResponse[] batchVal) {
        this.batch = batchVal;
    }

    public CommResponse[] getCommBatchResponse() {
        return this.batch;
    }

    public void setCommBatchResponse(CommResponse[] batchVal) {
        this.batch = batchVal;
    }

    public EngineRuntimeException getException() {
        return this.ert;
    }

    public void setException(EngineRuntimeException ert) {
        this.ert = ert;
    }

    @Override
    public int getBatchSize() {
        return this.batch == null ? 0 : this.batch.length;
    }

    public Id getDestServerId() {
        return this.destServerId;
    }

    public void setDestServerId(Id destServerId) {
        this.destServerId = destServerId;
    }

    public Long getDestServerEndTime() {
        return this.destServerEndTime;
    }

    public void setDestServerEndTime(Long destServerEndTime) {
        this.destServerEndTime = destServerEndTime;
    }

    public Long getDestServerElapsedTime() {
        return this.destServerElapsedTime;
    }

    public void setDestServerElapsedTime(Long destServerElapsedTime) {
        this.destServerElapsedTime = destServerElapsedTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeBatch(DelegateOutputStream s) throws IOException {
        int size = this.batch != null ? this.batch.length : 0;
        s.writeInt(size);
        DuplicateObjectCache objCache = s.getObjectCache();
        try {
            for (int lp = 0; lp < size; ++lp) {
                s.setObjectCache(new DuplicateObjectCache());
                CommResponse cr = this.batch[lp];
                s.putObject(cr.getValue());
                s.writeObject(cr.getCorrelationId());
            }
        }
        finally {
            s.setObjectCache(objCache);
        }
        s.writeObject(this.ert);
        s.writeObject(this.destServerId);
        s.writeObject(this.destServerEndTime);
        s.writeObject(this.destServerElapsedTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void readBatch(DelegateInputStream s, Connection conn) throws IOException, ClassNotFoundException {
        int size = s.readInt();
        this.batch = new CommResponse[size];
        DuplicateObjectCache objCache = s.getObjectCache();
        try {
            for (int lp = 0; lp < size; ++lp) {
                s.setObjectCache(new DuplicateObjectCache());
                CommResponse cr = new CommResponse();
                cr.putValue(s.getObject());
                cr.setCorrelationId((String)s.readObject());
                this.batch[lp] = cr;
            }
        }
        finally {
            s.setObjectCache(objCache);
        }
        this.ert = (EngineRuntimeException)s.readObject();
        this.destServerId = (Id)s.readObject();
        this.destServerEndTime = (Long)s.readObject();
        this.destServerElapsedTime = (Long)s.readObject();
    }

    @Override
    public void trace(XMLTraceReader reader, String element) throws Exception {
        this.trace(reader, element, this.batch);
    }
}

