/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.transport.ejb;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.exception.ExceptionContext;
import com.filenet.apiimpl.exception.Exceptions;
import com.filenet.apiimpl.transport.ClientCallContext;
import com.filenet.apiimpl.transport.GetContentRequest;
import com.filenet.apiimpl.transport.GetContentResponse;
import com.filenet.apiimpl.transport.PutContentBatchRequest;
import com.filenet.apiimpl.transport.PutContentBatchResponse;
import com.filenet.apiimpl.transport.TransportLogger;
import com.filenet.apiimpl.transport.ejb.ContentEJBHome;
import com.filenet.apiimpl.transport.ejb.ContentEJBPool;
import com.filenet.apiimpl.transport.ejbstubs.Engine;
import com.filenet.apiimpl.transport.ejbstubs.EngineContent;
import com.filenet.apiimpl.transport.ejbstubs.EngineContentAffinity;
import com.filenet.apiimpl.transport.ejbstubs.EngineContentAffinityHome;
import com.filenet.apiimpl.transport.ejbstubs.EngineContentAffinityLocal;
import com.filenet.apiimpl.transport.ejbstubs.EngineContentAffinityLocalHome;
import com.filenet.apiimpl.transport.ejbstubs.EngineContentHome;
import com.filenet.apiimpl.transport.ejbstubs.EngineContentLocal;
import com.filenet.apiimpl.transport.ejbstubs.EngineContentLocalHome;
import com.filenet.apiimpl.transport.ejbstubs.EngineHome;
import com.filenet.apiimpl.transport.ejbstubs.EngineLocal;
import com.filenet.apiimpl.transport.ejbstubs.EngineLocalHome;
import com.filenet.apiimpl.util.J2EEUtil;
import com.filenet.apiimpl.util.SubSystem;
import java.security.PrivilegedExceptionAction;
import javax.rmi.PortableRemoteObject;
import javax.security.auth.Subject;

public final class ContentEJB {
    private static TransportLogger logger = TransportLogger.getLogger(ContentEJB.class, SubSystem.EJB);
    private Engine eng;
    private EngineLocal engLocal;
    private EngineContent engContent;
    private EngineContentLocal engContentLocal;
    private EngineContentAffinity engContentAffinity;
    private EngineContentAffinityLocal engContentAffinityLocal;
    private Subject runAsSubject;
    private Object ejbHome = null;
    private EjbType ejbType = EjbType.UNKNOWN;
    private Object ejb = null;
    private Boolean useAffinity = false;
    private Long lastActiveTime = null;
    private String conKey = null;
    private EjbOp lastOp = EjbOp.UNKNOWN;
    private boolean isExpired = false;
    private boolean inCall = false;
    private long age = System.currentTimeMillis();

    private ContentEJB(Object ejbHome, boolean useAffinity, EjbOp operation, Subject runAsSubject) {
        this.ejbHome = ejbHome;
        this.useAffinity = useAffinity;
        this.lastOp = operation;
        this.runAsSubject = runAsSubject;
        if (ejbHome == null) {
            logger.error("ContentEJB ejbHome is null for operation: " + (Object)((Object)operation));
            throw new EngineRuntimeException(ExceptionCode.TRANSPORT_EJB_UNABLE_TO_CONNECT, null, ExceptionContext.TRANSPORT_EJB_NULL_CONTENT_EJB, new Object[]{this.ejbType, operation});
        }
    }

    public static ContentEJB getContentUploadEJB(ContentEJBHome contentEjbHome, boolean useAffinity, Subject runAsSubject) {
        ContentEJB contentEjb = new ContentEJB(contentEjbHome, useAffinity, EjbOp.GET_UPLOAD_EJB, runAsSubject);
        contentEjb.setConKey(contentEjbHome.getConKey());
        Object ejbHome = contentEjbHome.getEjbHome();
        try {
            if (contentEjbHome.isLocal()) {
                if (contentEjbHome.isStateful()) {
                    ContentEJB pooledEJB = ContentEJBPool.get(contentEjbHome.getConKey());
                    if (pooledEJB != null) {
                        if (logger.isDetailTraceEnabled()) {
                            logger.traceDetail("ContentEJB.getContentUploadEJB: got a pooled ContentAfinityLocal EJB.");
                        }
                        contentEjb = pooledEJB;
                    } else {
                        if (logger.isDetailTraceEnabled()) {
                            logger.traceDetail("ContentEJB.getContentUploadEJB: creating ContentAfinityLocal EJB.");
                        }
                        if (!(ejbHome instanceof EngineContentAffinityLocalHome)) {
                            String ejbHomeClass = ejbHome == null ? "null" : ejbHome.getClass().getCanonicalName();
                            EngineRuntimeException ert = new EngineRuntimeException(ExceptionCode.TRANSPORT_EJB_UNABLE_TO_CREATE_CONTENT_UPLOAD_EJB, new Object[]{useAffinity, ejbHomeClass, ContentEJB.abbrevStr(ejbHome)});
                            throw ert;
                        }
                        contentEjb.engContentAffinityLocal = ((EngineContentAffinityLocalHome)ejbHome).create();
                        contentEjb.ejbType = EjbType.CONTENT_AFFINITY_LOCAL;
                        contentEjb.ejb = contentEjb.engContentAffinityLocal;
                        ContentEJBPool.put(contentEjbHome.getConKey(), contentEjb);
                    }
                } else {
                    if (logger.isDetailTraceEnabled()) {
                        logger.traceDetail("ContentEJB.getContentUploadEJB: creating ContentLocal EJB.");
                    }
                    if (!(ejbHome instanceof EngineContentLocalHome)) {
                        String ejbHomeClass = ejbHome == null ? "null" : ejbHome.getClass().getCanonicalName();
                        EngineRuntimeException ert = new EngineRuntimeException(ExceptionCode.TRANSPORT_EJB_UNABLE_TO_CREATE_CONTENT_UPLOAD_EJB, new Object[]{useAffinity, ejbHomeClass, ContentEJB.abbrevStr(ejbHome)});
                        throw ert;
                    }
                    contentEjb.engContentLocal = ((EngineContentLocalHome)ejbHome).create();
                    contentEjb.ejbType = EjbType.CONTENT_LOCAL;
                    contentEjb.ejb = contentEjb.engContentLocal;
                }
            } else if (contentEjbHome.isStateful()) {
                ContentEJB pooledEJB = ContentEJBPool.get(contentEjbHome.getConKey());
                if (pooledEJB != null) {
                    if (logger.isDetailTraceEnabled()) {
                        logger.traceDetail("ContentEJB.getContentUploadEJB: got a pooled ContentAfinityRemote EJB.");
                    }
                    contentEjb = pooledEJB;
                } else {
                    if (logger.isDetailTraceEnabled()) {
                        logger.traceDetail("ContentEJB.getContentUploadEJB: creating ContentAfinityRemote EJB.");
                    }
                    EngineContentAffinityHome home = (EngineContentAffinityHome)PortableRemoteObject.narrow((Object)ejbHome, EngineContentAffinityHome.class);
                    contentEjb.engContentAffinity = home.create();
                    contentEjb.ejbType = EjbType.CONTENT_AFFINITY_REMOTE;
                    contentEjb.ejb = contentEjb.engContentAffinity;
                    ContentEJBPool.put(contentEjbHome.getConKey(), contentEjb);
                }
            } else {
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail("ContentEJB.getContentUploadEJB: creating ContentRemote EJB.");
                }
                EngineContentHome home = (EngineContentHome)PortableRemoteObject.narrow((Object)ejbHome, EngineContentHome.class);
                contentEjb.engContent = home.create();
                contentEjb.ejbType = EjbType.CONTENT_REMOTE;
                contentEjb.ejb = contentEjb.engContent;
            }
        }
        catch (EngineRuntimeException ert) {
            String ejbHomeClass;
            String string = ejbHomeClass = ejbHome == null ? "null" : ejbHome.getClass().getCanonicalName();
            if (ert.getExceptionCode() != ExceptionCode.TRANSPORT_EJB_UNABLE_TO_CREATE_CONTENT_UPLOAD_EJB) {
                ert = new EngineRuntimeException((Throwable)ert, ExceptionCode.TRANSPORT_EJB_UNABLE_TO_CREATE_CONTENT_UPLOAD_EJB, new Object[]{useAffinity, ejbHomeClass, ContentEJB.abbrevStr(ejbHome)});
            }
            logger.error(ert);
            throw ert;
        }
        catch (Exception e) {
            String ejbHomeClass = ejbHome == null ? "null" : ejbHome.getClass().getCanonicalName();
            EngineRuntimeException ert = new EngineRuntimeException(e, ExceptionCode.TRANSPORT_EJB_UNABLE_TO_CREATE_CONTENT_UPLOAD_EJB, new Object[]{useAffinity, ejbHomeClass, ContentEJB.abbrevStr(ejbHome)});
            logger.error(ert);
            throw ert;
        }
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("ContentEJB.getContentUploadEJB: returning EJB=" + contentEjb);
        }
        return contentEjb;
    }

    public static ContentEJB getContentDownloadEJB(Object contentEjbHome, Engine engEjb, EngineLocal engLocalEjb, boolean useAffinity, Subject runAsSubject) {
        ContentEJB contentEjb = new ContentEJB(contentEjbHome, useAffinity, EjbOp.GET_DOWNLOAD_EJB, runAsSubject);
        Object ejbHome = contentEjbHome;
        String conKey = null;
        if (contentEjbHome instanceof ContentEJBHome) {
            ejbHome = ((ContentEJBHome)contentEjbHome).getEjbHome();
            conKey = ((ContentEJBHome)contentEjbHome).getConKey();
            contentEjb.setConKey(conKey);
        }
        try {
            if (ejbHome instanceof EngineLocalHome) {
                if (engLocalEjb == null) {
                    if (logger.isDetailTraceEnabled()) {
                        logger.traceDetail("ContentEJB.getContentDownloadEJB: creating EngineLocal EJB.");
                    }
                    contentEjb.engLocal = ((EngineLocalHome)ejbHome).create();
                } else {
                    if (logger.isDetailTraceEnabled()) {
                        logger.traceDetail("ContentEJB.getContentDownloadEJB: using existing EngineLocal EJB.");
                    }
                    contentEjb.engLocal = engLocalEjb;
                }
                contentEjb.ejbType = EjbType.ENGINE_LOCAL;
                contentEjb.ejb = contentEjb.engLocal;
            } else if (ejbHome instanceof EngineContentAffinityLocalHome) {
                ContentEJB pooledEJB;
                boolean gotPooledEjb = false;
                if (conKey != null && (pooledEJB = ContentEJBPool.get(conKey)) != null) {
                    if (logger.isDetailTraceEnabled()) {
                        logger.traceDetail("ContentEJB.getContentDownloadEJB: got a pooled ContentAffinityLocal EJB.");
                    }
                    contentEjb = pooledEJB;
                    gotPooledEjb = true;
                }
                if (!gotPooledEjb) {
                    if (logger.isDetailTraceEnabled()) {
                        logger.traceDetail("ContentEJB.getContentDownloadEJB: creating ContentAffinityLocal EJB.");
                    }
                    contentEjb.engContentAffinityLocal = ((EngineContentAffinityLocalHome)ejbHome).create();
                    contentEjb.ejbType = EjbType.CONTENT_AFFINITY_LOCAL;
                    contentEjb.ejb = contentEjb.engContentAffinityLocal;
                    if (conKey != null) {
                        ContentEJBPool.put(conKey, contentEjb);
                    }
                }
            } else if (ejbHome instanceof EngineContentAffinityHome || useAffinity) {
                ContentEJB pooledEJB;
                boolean gotPooledEjb = false;
                if (conKey != null && (pooledEJB = ContentEJBPool.get(conKey)) != null) {
                    if (logger.isDetailTraceEnabled()) {
                        logger.traceDetail("ContentEJB.getContentDownloadEJB: got a pooled ContentAfinityRemote EJB.");
                    }
                    contentEjb = pooledEJB;
                    gotPooledEjb = true;
                }
                if (!gotPooledEjb) {
                    if (logger.isDetailTraceEnabled()) {
                        logger.traceDetail("ContentEJB.getContentDownloadEJB: creating ContentAfinityRemote EJB.  ejbHome class=[" + ejbHome.getClass().getCanonicalName() + "]; ejbHome=[" + ContentEJB.abbrevStr(ejbHome) + "]");
                    }
                    EngineContentAffinityHome home = (EngineContentAffinityHome)PortableRemoteObject.narrow((Object)ejbHome, EngineContentAffinityHome.class);
                    contentEjb.engContentAffinity = home.create();
                    contentEjb.ejbType = EjbType.CONTENT_AFFINITY_REMOTE;
                    contentEjb.ejb = contentEjb.engContentAffinity;
                    if (conKey != null) {
                        ContentEJBPool.put(conKey, contentEjb);
                    }
                }
            } else {
                if (engEjb == null) {
                    if (logger.isDetailTraceEnabled()) {
                        logger.traceDetail("ContentEJB.getContentDownloadEJB: creating EngineRemote EJB.  ejbHome class=[" + ejbHome.getClass().getCanonicalName() + "]; ejbHome=[" + ContentEJB.abbrevStr(ejbHome) + "]");
                    }
                    EngineHome home = (EngineHome)PortableRemoteObject.narrow((Object)ejbHome, EngineHome.class);
                    contentEjb.eng = home.create();
                } else {
                    if (logger.isDetailTraceEnabled()) {
                        logger.traceDetail("ContentEJB.getContentDownloadEJB: using existing EngineRemote EJB.");
                    }
                    contentEjb.eng = engEjb;
                }
                contentEjb.ejbType = EjbType.ENGINE_REMOTE;
                contentEjb.ejb = contentEjb.eng;
            }
        }
        catch (EngineRuntimeException ert) {
            String ejbHomeClass;
            String string = ejbHomeClass = ejbHome == null ? "null" : ejbHome.getClass().getCanonicalName();
            if (ert.getExceptionCode() != ExceptionCode.TRANSPORT_EJB_UNABLE_TO_CREATE_CONTENT_DOWNLOAD_EJB) {
                ert = new EngineRuntimeException((Throwable)ert, ExceptionCode.TRANSPORT_EJB_UNABLE_TO_CREATE_CONTENT_DOWNLOAD_EJB, new Object[]{useAffinity, ejbHomeClass, ContentEJB.abbrevStr(ejbHome)});
            }
            logger.error(ert);
            throw ert;
        }
        catch (Exception e) {
            String ejbHomeClass = ejbHome == null ? "null" : ejbHome.getClass().getCanonicalName();
            EngineRuntimeException ert = new EngineRuntimeException(e, ExceptionCode.TRANSPORT_EJB_UNABLE_TO_CREATE_CONTENT_DOWNLOAD_EJB, new Object[]{useAffinity, ejbHomeClass, ContentEJB.abbrevStr(ejbHome)});
            logger.error(ert);
            throw ert;
        }
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("ContentEJB.getContentDownloadEJB: returning EJB=" + contentEjb);
        }
        return contentEjb;
    }

    public String getConKey() {
        return this.conKey;
    }

    public void setConKey(String conKey) {
        this.conKey = conKey;
    }

    public boolean isLocal() {
        switch (this.ejbType) {
            case CONTENT_AFFINITY_LOCAL: 
            case CONTENT_LOCAL: 
            case ENGINE_LOCAL: {
                return true;
            }
        }
        return false;
    }

    public boolean isStateful() {
        switch (this.ejbType) {
            case CONTENT_AFFINITY_LOCAL: 
            case CONTENT_AFFINITY_REMOTE: {
                return true;
            }
        }
        return false;
    }

    public PutContentBatchResponse putContent(ClientCallContext clientContext, PutContentBatchRequest req) throws Exception {
        EjbOp op;
        this.lastActiveTime = System.currentTimeMillis();
        this.lastOp = op = EjbOp.PUT_CONTENT;
        switch (this.ejbType) {
            case CONTENT_AFFINITY_REMOTE: {
                this.assertEjbNotNull(this.engContentAffinity, this.ejbType, op);
                return this.engContentAffinity.putContent(clientContext, req);
            }
            case CONTENT_AFFINITY_LOCAL: {
                this.assertEjbNotNull(this.engContentAffinityLocal, this.ejbType, op);
                return this.engContentAffinityLocal.putContent(clientContext, req);
            }
            case CONTENT_REMOTE: {
                this.assertEjbNotNull(this.engContent, this.ejbType, op);
                return this.engContent.putContent(clientContext, req);
            }
            case CONTENT_LOCAL: {
                this.assertEjbNotNull(this.engContentLocal, this.ejbType, op);
                return this.engContentLocal.putContent(clientContext, req);
            }
        }
        logger.error("ContentEJB.putContent: Unexpected ejbType: " + (Object)((Object)this.ejbType));
        throw new EngineRuntimeException(ExceptionCode.TRANSPORT_EJB_UNABLE_TO_CONNECT, null, ExceptionContext.TRANSPORT_EJB_UNEXPECTED_CONTENT_EJB, new Object[]{this.ejbType, op});
    }

    public GetContentResponse getContent(ClientCallContext clientCallContext, GetContentRequest req) throws Exception {
        EjbOp op;
        this.lastActiveTime = System.currentTimeMillis();
        this.lastOp = op = EjbOp.GET_CONTENT;
        switch (this.ejbType) {
            case CONTENT_AFFINITY_REMOTE: {
                this.assertEjbNotNull(this.engContentAffinity, this.ejbType, op);
                return this.engContentAffinity.getContent(req, clientCallContext);
            }
            case CONTENT_AFFINITY_LOCAL: {
                this.assertEjbNotNull(this.engContentAffinityLocal, this.ejbType, op);
                return this.engContentAffinityLocal.getContent(req, clientCallContext);
            }
            case ENGINE_REMOTE: {
                this.assertEjbNotNull(this.eng, this.ejbType, op);
                return this.eng.getContent(req, clientCallContext);
            }
            case ENGINE_LOCAL: {
                this.assertEjbNotNull(this.engLocal, this.ejbType, op);
                return this.engLocal.getContent(req, clientCallContext);
            }
        }
        logger.error("ContentEJB.getContent: Unexpected ejbType: " + (Object)((Object)this.ejbType));
        throw new EngineRuntimeException(ExceptionCode.TRANSPORT_EJB_UNABLE_TO_CONNECT, null, ExceptionContext.TRANSPORT_EJB_UNEXPECTED_CONTENT_EJB, new Object[]{this.ejbType, op});
    }

    Long getLastActiveTime() {
        return this.lastActiveTime;
    }

    long getAge() {
        return this.age;
    }

    public Engine getEngineBean() {
        return this.eng;
    }

    public EngineLocal getEngineLocalBean() {
        return this.engLocal;
    }

    public void remove() throws Exception {
        if (this.isStateful()) {
            if (this.conKey != null) {
                ContentEJBPool.release(this.conKey, this);
            } else {
                this.realRemove();
            }
        } else {
            this.realRemove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callComplete() {
        if (this.useAffinity.booleanValue()) {
            ContentEJB contentEJB = this;
            synchronized (contentEJB) {
                this.inCall = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExpired() {
        boolean expired = false;
        if (this.useAffinity.booleanValue()) {
            ContentEJB contentEJB = this;
            synchronized (contentEJB) {
                expired = this.isExpired;
                if (!expired) {
                    this.inCall = true;
                }
            }
        }
        return expired;
    }

    public void flush() {
        if (this.useAffinity.booleanValue()) {
            ContentEJBPool.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void realRemove() throws Exception {
        if (this.inCall) {
            return;
        }
        this.isExpired = true;
        switch (this.ejbType) {
            case CONTENT_AFFINITY_REMOTE: {
                try {
                    this.contentEjbRemove(this.engContentAffinity);
                    break;
                }
                finally {
                    this.engContentAffinity = null;
                }
            }
            case CONTENT_AFFINITY_LOCAL: {
                try {
                    this.contentEjbRemove(this.engContentAffinityLocal);
                    break;
                }
                finally {
                    this.engContentAffinityLocal = null;
                }
            }
            case CONTENT_REMOTE: {
                try {
                    this.contentEjbRemove(this.engContent);
                    break;
                }
                finally {
                    this.engContent = null;
                }
            }
            case CONTENT_LOCAL: {
                try {
                    this.contentEjbRemove(this.engContentLocal);
                    break;
                }
                finally {
                    this.engContentLocal = null;
                }
            }
            case ENGINE_REMOTE: {
                if (this.eng == null) break;
                this.eng = null;
                break;
            }
            case ENGINE_LOCAL: {
                if (this.engLocal == null) break;
                this.engLocal = null;
            }
        }
    }

    private void contentEjbRemove(Object ejb) throws Exception {
        if (ejb == null) {
            return;
        }
        try {
            if (this.runAsSubject != null) {
                EJBRemover ejbRemover = new EJBRemover(ejb);
                J2EEUtil.getInstance().doAs(this.runAsSubject, ejbRemover);
            } else {
                ContentEJB.removeEjb(ejb);
            }
        }
        catch (Exception e) {
            Subject ambientSubject = J2EEUtil.getInstance().getCurrentSubject();
            if (ambientSubject != null) {
                EJBRemover ejbRemover = new EJBRemover(ejb);
                J2EEUtil.getInstance().doAs(ambientSubject, ejbRemover);
            }
            ContentEJB.removeEjb(ejb);
        }
    }

    static void removeEjb(Object ejb) throws Exception {
        if (ejb instanceof EngineContent) {
            ((EngineContent)ejb).remove();
        } else if (ejb instanceof EngineContentAffinity) {
            ((EngineContentAffinity)ejb).remove();
        } else if (ejb instanceof EngineContentLocal) {
            ((EngineContentLocal)ejb).remove();
        } else if (ejb instanceof EngineContentAffinityLocal) {
            ((EngineContentAffinityLocal)ejb).remove();
        } else if (ejb instanceof Engine) {
            ((Engine)ejb).remove();
        } else if (ejb instanceof EngineLocal) {
            ((EngineLocal)ejb).remove();
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.realRemove();
        }
        catch (Throwable t) {
            if (logger.isSummaryTraceEnabled()) {
                logger.traceSummary("Error removing ContentEJB " + this.toString() + "; Exception=" + Exceptions.printStackTrace(t, null, true));
            }
        }
        finally {
            super.finalize();
        }
    }

    private void assertEjbNotNull(Object ejb, EjbType ejbType, EjbOp operation) {
        if (ejb == null) {
            logger.error("ContentEJB not set for " + (Object)((Object)ejbType));
            throw new EngineRuntimeException(ExceptionCode.TRANSPORT_EJB_UNABLE_TO_CONNECT, null, ExceptionContext.TRANSPORT_EJB_NULL_CONTENT_EJB, new Object[]{ejbType, operation});
        }
    }

    public String toString() {
        String ejbHomeHashCode = "null";
        try {
            if (this.ejbHome != null) {
                ejbHomeHashCode = Integer.toString(this.ejbHome.hashCode());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        String ejbHashCode = "null";
        try {
            if (this.ejb != null) {
                ejbHashCode = Integer.toString(this.ejb.hashCode());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        StringBuffer buf = new StringBuffer("ContentEJB: ");
        buf.append("ejbHome.hashcode=" + ejbHomeHashCode);
        buf.append("; ejb.hashcode=" + ejbHashCode);
        buf.append("; ejbType=" + (Object)((Object)this.ejbType));
        buf.append("; lastOp=" + (Object)((Object)this.lastOp));
        buf.append("; isStateful=" + this.useAffinity);
        buf.append("; isLocal=" + this.isLocal());
        buf.append("; ejbHome=[" + ContentEJB.abbrevStr(this.ejbHome) + "]");
        buf.append("; ejb=[" + ContentEJB.abbrevStr(this.ejb) + "]");
        return buf.toString();
    }

    public static String abbrevStr(Object obj) {
        String abbreviatedStr;
        block3: {
            abbreviatedStr = "";
            try {
                String str;
                if (obj instanceof ContentEJBHome) {
                    abbreviatedStr = String.valueOf(obj);
                }
                abbreviatedStr = (str = String.valueOf(obj)) != null && str.length() > 70 ? str.substring(0, 70) + "..." : str;
            }
            catch (Throwable t) {
                if (!logger.isDetailTraceEnabled()) break block3;
                logger.traceDetail("ContentEJB.abbreStr: Exception: " + Exceptions.printStackTrace(t, null, true));
            }
        }
        return abbreviatedStr;
    }

    private static class EJBRemover
    implements PrivilegedExceptionAction {
        private Object ejb;

        EJBRemover(Object ejb) {
            this.ejb = ejb;
        }

        public Object run() throws Exception {
            ContentEJB.removeEjb(this.ejb);
            return null;
        }
    }

    private static enum EjbOp {
        UNKNOWN,
        GET_UPLOAD_EJB,
        GET_DOWNLOAD_EJB,
        GET_CONTENT,
        PUT_CONTENT,
        EJB_REMOVE;

    }

    private static enum EjbType {
        UNKNOWN,
        ENGINE_REMOTE,
        ENGINE_LOCAL,
        CONTENT_REMOTE,
        CONTENT_LOCAL,
        CONTENT_AFFINITY_REMOTE,
        CONTENT_AFFINITY_LOCAL;

    }
}

