/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

public class AsyncUpgradeType {
    public static final int SECURITY_PARENT_UPGRADE_AS_INT = 1;
    public static final Integer SECURITY_PARENT_UPGRADE = new Integer(1);
    public static final int MIME_TYPE_UPGRADE_AS_INT = 2;
    public static final Integer MIME_TYPE_UPGRADE = new Integer(2);
    public static final int REPLICATION_UPGRADE_AS_INT = 4;
    public static final Integer REPLICATION_UPGRADE = new Integer(4);
    public static final int EVENT_UPGRADE_AS_INT = 8;
    public static final Integer EVENT_UPGRADE = new Integer(8);
    public static final int LCSE_INDEX_REQUEST_REMOVAL_AS_INT = 16;
    public static final Integer LCSE_INDEX_REQUEST_REMOVAL = 16;
    public static final int SD_HASH_FIX_AS_INT = 32;
    public static final Integer SD_HASH_FIX = 32;
    public static final int[] ALL_UPGRADES_BITMASK = new int[]{1, 2, 4, 8, 16, 32};
    public static final String[] ALL_UPGRADES_BITMASK_NAMES = new String[]{"Security Parent", "MIME Type", "Replication", "Event", "LCSE Decommission", "Security Descriptor Hash Improvement"};

    public static final boolean isTaskCompleted(int curAsyncUpgradeState, int testAsyncUpgradeType) {
        return (curAsyncUpgradeState & testAsyncUpgradeType) == 0;
    }

    public static final int markTaskCompleted(int curAsyncUpgradeState, int asyncUpgradeTypeCompleted) {
        if (AsyncUpgradeType.isTaskCompleted(curAsyncUpgradeState, asyncUpgradeTypeCompleted)) {
            return curAsyncUpgradeState;
        }
        return curAsyncUpgradeState ^ asyncUpgradeTypeCompleted;
    }

    public static final int markTaskStarted(int currentAsyncUpgradeState, int asyncUpgradeType) {
        if (AsyncUpgradeType.isTaskCompleted(currentAsyncUpgradeState, asyncUpgradeType)) {
            return currentAsyncUpgradeState ^ asyncUpgradeType;
        }
        return currentAsyncUpgradeState;
    }

    public static final String getTaskName(int asyncUpgradeType) {
        String taskName = null;
        for (int i = 0; taskName == null && i < ALL_UPGRADES_BITMASK.length; ++i) {
            if (asyncUpgradeType != ALL_UPGRADES_BITMASK[i]) continue;
            taskName = ALL_UPGRADES_BITMASK_NAMES[i];
        }
        return taskName;
    }
}

