/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ErrorLoggingLevel;
import com.filenet.api.util.UserContext;
import com.filenet.apiimpl.exception.ExceptionContext;
import com.filenet.apiimpl.util.LoggingConfiguration;
import com.filenet.apiimpl.util.SubSystem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class BaseLogger {
    private static String SERVER_PRIMARY_PATTERN = "ce_system%g.log";
    private static String SERVER_TRACE_PATTERN = "ce_trace%g.log";
    private static boolean traceEnabled = false;
    private static boolean serverMode = false;
    private static boolean usingLC = true;
    private static LoggingConfiguration loggingConfiguration = null;
    private static FileHandler primaryLogHandler = null;
    private static FileHandler traceLogHandler = null;
    private static String primaryLogPath = null;
    private static String traceLogPath = null;
    private static Formatter serverFormatter = null;
    private static int maxLogFileSize;
    private static int maxBackupLogFiles;
    private static ConcurrentHashMap<SubSystem, Integer> masks;
    protected static final int LOG_F_ERROR = 64;
    protected static final int LOG_F_WARNING = 128;
    protected static final int LOG_F_INFO = 256;
    protected static final int LOG_F_SUMMARY = 2;
    protected static final int LOG_F_MODERATE = 4;
    protected static final int LOG_F_DETAIL = 8;
    protected static final int LOG_F_TIMER = 1;
    protected static final int LOG_ALL_ERROR = 64;
    protected static final int LOG_ALL_WARNING = 192;
    protected static final int LOG_ALL_INFO = 448;
    protected static final int LOG_ALL_SUMMARY = 450;
    protected static final int LOG_ALL_MODERATE = 454;
    protected static final int LOG_ALL_DETAIL = 462;
    protected static final int LOG_ALL_TIMER = 463;
    private static HashMap<String, Integer> levelStrings;
    private SubSystem subSystem;
    private String loggerName;

    protected BaseLogger(String className, SubSystem subSystem) {
        this.subSystem = subSystem;
        this.loggerName = "CE:" + subSystem.getAbbreviation();
    }

    public static BaseLogger getBaseLogger(Class clazz, SubSystem subSystem) {
        return new BaseLogger(clazz.getName(), subSystem);
    }

    private static void initApiMode() {
        ArrayList<String> subSystemNames = new ArrayList<String>();
        SubSystem[] subs = SubSystem.getAllSubSystems();
        for (int i = 0; i < subs.length; ++i) {
            SubSystem subSystem = subs[i];
            subSystemNames.add(subSystem.getAbbreviation());
        }
        loggingConfiguration = new LoggingConfiguration("CE", subSystemNames);
        traceEnabled = loggingConfiguration.hasLog();
        BaseLogger.applySubSystemLevels(loggingConfiguration.getSubSystemLevels());
    }

    private static void applySubSystemLevels(HashMap<String, String> levelSettings) {
        SubSystem[] subs = SubSystem.getAllSubSystems();
        for (int i = 0; i < subs.length; ++i) {
            SubSystem subSystem = subs[i];
            String lstr = levelSettings.get(subSystem.getAbbreviation());
            if (lstr == null) {
                lstr = "off";
            }
            BaseLogger.applyLevel(subSystem, lstr);
        }
    }

    private static void applyLevel(SubSystem subSystem, String lstr) {
        Integer mask = levelStrings.get(lstr.toLowerCase());
        if (mask == null) {
            System.out.println("com.filenet.logging Ignored unrecognized trace level '" + lstr + "' for subsystem " + subSystem.toString());
        } else if (serverMode) {
            masks.put(subSystem, mask | 0x1C0);
        } else {
            masks.put(subSystem, mask);
        }
    }

    protected static boolean startServer(String logPath, int maxFileSize, int maxBackupFiles, Formatter formatter) {
        serverFormatter = formatter;
        maxLogFileSize = maxFileSize;
        maxBackupLogFiles = maxBackupFiles;
        serverMode = true;
        try {
            FileHandler handler;
            primaryLogHandler = handler = BaseLogger.prepareFileHandler(logPath, SERVER_PRIMARY_PATTERN);
            primaryLogPath = logPath;
        }
        catch (Throwable t) {
            System.err.println("com.filenet.Logging Exception during server log file initialisation: " + t);
        }
        SubSystem[] subs = SubSystem.getAllSubSystems();
        for (int i = 0; i < subs.length; ++i) {
            SubSystem subSystem = subs[i];
            Integer mask = masks.get(subSystem);
            if (mask != null) {
                masks.put(subSystem, mask | 0x1C0);
                continue;
            }
            masks.put(subSystem, 448);
        }
        return true;
    }

    public static void updateTracing(boolean newTraceEnabled, String newTracePath) {
        if (!serverMode) {
            return;
        }
        usingLC = false;
        if (newTracePath == null || newTracePath.length() == 0) {
            newTracePath = primaryLogPath;
        }
        if (newTraceEnabled) {
            if (!traceEnabled || traceLogPath == null || !traceLogPath.equals(newTracePath)) {
                try {
                    FileHandler handler = BaseLogger.prepareFileHandler(newTracePath, SERVER_TRACE_PATTERN);
                    if (traceLogHandler != null) {
                        traceLogHandler.close();
                    }
                    traceLogHandler = handler;
                    traceEnabled = true;
                    traceLogPath = newTracePath;
                }
                catch (Throwable t) {
                    System.err.println("com.filenet.Logging Exception during server log file initialisation: " + t);
                }
            }
        } else if (!newTraceEnabled) {
            if (traceLogHandler != null) {
                traceLogHandler.close();
                traceLogHandler = null;
            }
            traceEnabled = false;
            traceLogPath = null;
        }
    }

    protected static void setSubSystemMask(SubSystem subSystem, int mask) {
        masks.put(subSystem, mask | 0x1C0);
    }

    public static void shutdown() {
        try {
            if (primaryLogHandler != null) {
                primaryLogHandler.close();
                primaryLogHandler = null;
                if (traceLogHandler != null) {
                    traceLogHandler.close();
                    traceLogHandler = null;
                }
            }
            LoggingConfiguration.shutdown();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void addGlobalHandler(Handler handler, boolean useDefaultFormatter) {
        LoggingConfiguration.addGlobalHandler(handler, useDefaultFormatter);
    }

    public static void removeGlobalHandler(Handler handler) {
        LoggingConfiguration.removeGlobalHandler(handler);
    }

    public void addHandler(Handler handler, boolean useDefaultFormatter) {
        loggingConfiguration.addHandler(this.subSystem.getAbbreviation(), handler, useDefaultFormatter);
    }

    public void removeHandler(String subSystemName, Handler handler) {
        loggingConfiguration.removeHandler(this.subSystem.getAbbreviation(), handler);
    }

    private static FileHandler prepareFileHandler(String logPath, String filePattern) throws IOException {
        String pattern = LoggingConfiguration.createFilePattern(logPath, filePattern);
        FileHandler handler = new FileHandler(pattern, maxLogFileSize, maxBackupLogFiles + 1, true);
        handler.setFormatter(serverFormatter);
        handler.setLevel(Level.ALL);
        try {
            handler.setEncoding("UTF-8");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return handler;
    }

    private static boolean isLogEnabled(SubSystem subSystem, int desiredFlag) {
        Integer mask;
        if (usingLC) {
            if (loggingConfiguration.refreshSettings()) {
                BaseLogger.applySubSystemLevels(loggingConfiguration.getSubSystemLevels());
            }
            traceEnabled = loggingConfiguration.hasLog();
        }
        return (mask = masks.get(subSystem)) != null && (mask & desiredFlag) != 0;
    }

    protected boolean traceInThisThread() {
        return true;
    }

    public boolean isInfoEnabled() {
        return BaseLogger.isLogEnabled(this.subSystem, 256);
    }

    public boolean isWarnEnabled() {
        return BaseLogger.isLogEnabled(this.subSystem, 128);
    }

    public boolean isErrorEnabled() {
        return BaseLogger.isLogEnabled(this.subSystem, 64);
    }

    public boolean isSummaryTraceEnabled() {
        return traceEnabled && BaseLogger.isLogEnabled(this.subSystem, 2) && this.traceInThisThread();
    }

    public boolean isModerateTraceEnabled() {
        return traceEnabled && BaseLogger.isLogEnabled(this.subSystem, 4) && this.traceInThisThread();
    }

    public boolean isDetailTraceEnabled() {
        return traceEnabled && BaseLogger.isLogEnabled(this.subSystem, 8) && this.traceInThisThread();
    }

    public boolean isTimerTraceEnabled() {
        return traceEnabled && BaseLogger.isLogEnabled(this.subSystem, 1) && this.traceInThisThread();
    }

    public boolean isDebugEnabled() {
        return traceEnabled && BaseLogger.isLogEnabled(this.subSystem, 8) && this.traceInThisThread();
    }

    public void error(Object msg) {
        this.error(msg, null);
    }

    public void error(Object msg, Throwable t) {
        if (this.isErrorEnabled()) {
            this.logDirect(Level.SEVERE, msg.toString(), t);
        }
    }

    public void fatal(Object msg) {
        this.fatal(msg, null);
    }

    public void fatal(Object msg, Throwable t) {
        if (this.isErrorEnabled()) {
            this.logDirect(Level.SEVERE, msg.toString(), t);
        }
    }

    public void warn(Object msg) {
        this.warn(msg, null);
    }

    public void warn(Object msg, Throwable t) {
        if (this.isWarnEnabled()) {
            this.logDirect(Level.WARNING, msg.toString(), t);
        }
    }

    public void info(Object msg) {
        this.info(msg, null);
    }

    public void info(Object msg, Throwable t) {
        if (this.isInfoEnabled()) {
            this.logDirect(Level.INFO, msg.toString(), t);
        }
    }

    public void traceSummary(Object msg) {
        if (this.isSummaryTraceEnabled()) {
            this.logDirect(Level.FINE, msg.toString(), null);
        }
    }

    public void traceModerate(Object msg) {
        if (this.isModerateTraceEnabled()) {
            this.logDirect(Level.FINER, msg.toString(), null);
        }
    }

    public void traceDetail(Object msg) {
        if (this.isDetailTraceEnabled()) {
            this.logDirect(Level.FINEST, msg.toString(), null);
        }
    }

    public void debug(Object msg) {
        this.traceDetail(msg);
    }

    public void debug(Object msg, Throwable t) {
        if (this.isDetailTraceEnabled()) {
            this.logDirect(Level.FINEST, msg.toString(), t);
        }
    }

    public void traceTimer(String msg) {
        if (this.isTimerTraceEnabled()) {
            this.logDirect(Level.FINEST, msg.toString(), null);
        }
    }

    public void traceTimer(String msg, long startTimeMs, long endTimeMs) {
        if (this.isTimerTraceEnabled()) {
            this.logDirect(Level.FINEST, msg + (endTimeMs - startTimeMs) + " ms", null);
        }
    }

    public void traceEnter() {
        if (this.isDetailTraceEnabled()) {
            this.logMethodNameForTrace("Enter ", "", null);
        }
    }

    public void traceExit() {
        if (this.isDetailTraceEnabled()) {
            this.logMethodNameForTrace("Exit ", "", null);
        }
    }

    public void traceExit(Object returnedVal) {
        if (this.isDetailTraceEnabled()) {
            String val = " = ";
            val = returnedVal instanceof String ? val + "\"" + returnedVal + "\"" : val + returnedVal;
            this.logMethodNameForTrace("Exit ", val, null);
        }
    }

    protected void logMethodNameForTrace(String prefix, String suffix, Throwable t) {
        String methodName = this.getMethodName(t, 3);
        this.logDirect(Level.FINEST, prefix + methodName + "()" + suffix, t);
    }

    public void logError(EngineRuntimeException erte, String principalName, Boolean isInGlobalTran, Boolean isInUserInitTran) {
        this.logErrorExtended(erte, principalName, isInGlobalTran, isInUserInitTran, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logErrorExtended(EngineRuntimeException erte, String principalName, Boolean isInGlobalTran, Boolean isInUserInitTran, String stringizedRequest) {
        if (!this.isErrorEnabled() || erte.getExceptionCode().getErrorLoggingLevel() != ErrorLoggingLevel.Required) {
            return;
        }
        UserContext orig = UserContext.get();
        try {
            UserContext.set(null);
            String exceptionInfo = erte.getMessage();
            String methodName = this.getMethodName(erte);
            ExceptionContext logFormat = ExceptionContext.E_ERROR_LOG_FORMAT;
            Object[] args = null;
            if (stringizedRequest != null) {
                args = new Object[]{methodName, principalName, isInGlobalTran, isInUserInitTran, stringizedRequest, exceptionInfo};
                logFormat = ExceptionContext.E_ERROR_LOG_FORMAT_EXTENDED;
            } else {
                args = new Object[]{methodName, principalName, isInGlobalTran, isInUserInitTran, exceptionInfo};
            }
            this.logDirect(Level.SEVERE, logFormat.toString(UserContext.get().getLocale(), args), erte);
        }
        finally {
            UserContext.set(orig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logError(EngineRuntimeException erte) {
        if (!this.isErrorEnabled() || erte.getExceptionCode().getErrorLoggingLevel() != ErrorLoggingLevel.Required) {
            return;
        }
        UserContext orig = UserContext.get();
        String exceptionInfo = erte.getMessage();
        try {
            UserContext.set(null);
            this.logDirect(Level.SEVERE, exceptionInfo, erte);
        }
        finally {
            UserContext.set(orig);
        }
    }

    public SubSystem getSubSystem() {
        return this.subSystem;
    }

    protected String getMethodName(Throwable t) {
        String methodName = "<unknown>";
        if (t == null) {
            t = new Throwable();
        }
        StackTraceElement[] elems = t.getStackTrace();
        try {
            StackTraceElement caller = elems[0];
            methodName = caller.getMethodName();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return methodName;
    }

    protected String getMethodName(Throwable t, int position) {
        String methodName = "<unknown>";
        int pos = 0;
        if (t == null) {
            t = new Throwable();
            pos = position;
        }
        StackTraceElement[] elems = t.getStackTrace();
        try {
            StackTraceElement caller = elems[pos];
            methodName = caller.getMethodName();
            String className = caller.getClassName();
            className = className.substring(className.lastIndexOf(".") + 1);
            StringBuilder buf = new StringBuilder(64);
            buf.append(className);
            buf.append(".");
            buf.append(methodName);
            methodName = buf.toString();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return methodName;
    }

    private void logDirect(Level level, String msg, Throwable t) {
        FileHandler th;
        LogRecord record = this.createLogRecord(level, msg, t);
        if (!serverMode) {
            loggingConfiguration.publish(this.subSystem.getAbbreviation(), record);
            return;
        }
        if (level.intValue() >= Level.INFO.intValue() && primaryLogHandler != null) {
            primaryLogHandler.publish(record);
        }
        if ((th = traceLogHandler) == null && usingLC) {
            th = loggingConfiguration.getLogHandler();
        }
        if (th != null && (level.intValue() < Level.INFO.intValue() || this.traceInThisThread())) {
            ((Handler)th).publish(record);
        }
    }

    private LogRecord createLogRecord(Level level, String msg, Throwable t) {
        LogRecord record = new LogRecord(level, msg);
        if (t != null) {
            record.setThrown(t);
        }
        record.setLoggerName(this.loggerName);
        return record;
    }

    static {
        masks = new ConcurrentHashMap();
        levelStrings = new HashMap();
        levelStrings.put("error", 64);
        levelStrings.put("severe", 64);
        levelStrings.put("warning", 192);
        levelStrings.put("info", 448);
        levelStrings.put("summary", 450);
        levelStrings.put("fine", 450);
        levelStrings.put("moderate", 454);
        levelStrings.put("finer", 454);
        levelStrings.put("detail", 462);
        levelStrings.put("finest", 462);
        levelStrings.put("timer", 463);
        levelStrings.put("off", 0);
        BaseLogger.initApiMode();
    }
}

