/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.util.ExtendedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class FilterExtendedInputStream
extends ExtendedInputStream {
    protected InputStream in;
    protected boolean isExtended;
    protected long totalSize;
    protected long physicalPosition;
    protected long logicalPosition;

    protected FilterExtendedInputStream(InputStream in, long totalSize) {
        this.in = in;
        this.totalSize = totalSize;
        if (in instanceof ExtendedInputStream) {
            this.isExtended = true;
            if (totalSize == -1L && ((ExtendedInputStream)in).sizeSupported()) {
                try {
                    this.totalSize = ((ExtendedInputStream)in).size();
                }
                catch (IOException ioe) {
                    this.totalSize = -1L;
                }
            }
        }
    }

    protected InputStream wrapIfNeeded() {
        if (this.isExtended) {
            return this;
        }
        return new FilterInputStream(this){};
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.in.close();
    }

    @Override
    public long position() {
        if (!this.isExtended) {
            throw new UnsupportedOperationException("Not an ExtendedInputStream");
        }
        return this.logicalPosition;
    }

    @Override
    public boolean sizeSupported() {
        return this.totalSize != -1L;
    }

    @Override
    public long size() {
        if (this.totalSize != -1L) {
            return this.totalSize;
        }
        throw new EngineRuntimeException(ExceptionCode.API_EXTENDED_STREAM_SIZE_UNAVAILABLE);
    }

    protected long skipInner(long skipCount) throws IOException {
        long skipped = this.in.skip(skipCount);
        this.physicalPosition += skipped;
        return skipped;
    }

    protected void positionInner(long newPosition) throws IOException {
        ((ExtendedInputStream)this.in).position(newPosition);
        this.physicalPosition = ((ExtendedInputStream)this.in).position();
    }

    protected int readFully(byte[] buffer, int offset, int length) throws IOException {
        int bytesRead = -1;
        int rtt = 0;
        while (length > 0 && rtt >= 0) {
            rtt = this.in.read(buffer, offset, length);
            if (rtt <= 0) continue;
            offset += rtt;
            length -= rtt;
            bytesRead = FilterExtendedInputStream.combineCounts(bytesRead, rtt);
        }
        this.physicalPosition += (long)bytesRead;
        return bytesRead;
    }

    protected static int combineCounts(int ct1, int ct2) {
        if (ct1 == -1) {
            return ct2;
        }
        if (ct2 == -1) {
            return ct1;
        }
        return ct1 + ct2;
    }
}

