/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.api.constants.DatabaseType;
import com.filenet.api.util.Id;
import com.filenet.apiimpl.util.BaseLogger;
import com.filenet.apiimpl.util.ConfigValueLookup;
import com.filenet.apiimpl.util.SubSystem;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class IdGen {
    public static final int SEQUENTIAL_SHIFT_FOR_TIME = 12;
    public static String SecureRandom_algorithm_config = "com.filenet.api.Id.SecureRandomAlgorithm";
    private static final BaseLogger logger = BaseLogger.getBaseLogger(IdGen.class, SubSystem.API);
    private static final ThreadLocal tlsRandom = new ThreadLocal();
    private static boolean sequentialModeCounter = true;
    private static AtomicInteger seqCounter = new AtomicInteger(0);
    private static AtomicLong seqTime = new AtomicLong(0L);
    private static byte[] packOrderMSSQL = new byte[]{15, 14, 13, 12, 11, 10};
    private static byte[] packOrderDB2 = new byte[]{5, 4, 3, 2, 1, 0};
    private static byte[] packOrderPostgreSQL = new byte[]{4, 5, 0, 1, 2, 3};

    public static Id createId() {
        return Id.createId();
    }

    public static byte[] getSequentialBytes(DatabaseType dbType) {
        byte[] packOrder;
        byte[] bytes = IdGen.getRandomBytes();
        long time = System.currentTimeMillis();
        long prev = seqTime.getAndSet(time >>= 12);
        if (prev != time) {
            seqCounter.set(0);
        }
        time = (time << 24) + (long)(seqCounter.incrementAndGet() & 0xFFFFFF);
        if (dbType == DatabaseType.MSSQL) {
            bytes[8] = (byte)(bytes[8] & 0xC3);
            bytes[8] = (byte)(bytes[8] | (byte)(time << 2 & 0x3CL));
            packOrder = packOrderMSSQL;
        } else if (dbType == DatabaseType.POSTGRE_SQL) {
            bytes[7] = (byte)(bytes[7] & 0xF0);
            bytes[7] = (byte)(bytes[7] | (byte)(time & 0xFL));
            packOrder = packOrderPostgreSQL;
        } else {
            bytes[6] = (byte)(bytes[6] & 0xF);
            bytes[6] = (byte)(bytes[6] | (byte)(time << 4 & 0xF0L));
            packOrder = packOrderDB2;
        }
        time >>= 4;
        for (int c = 0; c < 6; ++c) {
            byte nb;
            bytes[packOrder[c]] = nb = (byte)(time & 0xFFL);
            time >>= 8;
        }
        bytes[7] = (byte)(bytes[7] & 0xF);
        bytes[7] = (byte)(bytes[7] | 0xC0);
        bytes[8] = (byte)(bytes[8] & 0x3F);
        bytes[8] = (byte)(bytes[8] | 0x80);
        return bytes;
    }

    public static long getSequentialPart(Id id, DatabaseType dbType) {
        byte[] packOrder;
        int lastNibble;
        long seq = 0L;
        if (dbType == DatabaseType.MSSQL) {
            byte byte8 = id.getByte(8);
            lastNibble = (byte8 & 0x3C) >> 2;
            packOrder = packOrderMSSQL;
        } else if (dbType == DatabaseType.POSTGRE_SQL) {
            byte byte7 = id.getByte(7);
            lastNibble = byte7 & 0xF;
            packOrder = packOrderPostgreSQL;
        } else {
            byte byte6 = id.getByte(6);
            lastNibble = (byte6 & 0xF0) >> 4;
            packOrder = packOrderDB2;
        }
        for (int c = 5; c >= 0; --c) {
            seq <<= 8;
            byte nb = id.getByte(packOrder[c]);
            seq |= (long)(nb & 0xFF);
        }
        seq = seq << 4 | (long)lastNibble;
        return seq;
    }

    public static byte[] getRandomBytes() {
        SecureRandom random = (SecureRandom)tlsRandom.get();
        if (random == null) {
            random = IdGen.getRandom();
            long seedValue = System.nanoTime() + (long)Thread.currentThread().hashCode();
            random.nextInt();
            random.setSeed(seedValue);
            tlsRandom.set(random);
        }
        byte[] bytes = new byte[16];
        try {
            random.nextBytes(bytes);
        }
        catch (RuntimeException t) {
            logger.error("error calling Random.nextBytes, resetting thread local random  ", t);
            tlsRandom.set(null);
            throw t;
        }
        return bytes;
    }

    public static SecureRandom getRandom() {
        SecureRandom random = null;
        String algorithm = ConfigValueLookup.getValue(SecureRandom_algorithm_config, "SHA1PRNG");
        try {
            random = "JRE".equalsIgnoreCase(algorithm) ? new SecureRandom() : SecureRandom.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            random = new SecureRandom();
        }
        return random;
    }

    static {
        logger.info("SecureRandom for ID Gen, algorithm = " + IdGen.getRandom().getAlgorithm());
    }
}

