/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.api.constants.ConfigurationParameter;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.util.UserContext;
import com.filenet.apiimpl.core.ConnectionImpl;
import com.filenet.apiimpl.exception.ExceptionContext;
import com.filenet.apiimpl.exception.Exceptions;
import com.filenet.apiimpl.perflog.Perflog;
import com.filenet.apiimpl.util.ApiToEngineBridge;
import com.filenet.apiimpl.util.AuthToken;
import com.filenet.apiimpl.util.BaseLogger;
import com.filenet.apiimpl.util.ConfigValueLookup;
import com.filenet.apiimpl.util.J2EEType;
import com.filenet.apiimpl.util.J2EEUtilWL;
import com.filenet.apiimpl.util.J2EEUtilWS;
import com.filenet.apiimpl.util.SubSystem;
import com.filenet.apiimpl.wsi.UsernameToken;
import java.io.ByteArrayInputStream;
import java.lang.reflect.Method;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.security.auth.Subject;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;

public class J2EEUtil {
    private static final BaseLogger logger = BaseLogger.getBaseLogger(J2EEUtil.class, SubSystem.API);
    private static Perflog perfLogger = Perflog.Instance();
    private static boolean legacyAuthTokenSubject = ConfigValueLookup.getValueAsBoolean("com.filenet.authentication.enableLegacyAuthTokenSubject", false);
    static boolean canInstantiateInitialContext = false;
    private static J2EEUtil appServerUtilRef;
    private static int appServerType;
    private static String propFactory;

    protected J2EEUtil() {
    }

    public static final J2EEUtil getInstance() {
        return appServerUtilRef;
    }

    public void initializeORB() {
    }

    public Object doAs(Subject sub, PrivilegedExceptionAction pa) {
        try {
            return Subject.doAs(sub, pa);
        }
        catch (Throwable t) {
            if (t.getCause() instanceof EngineRuntimeException) {
                throw (EngineRuntimeException)t.getCause();
            }
            if (t instanceof EngineRuntimeException) {
                throw (EngineRuntimeException)t;
            }
            throw new EngineRuntimeException(t, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
    }

    public Subject getAmbientSubject() {
        if (legacyAuthTokenSubject) {
            return this.getLegacyAmbientSubject();
        }
        return this.getCurrentAmbientSubject();
    }

    protected Subject getLegacyAmbientSubject() {
        return this._getAmbientSubject();
    }

    protected Subject getCurrentAmbientSubject() {
        return this._getAmbientSubject();
    }

    private Subject _getAmbientSubject() {
        Subject sub = Subject.getSubject(AccessController.getContext());
        this.trace("_getAmbientSubject", "subject={0}", sub);
        return sub;
    }

    public Subject getCurrentSubject() {
        Subject subj = ApiToEngineBridge.getCurrentSubject();
        if (subj == null) {
            subj = this.getAmbientSubject();
        }
        return subj;
    }

    public String getTransactionManagerPath() {
        return "java:/TransactionManager";
    }

    public String getUserTransactionPath() {
        return "UserTransaction";
    }

    public String getTransactionSynchronizationRegistryPath() {
        return "java:comp/TransactionSynchronizationRegistry";
    }

    public UserTransaction getUserTransaction(Context cntx) {
        try {
            return (UserTransaction)cntx.lookup(this.getUserTransactionPath());
        }
        catch (Throwable e) {
            if (e.getCause() instanceof EngineRuntimeException) {
                throw (EngineRuntimeException)e.getCause();
            }
            if (e instanceof EngineRuntimeException) {
                throw (EngineRuntimeException)e;
            }
            throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
    }

    public TransactionManager getTransactionManager(Context cntx) {
        try {
            return (TransactionManager)cntx.lookup(this.getTransactionManagerPath());
        }
        catch (Throwable e) {
            if (e.getCause() instanceof EngineRuntimeException) {
                throw (EngineRuntimeException)e.getCause();
            }
            if (e instanceof EngineRuntimeException) {
                throw (EngineRuntimeException)e;
            }
            throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
    }

    public boolean isInGlobalTrans(Context cntx) {
        long t1 = System.currentTimeMillis();
        UserTransaction ut = this.getUserTransaction(cntx);
        if (ut == null) {
            return false;
        }
        try {
            boolean bl = ut.getStatus() != 6;
            return bl;
        }
        catch (Throwable e) {
            if (e.getCause() instanceof EngineRuntimeException) {
                throw (EngineRuntimeException)e.getCause();
            }
            if (e instanceof EngineRuntimeException) {
                throw (EngineRuntimeException)e;
            }
            throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
        finally {
            perfLogger.countIn("isInGlobalTransaction", System.currentTimeMillis() - t1, true);
        }
    }

    public int getTransactionStatus(Context cntx) {
        UserTransaction ut = this.getUserTransaction(cntx);
        int retStatus = 6;
        if (ut == null) {
            return retStatus;
        }
        try {
            retStatus = ut.getStatus();
        }
        catch (Throwable e) {
            if (e.getCause() instanceof EngineRuntimeException) {
                throw (EngineRuntimeException)e.getCause();
            }
            if (e instanceof EngineRuntimeException) {
                throw (EngineRuntimeException)e;
            }
            throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
        return retStatus;
    }

    public Object getMBeanServer() {
        try {
            Class[] params = new Class[]{String.class};
            Object[] args = new Object[]{null};
            Class<?> MBeanServerFactoryClass = Class.forName("javax.management.MBeanServerFactory");
            Method findMBeanServerMethod = MBeanServerFactoryClass.getDeclaredMethod("findMBeanServer", params);
            ArrayList mbeanServers = (ArrayList)findMBeanServerMethod.invoke(null, args);
            return mbeanServers.get(0);
        }
        catch (Exception ex) {
            throw new EngineRuntimeException(ex, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
    }

    public String getRemoteEnginePath() {
        return ConfigValueLookup.getValue("RemoteEnginePath", "FileNet/Engine");
    }

    public String getLocalEnginePath() {
        return ConfigValueLookup.getValue("LocalEnginePath", "FileNet/Local/Engine");
    }

    public String getLocalEngineCorePath() {
        return "FileNet/Local/EngineCore";
    }

    public String getLocalEngineContentPath() {
        return ConfigValueLookup.getValue("LocalContentPath", "FileNet/Local/EngineContent");
    }

    public String getRemoteEngineContentPath() {
        return ConfigValueLookup.getValue("RemoteContentPath", "FileNet/EngineContent");
    }

    public String getLocalEngineContentCorePath() {
        return "FileNet/Local/EngineContentCore";
    }

    public String getLocalEngineContentAffinityPath() {
        return ConfigValueLookup.getValue("LocalContentAffinityPath", "FileNet/Local/EngineContentAffinity");
    }

    public String getRemoteEngineContentAffinityPath() {
        return ConfigValueLookup.getValue("RemoteContentAffinityPath", "FileNet/EngineContentAffinity");
    }

    public String getRemoteEngineCommPath() {
        return ConfigValueLookup.getValue("RemoteCommPath", "FileNet/EngineComm");
    }

    public String getLocalEngineCommPath() {
        return "FileNet/Local/EngineComm";
    }

    public String getLocalEngineCommCorePath() {
        return "FileNet/Local/EngineCommCore";
    }

    public Principal getCurrentPrincipal() {
        Principal prin = ApiToEngineBridge.getCurrentPrincipal();
        if (prin != null) {
            return prin;
        }
        Subject sub = this.getAmbientSubject();
        return this.getPrincipalFromSubject(sub);
    }

    public Principal getPrincipalFromSubject(Subject sub) {
        if (sub == null || sub.getPrincipals() == null || sub.getPrincipals().isEmpty()) {
            return null;
        }
        Object[] principals = sub.getPrincipals().toArray();
        return (Principal)principals[0];
    }

    public Subject getAuthTokenSubject() {
        Subject sub = UserContext.get().getSubject();
        if (sub == null) {
            sub = this.getCurrentSubject();
        }
        return sub;
    }

    public AuthToken getAuthTokenFromSubject() {
        return this.getAuthTokenFromSubject(this.getAuthTokenSubject());
    }

    public AuthToken getAuthTokenFromSubject(Subject sub) {
        try {
            String realm = this.getRealmFromSubject(sub);
            String realmAuthTokenOrder = null;
            if (realm != null) {
                realmAuthTokenOrder = ConfigValueLookup.getValue("com.filenet.authentication." + realm + ".AuthTokenOrder", null);
            }
            String authTokenOrder = null;
            authTokenOrder = realmAuthTokenOrder != null ? realmAuthTokenOrder : ConfigValueLookup.getValue("com.filenet.authentication.wsi.AuthTokenOrder", "oidc,oauth,ltpa");
            String[] authTokenTypes = authTokenOrder.split(",");
            String ssoToken = null;
            String tokenType = null;
            Principal principal = this.getPrincipalFromSubject(sub);
            if (principal == null) {
                principal = this.getCurrentPrincipal();
            }
            AuthToken authToken = null;
            for (String authTtokenType : authTokenTypes) {
                tokenType = authTtokenType.trim().toLowerCase();
                if (tokenType.equalsIgnoreCase("oauth")) {
                    ssoToken = this.getOAuthTokenFromSubject(sub);
                    if (ssoToken != null) {
                        authToken = new AuthToken();
                        authToken.setTokenType(AuthToken.TokenType.OAUTH_TOKEN);
                        authToken.setTokenName(UsernameToken.USER_NAME_OAUTH_TOKEN);
                        authToken.setTokenValue(ssoToken);
                        authToken.setPrincipalName(principal.getName());
                    }
                } else if (tokenType.equalsIgnoreCase("oidc")) {
                    ssoToken = this.getOIDCTokenFromSubject(sub);
                    if (ssoToken != null) {
                        authToken = new AuthToken();
                        authToken.setTokenType(AuthToken.TokenType.OIDC_TOKEN);
                        authToken.setTokenName(UsernameToken.USER_NAME_OIDC_TOKEN);
                        authToken.setTokenValue(ssoToken);
                        authToken.setPrincipalName(principal.getName());
                    }
                } else if (tokenType.equalsIgnoreCase("ltpa") && (ssoToken = this.getLTPATokenFromSubject(sub)) != null) {
                    authToken = new AuthToken();
                    authToken.setTokenType(AuthToken.TokenType.LTPA_TOKEN);
                    authToken.setTokenName(UsernameToken.USER_NAME_LTPA_TOKEN);
                    authToken.setTokenValue(ssoToken);
                    if (principal != null) {
                        authToken.setPrincipalName(principal.getName());
                    }
                    authToken.setCookieName(this.getSSOCookieName());
                }
                if (authToken != null) break;
            }
            if (authToken != null) {
                authToken.setRealm(realm);
                authToken.setIssuer(realm);
            }
            this.trace("getAuthTokenFromSubject", "authToken={0}", authToken);
            return authToken;
        }
        catch (Exception e) {
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("J2EEUtil.getAuthTokenFromSubject: Unable to get authToken. " + Exceptions.printStackTrace(e));
            }
            return null;
        }
    }

    public String getLTPATokenFromSubject() {
        return this.getLTPATokenFromSubject(this.getAuthTokenSubject());
    }

    public String getLTPATokenFromSubject(Subject sub) {
        if (legacyAuthTokenSubject) {
            return this.getLegacyLTPATokenFromSubject();
        }
        return this.getCurrentLTPATokenFromSubject(sub);
    }

    public String getOIDCTokenFromSubject() {
        return this.getOIDCTokenFromSubject(this.getAuthTokenSubject());
    }

    public String getOIDCTokenFromSubject(Subject sub) {
        if (legacyAuthTokenSubject) {
            return this.getLegacyOIDCTokenFromSubject();
        }
        return this.getCurrentOIDCTokenFromSubject(sub);
    }

    public String getOAuthTokenFromSubject() {
        return this.getOAuthTokenFromSubject(this.getAuthTokenSubject());
    }

    public String getOAuthTokenFromSubject(Subject sub) {
        if (legacyAuthTokenSubject) {
            return this.getLegacyOAuthTokenFromSubject();
        }
        return this.getCurrentOAuthTokenFromSubject(sub);
    }

    public String getRealmFromSubject() {
        return this.getRealmFromSubject(this.getAuthTokenSubject());
    }

    public String getRealmFromSubject(Subject sub) {
        if (legacyAuthTokenSubject) {
            return this.getLegacyRealmFromSubject();
        }
        return this.getCurrentRealmFromSubject(sub);
    }

    protected String getCurrentRealmFromSubject(Subject sub) {
        return null;
    }

    protected String getLegacyRealmFromSubject() {
        return null;
    }

    protected String getLegacyLTPATokenFromSubject() {
        return null;
    }

    protected String getCurrentLTPATokenFromSubject(Subject sub) {
        return null;
    }

    protected String getLegacyOIDCTokenFromSubject() {
        return null;
    }

    protected String getCurrentOIDCTokenFromSubject(Subject sub) {
        return null;
    }

    protected String getLegacyOAuthTokenFromSubject() {
        return null;
    }

    protected String getCurrentOAuthTokenFromSubject(Subject sub) {
        return null;
    }

    public String getSSOCookieName() {
        return "ltpaToken2";
    }

    public boolean canInstantiateInitialContext() {
        return canInstantiateInitialContext;
    }

    public String getJaasContextFile() {
        return "jaas.conf.WSI";
    }

    public static int getAppServerType() {
        return appServerType;
    }

    private void trace(String method, String message, Object ... params) {
        this.trace(J2EEUtil.class, method, message, params);
    }

    protected void trace(Class aClass, String method, String message, Object ... params) {
        if (logger.isDetailTraceEnabled()) {
            StringBuilder logMsg = new StringBuilder(aClass.getSimpleName()).append(".").append(method).append(": ");
            logMsg.append(MessageFormat.format(message, params));
            logger.traceDetail(logMsg.toString());
        }
    }

    private static String getInitialContextFactory() {
        String initCntxFactory;
        block4: {
            initCntxFactory = null;
            try {
                Properties env = J2EEUtil.buildInitialContextParameters(null, null);
                InitialContext context = new InitialContext(env);
                initCntxFactory = (String)context.getEnvironment().get("java.naming.factory.initial");
                if (initCntxFactory != null) {
                    canInstantiateInitialContext = true;
                }
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail("[J2EEUtil] getInitialContextFactory() : class of InitialContext = " + context.getClass().getName() + " : its javax.naming.factory.initial = " + initCntxFactory);
                }
            }
            catch (Throwable ex) {
                if (!logger.isDetailTraceEnabled()) break block4;
                logger.traceDetail("getInitialContextFactory() failed because of the following error: " + ex.toString());
            }
        }
        return initCntxFactory;
    }

    public static Properties buildInitialContextParameters(ConnectionImpl conn, Properties jndiEnvironment) throws NamingException {
        jndiEnvironment = J2EEUtil.getEJBJndiEnvironment(conn, jndiEnvironment);
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("J2EEUtil.getInitialContextWithParameters JNDI Environment (a): " + jndiEnvironment);
        }
        if (jndiEnvironment == null) {
            jndiEnvironment = new Properties();
        }
        if (jndiEnvironment.size() == 0) {
            block14: {
                if (propFactory == null) {
                    try {
                        InitialContext ic = new InitialContext();
                        propFactory = (String)ic.getEnvironment().get("java.naming.factory.initial");
                    }
                    catch (NoInitialContextException noic) {
                        if (!logger.isDetailTraceEnabled()) break block14;
                        logger.traceDetail("J2EEUtil.getInitialContextWithParameters caught and ignored (harmless): " + noic);
                    }
                }
            }
            if (propFactory == null && appServerUtilRef != null) {
                if (appServerUtilRef instanceof J2EEUtilWS) {
                    propFactory = "com.ibm.websphere.naming.WsnInitialContextFactory";
                } else if (appServerUtilRef instanceof J2EEUtilWL) {
                    propFactory = "weblogic.jndi.WLInitialContextFactory";
                }
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail("J2EEUtil.getInitialContextWithParameters forced java.naming.factory.initial: " + propFactory);
                }
            }
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("J2EEUtil.getInitialContextWithParameters computed java.naming.factory.initial: " + propFactory);
            }
            if (propFactory != null) {
                jndiEnvironment.put("java.naming.factory.initial", propFactory);
            }
        }
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("J2EEUtil.getInitialContextWithParameters JNDI Environment (b): " + jndiEnvironment);
        }
        return jndiEnvironment;
    }

    public static InitialContext getInitialContextWithParameters(ConnectionImpl conn) throws NamingException {
        Properties jndiEnvironment = J2EEUtil.buildInitialContextParameters(conn, null);
        InitialContext initialContext = new InitialContext(jndiEnvironment);
        return initialContext;
    }

    public static InitialContext getInitialContextWithParameters(ConnectionImpl conn, Properties jndiEnvironment) throws NamingException {
        jndiEnvironment = J2EEUtil.buildInitialContextParameters(conn, jndiEnvironment);
        InitialContext initialContext = new InitialContext(jndiEnvironment);
        return initialContext;
    }

    static Properties getEJBJndiEnvironment(ConnectionImpl conn) {
        return J2EEUtil.getEJBJndiEnvironment(conn, null);
    }

    static Properties getEJBJndiEnvironment(ConnectionImpl conn, Properties env) {
        URI connURI;
        String providerPropertyValue;
        String propsAsString;
        Object propsAsParameter = null;
        if (conn != null) {
            propsAsParameter = conn.getParameter(ConfigurationParameter.EJB_CONTEXT_PROPERTIES);
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("Connection-specific FileNet.EJB.ContextProperties: " + propsAsParameter);
            }
        }
        if (propsAsParameter == null) {
            propsAsParameter = ConfigValueLookup.getValue("FileNet.EJB.ContextProperties", null);
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("JVM global FileNet.EJB.ContextProperties: " + propsAsParameter);
            }
        }
        try {
            propsAsString = (String)propsAsParameter;
        }
        catch (ClassCastException e) {
            throw new EngineRuntimeException(e, ExceptionCode.API_INVALID_CONFIGURATION_PARAMETER, new Object[]{"FileNet.EJB.ContextProperties"});
        }
        if (env == null) {
            env = new Properties();
        }
        if (propsAsString != null) {
            try {
                env.load(new ByteArrayInputStream(propsAsString.getBytes("ISO-8859-1")));
            }
            catch (Exception e) {
                throw new EngineRuntimeException(e, ExceptionCode.API_INVALID_CONFIGURATION_PARAMETER, new Object[]{"FileNet.EJB.ContextProperties"}, ExceptionContext.API_INVALID_CONFIGURATION_PARAMETER_STRING_VALUE, new Object[]{"java.util.Properties", propsAsString});
            }
        }
        if ((providerPropertyValue = (String)env.get("java.naming.provider.url")) != null) {
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("FileNet.EJB.ContextProperties has java.naming.provider.url=" + providerPropertyValue);
            }
            if (providerPropertyValue.equals("!")) {
                env.remove("java.naming.provider.url");
            }
        } else if (conn != null && (connURI = conn.getAsURI()) != null && connURI.isAbsolute()) {
            String origURI = conn.getURI();
            String authority = connURI.getAuthority();
            if (authority != null) {
                String scheme = connURI.getScheme();
                providerPropertyValue = scheme + "://" + authority;
            } else {
                int firstSlash = origURI.indexOf(47);
                providerPropertyValue = origURI;
                if (firstSlash > 0) {
                    providerPropertyValue = origURI.substring(0, firstSlash);
                }
            }
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("Reducing " + origURI + " to " + "java.naming.provider.url" + "=" + providerPropertyValue);
            }
            env.setProperty("java.naming.provider.url", providerPropertyValue);
        }
        return env;
    }

    public boolean isLoggerControlEnabledForName(String name) {
        return true;
    }

    public boolean isLoggerControlEnabledForLevel(String name, Level level) {
        return true;
    }

    public PasswordAuthentication getJ2CAliasCredentials(String aliasName) {
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("No implementation to map J2C alias '" + aliasName + "' to credentials in this appserver");
        }
        return null;
    }

    static {
        if (appServerUtilRef == null) {
            String initCntxFactory = J2EEUtil.getInitialContextFactory();
            String appServerOverride = ConfigValueLookup.getValue("com.filenet.AppServerType", null);
            if (appServerOverride == null) {
                appServerOverride = ConfigValueLookup.getValue("com.filenet.AppServer", null);
            }
            appServerType = J2EEType.getAppServerType(appServerOverride, initCntxFactory);
            String utilClass = null;
            switch (appServerType) {
                case 2: {
                    utilClass = "com.filenet.apiimpl.util.J2EEUtilWL";
                    break;
                }
                case 3: {
                    utilClass = "com.filenet.apiimpl.util.J2EEUtilWS";
                    break;
                }
                case 4: {
                    utilClass = "com.filenet.apiimpl.util.J2EEUtilWSL";
                }
            }
            if (utilClass != null) {
                try {
                    appServerUtilRef = (J2EEUtil)Class.forName(utilClass).newInstance();
                    if (logger.isDetailTraceEnabled()) {
                        logger.traceDetail("[J2EEUtil] detected app server type = " + J2EEType.getAppServer() + " : class of util = " + utilClass);
                    }
                    canInstantiateInitialContext = true;
                }
                catch (Throwable t) {
                    logger.error("[J2EEUtil] detection failed! : " + J2EEType.getAppServer() + " class " + utilClass + " not used because of the following error: " + t.toString());
                }
            }
            if (appServerUtilRef == null) {
                logger.warn("The code has NOT detected a need to introduce specific application server logic and is defaulting to using standard J2EE calls");
                appServerUtilRef = new J2EEUtil();
            }
        }
        propFactory = null;
    }
}

