/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.exception.Exceptions;
import com.filenet.apiimpl.util.BaseLogger;
import com.filenet.apiimpl.util.ConfigValueLookup;
import com.filenet.apiimpl.util.J2EEUtil;
import com.filenet.apiimpl.util.J2EEUtilWSBase;
import com.filenet.apiimpl.util.SubSystem;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.PasswordAuthentication;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;

public class J2EEUtilWSL
extends J2EEUtilWSBase {
    private static final BaseLogger logger = BaseLogger.getBaseLogger(J2EEUtilWSL.class, SubSystem.API);
    private static String ejb_jndi_prefix = "java:global/Engine-liberty/Engine-ejb/";
    private static final String WAS_MAPPING_JAAS_STANZA = "DefaultPrincipalMapping";
    private static Class<?> TR_CLASS = null;
    private static Method TR_REG_METHOD = null;
    private static Class<?> TC_CLASS = null;
    private static Method TC_ISDEBUG_METHOD = null;
    private static Method TC_GETLOGGER_METHOD = null;
    private static boolean alreadySaidForName = false;
    private static boolean alreadySaidForLevel = false;

    protected J2EEUtilWSL() {
    }

    @Override
    public String getTransactionManagerPath() {
        return null;
    }

    @Override
    public UserTransaction getUserTransaction(Context cntx) {
        try {
            String tJNDI = "java:comp/UserTransaction";
            Object userTrans = cntx.lookup(tJNDI);
            return (UserTransaction)userTrans;
        }
        catch (Throwable e) {
            if (e instanceof NameNotFoundException && e.getMessage() != null && e.getMessage().contains("not available to enterprise beans with container-managed")) {
                return null;
            }
            J2EEUtilWSL.handleException(e);
            return null;
        }
    }

    @Override
    public boolean isInGlobalTrans(Context cntx) {
        long t1 = System.currentTimeMillis();
        TransactionManager tm = this.getTransactionManager(cntx);
        try {
            int status = 6;
            Transaction ts = tm.getTransaction();
            if (ts != null) {
                status = tm.getTransaction().getStatus();
            }
            return status != 6;
        }
        catch (Throwable e) {
            if (e.getCause() instanceof EngineRuntimeException) {
                throw (EngineRuntimeException)e.getCause();
            }
            if (e instanceof EngineRuntimeException) {
                throw (EngineRuntimeException)e;
            }
            throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
    }

    @Override
    public int getTransactionStatus(Context cntx) {
        TransactionManager tm = this.getTransactionManager(cntx);
        int retStatus = 6;
        if (tm == null) {
            return retStatus;
        }
        try {
            retStatus = tm.getStatus();
        }
        catch (Throwable e) {
            if (e.getCause() instanceof EngineRuntimeException) {
                throw (EngineRuntimeException)e.getCause();
            }
            if (e instanceof EngineRuntimeException) {
                throw (EngineRuntimeException)e;
            }
            throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
        return retStatus;
    }

    @Override
    public synchronized TransactionManager getTransactionManager(Context cntx) {
        try {
            Class cl = TransactionManagerFactorySelector.tmfClass;
            Method method = cl.getMethod("getTransactionManager", null);
            Object tm = method.invoke(null, (Object[])null);
            return (TransactionManager)tm;
        }
        catch (Throwable e) {
            J2EEUtilWSL.handleException(e);
            return null;
        }
    }

    @Override
    public String getRemoteEnginePath() {
        return ConfigValueLookup.getValue("RemoteEnginePath", ejb_jndi_prefix + "Engine!com.filenet.apiimpl.transport.ejbstubs.EngineHome");
    }

    @Override
    public String getLocalEnginePath() {
        return ConfigValueLookup.getValue("LocalEnginePath", ejb_jndi_prefix + "Engine!com.filenet.apiimpl.transport.ejbstubs.EngineLocalHome");
    }

    @Override
    public String getLocalEngineCorePath() {
        return ejb_jndi_prefix + "EngineCore!com.filenet.engine.ejb.EngineCoreLocalHome";
    }

    @Override
    public String getRemoteEngineContentPath() {
        return ConfigValueLookup.getValue("RemoteContentPath", ejb_jndi_prefix + "EngineContent!com.filenet.apiimpl.transport.ejbstubs.EngineContentHome");
    }

    @Override
    public String getRemoteEngineContentAffinityPath() {
        return ConfigValueLookup.getValue("RemoteContentPath", ejb_jndi_prefix + "EngineContent!com.filenet.apiimpl.transport.ejbstubs.EngineContentHome");
    }

    @Override
    public String getLocalEngineContentPath() {
        return ConfigValueLookup.getValue("LocalContentPath", ejb_jndi_prefix + "EngineContent!com.filenet.apiimpl.transport.ejbstubs.EngineContentLocalHome");
    }

    @Override
    public String getLocalEngineContentCorePath() {
        return ejb_jndi_prefix + "EngineContentCore!com.filenet.engine.ejb.EngineContentCoreLocalHome";
    }

    @Override
    public String getLocalEngineCommPath() {
        return ConfigValueLookup.getValue("LocalCommPath", ejb_jndi_prefix + "EngineComm!com.filenet.apiimpl.transport.ejbstubs.EngineCommLocalHome");
    }

    @Override
    public String getLocalEngineCommCorePath() {
        return ejb_jndi_prefix + "EngineCommCore!com.filenet.engine.ejb.EngineCommCoreLocalHome";
    }

    @Override
    public String getJaasContextFile() {
        return "jaas.conf.Liberty";
    }

    @Override
    public void initializeORB() {
        J2EEUtilWSL.initializeORBInternal();
    }

    private static void initializeORBInternal() {
        try {
            J2EEUtil.getInstance();
            InitialContext ic = J2EEUtil.getInitialContextWithParameters(null);
            ic.lookup("");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public PasswordAuthentication getJ2CAliasCredentials(String aliasName) {
        PasswordAuthentication aliasDetails = null;
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("seeking J2C alias details for '" + aliasName + "'");
        }
        return aliasDetails;
    }

    private void trace(String method, String message, Object ... params) {
        this.trace(J2EEUtilWSL.class, method, message, params);
    }

    private static final PasswordAuthentication getJ2CAliasCredentialsInternal(String aliasName) throws IllegalAccessException, InvocationTargetException, LoginException {
        PasswordAuthentication aliasDetails;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(MAPPING_ALIAS_KEY, aliasName);
        CallbackHandler callbackHandler = J2EEUtilWSL.getMappingCallbackHandler(map);
        LoginContext lc = new LoginContext(WAS_MAPPING_JAAS_STANZA, callbackHandler);
        lc.login();
        Subject subject = lc.getSubject();
        Set<Object> creds = subject.getPrivateCredentials();
        PasswordCredential result = (PasswordCredential)creds.iterator().next();
        if (result == null) {
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("No alias details available for '" + aliasName + "', null PasswordCredential mapped");
            }
            aliasDetails = null;
        } else {
            String userName = result.getUserName();
            if (userName == null || userName.length() == 0) {
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail("No alias details available for '" + aliasName + "', null or empty user name mapped");
                }
                aliasDetails = null;
            } else {
                aliasDetails = new PasswordAuthentication(result.getUserName(), result.getPassword());
            }
            char[] password = result.getPassword();
            if (logger.isDetailTraceEnabled()) {
                if (password == null) {
                    logger.traceDetail("Alias details available for '" + aliasName + "', user '" + userName + "', null password");
                } else if (password.length == 0) {
                    logger.traceDetail("Alias details available for '" + aliasName + "', user '" + userName + "', empty password");
                } else {
                    logger.traceDetail("Alias details available for '" + aliasName + "', user '" + userName + "', with a password");
                }
            }
        }
        return aliasDetails;
    }

    private static final CallbackHandler getMappingCallbackHandler(Map map) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object factory = j2caFactoryGetInstanceMethod.invoke(null, (Object[])null);
        Object[] args = new Object[]{map, null};
        CallbackHandler cbh = (CallbackHandler)j2caGetCallbackHandlerMethod.invoke(factory, args);
        return cbh;
    }

    @Override
    public boolean isLoggerControlEnabledForName(String name) {
        if (TR_REG_METHOD == null || TC_ISDEBUG_METHOD == null) {
            return true;
        }
        Object[] regMethodArgs = new Object[]{name, BaseLogger.class, null};
        try {
            Object traceComponent = TR_REG_METHOD.invoke(null, regMethodArgs);
            Object isEnabled = TC_ISDEBUG_METHOD.invoke(traceComponent, (Object[])null);
            return (Boolean)isEnabled;
        }
        catch (Exception e) {
            if (!alreadySaidForName) {
                System.out.println("P8CE logger WLP reflection problem (forName): " + e);
                alreadySaidForName = true;
            }
            return true;
        }
    }

    @Override
    public boolean isLoggerControlEnabledForLevel(String name, Level level) {
        if (TR_REG_METHOD == null || TC_GETLOGGER_METHOD == null) {
            return true;
        }
        Object[] regMethodArgs = new Object[]{name, BaseLogger.class, null};
        try {
            Object traceComponent = TR_REG_METHOD.invoke(null, regMethodArgs);
            Logger jdkLogger = (Logger)TC_GETLOGGER_METHOD.invoke(traceComponent, (Object[])null);
            boolean isEnabled = jdkLogger.isLoggable(level);
            return isEnabled;
        }
        catch (Exception e) {
            if (!alreadySaidForLevel) {
                System.out.println("P8CE logger WLP reflection problem (forLevel): " + e);
                alreadySaidForLevel = true;
            }
            return true;
        }
    }

    static {
        try {
            try {
                TR_CLASS = Class.forName("com.ibm.websphere.ras.Tr");
                Class[] registerArgTypes = new Class[]{String.class, Class.class, String.class};
                TR_REG_METHOD = TR_CLASS.getMethod("register", registerArgTypes);
                TC_CLASS = Class.forName("com.ibm.websphere.ras.TraceComponent");
                TC_ISDEBUG_METHOD = TC_CLASS.getMethod("isDebugEnabled", null);
                TC_GETLOGGER_METHOD = TC_CLASS.getMethod("getLogger", null);
            }
            catch (Exception e) {
                System.out.println("P8CE logger WLP reflection problem (static): " + e);
            }
            logger.traceDetail("Resolving static reflective items for doAs");
            doAsClass = Class.forName("com.ibm.websphere.security.auth.WSSubject");
            Class[] doAsArgTypes = new Class[]{Subject.class, PrivilegedExceptionAction.class};
            doAsMethod = doAsClass.getDeclaredMethod("doAs", doAsArgTypes);
            getSubjectMethod = doAsClass.getDeclaredMethod("getCallerSubject", null);
            getRunAsSubjectMethod = doAsClass.getDeclaredMethod("getRunAsSubject", null);
            try {
                Class<?> propagationHelperClass = Class.forName("com.ibm.websphere.security.openidconnect.PropagationHelper");
                getAccessTokenMethod = propagationHelperClass.getDeclaredMethod("getAccessToken", null);
            }
            catch (Exception e) {
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail("OIDC PropagationHelper not available: " + Exceptions.printStackTrace(e));
                }
                logger.info("OIDC PropagationHelper not available: " + e.getLocalizedMessage());
            }
            try {
                Class<?> webSecurityHelperClass = Class.forName("com.ibm.websphere.security.web.WebSecurityHelper");
                getSSOCookieMethod = webSecurityHelperClass.getDeclaredMethod("getSSOCookieFromSSOToken", null);
            }
            catch (Exception e) {
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail("WebSecurityHelper not available: " + Exceptions.printStackTrace(e));
                }
                logger.info("WebSecurityHelper not available: " + e.getLocalizedMessage());
            }
            logger.traceDetail("static call to internally initialize ORB");
            J2EEUtilWSL.initializeORBInternal();
        }
        catch (Throwable e) {
            J2EEUtilWSL.handleException(e);
        }
    }

    private static class TransactionManagerFactorySelector {
        private static final String WSTMF_CLASS_5_1 = "com.ibm.ws.Transaction.TransactionManagerFactory";
        private static final String WSTMF_CLASS_5_0 = "com.ibm.ejs.jts.jta.TransactionManagerFactory";
        private static final String WSTMF_CLASS_4 = "com.ibm.ejs.jts.jta.JTSXA";
        private static final String WSTMF_CLASS_8 = "com.ibm.tx.jta.TransactionManagerFactory";
        private static Class tmfClass = null;
        private static Exception savedEx = null;

        private TransactionManagerFactorySelector() {
        }

        private static Class getTransactionManagerFactoryClass(String factoryClass, String versionNumber) {
            try {
                return Class.forName(factoryClass);
            }
            catch (Exception ex) {
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail("Could not find WebSphere " + versionNumber + " TransactionManagerFactory class " + factoryClass + ".");
                }
                if (savedEx == null) {
                    savedEx = ex;
                }
                return null;
            }
        }

        static {
            tmfClass = TransactionManagerFactorySelector.getTransactionManagerFactoryClass(WSTMF_CLASS_5_1, "5.1");
            if (tmfClass == null) {
                tmfClass = TransactionManagerFactorySelector.getTransactionManagerFactoryClass(WSTMF_CLASS_5_0, "5.0");
            }
            if (tmfClass == null) {
                tmfClass = TransactionManagerFactorySelector.getTransactionManagerFactoryClass(WSTMF_CLASS_4, "4");
            }
            if (tmfClass == null) {
                tmfClass = TransactionManagerFactorySelector.getTransactionManagerFactoryClass(WSTMF_CLASS_8, "8");
            }
            if (tmfClass == null) {
                throw new EngineRuntimeException(savedEx, ExceptionCode.E_CLASS_LOADING_ERROR, new Object[]{"com.ibm.ws.Transaction.TransactionManagerFactory, com.ibm.ejs.jts.jta.TransactionManagerFactory, com.ibm.ejs.jts.jta.JTSXA"});
            }
        }
    }
}

