/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.api.constants.DatabaseType;
import com.filenet.api.core.Domain;
import com.filenet.api.core.Factory;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.core.RepositoryObject;
import com.filenet.api.util.Id;
import com.filenet.apiimpl.core.ConnectionImpl;
import com.filenet.apiimpl.core.IndependentlyPersistableObjectImpl;
import java.util.concurrent.ConcurrentHashMap;

public class ObjectStoreIdUtil {
    private static ConcurrentHashMap<ConnectionImpl, ConcurrentHashMap<String, OSCacheEntry>> mapConnectionToCache = new ConcurrentHashMap();

    public static Id createIdForNewObject(IndependentlyPersistableObjectImpl ip) {
        if (ip instanceof RepositoryObject) {
            ConnectionImpl conn = (ConnectionImpl)ip.getConnection();
            ConcurrentHashMap<String, OSCacheEntry> connCache = mapConnectionToCache.get(conn);
            if (connCache == null) {
                connCache = new ConcurrentHashMap();
                mapConnectionToCache.put(conn, connCache);
            }
            String objStoreIdOrName = ip.getObjectReference().getObjectStoreIdentity();
            OSCacheEntry osc = connCache.get(objStoreIdOrName = objStoreIdOrName.toLowerCase());
            if (osc == null || osc.hasExpired()) {
                DatabaseType dbType = null;
                try {
                    Domain domain = Factory.Domain.getInstance(conn, null);
                    ObjectStore objStore = Factory.ObjectStore.fetchInstance(domain, objStoreIdOrName, null);
                    if (objStore.get_UseSequentialIds().booleanValue()) {
                        dbType = objStore.get_DatabaseConnection().get_DatabaseType();
                    }
                    osc = new OSCacheEntry(dbType);
                    connCache.put(objStore.get_SymbolicName().toLowerCase(), osc);
                    connCache.put(objStore.get_Id().toString().toLowerCase(), osc);
                }
                catch (Throwable t) {
                    osc = new OSCacheEntry(dbType);
                    connCache.put(objStoreIdOrName, osc);
                }
            }
            return osc.createId();
        }
        return Id.createId();
    }

    private static class OSCacheEntry {
        private static final long TTL_MSECS = 1800000L;
        private long expiryTimeMillis;
        private DatabaseType dbType;

        private OSCacheEntry(DatabaseType dbType) {
            this.dbType = dbType;
            this.expiryTimeMillis = System.currentTimeMillis() + 1800000L;
        }

        private Id createId() {
            if (this.dbType == null) {
                return Id.createId();
            }
            return Id.createSequentialId(this.dbType);
        }

        private boolean hasExpired() {
            return System.currentTimeMillis() > this.expiryTimeMillis;
        }
    }
}

