/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util.classloader;

import com.filenet.api.collection.ContentElementList;
import com.filenet.api.core.Annotation;
import com.filenet.api.core.Connection;
import com.filenet.api.core.ContentElement;
import com.filenet.api.core.ContentTransfer;
import com.filenet.api.core.Document;
import com.filenet.api.core.Domain;
import com.filenet.api.core.Factory;
import com.filenet.api.core.IndependentObject;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.util.Id;
import com.filenet.apiimpl.util.BaseLogger;
import com.filenet.apiimpl.util.SubSystem;
import com.filenet.apiimpl.util.classloader.CodeModuleClassLoader;
import com.filenet.apiimpl.util.classloader.ContentElementURLDataItems;
import com.filenet.apiimpl.util.classloader.ContentElementURLutil;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import java.util.Date;

public class ContentElementURLConnection
extends URLConnection {
    private static final BaseLogger logger = BaseLogger.getBaseLogger(ContentElementURLConnection.class, SubSystem.CodeModule);
    private ContentTransfer ct = null;
    private URI eltUri;
    private ContentElementURLDataItems u;
    private Date lastModified;
    private static final PropertyFilter FETCH_PF = new PropertyFilter();

    ContentElementURLConnection(URL eltUrl) {
        super(eltUrl);
        URI connectionURI;
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("new ContentElementURLConnection(" + eltUrl + ")");
        }
        try {
            this.eltUri = eltUrl.toURI();
        }
        catch (URISyntaxException e) {
            throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
        this.u = ContentElementURLutil.parseQueryPart(this.eltUri.getQuery());
        try {
            connectionURI = new URI(this.eltUri.getScheme(), null, this.eltUri.getHost(), this.eltUri.getPort(), this.eltUri.getPath(), null, null);
        }
        catch (URISyntaxException e) {
            throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
        Connection connection = Factory.Connection.getConnection(connectionURI.toString());
        this.u.setConnection(connection);
    }

    private void checkConnect() {
        if (this.ct == null) {
            this.connect();
            if (this.ct == null) {
                Object[] args = new Object[]{this.u.getEltNum() + "", this.eltUri};
                throw new EngineRuntimeException(ExceptionCode.EVENT_CM_ELTNO_NOT_FOUND, args);
            }
        }
    }

    @Override
    public void connect() {
        ContentElementList celist;
        IndependentObject docOrAnn;
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("ContentElementURLConnection.connect() " + this);
        }
        if ((docOrAnn = this.fetchDocOrAnn()) instanceof Document) {
            Document doc = (Document)docOrAnn;
            celist = doc.get_ContentElements();
            this.lastModified = doc.get_DateLastModified();
        } else if (docOrAnn instanceof Annotation) {
            Annotation ann = (Annotation)docOrAnn;
            celist = ann.get_ContentElements();
            this.lastModified = ann.get_DateLastModified();
        } else {
            Object[] args = new Object[]{this.u.getClassIdentity(), this.eltUri};
            throw new EngineRuntimeException(ExceptionCode.EVENT_CM_UNEXPECTED_OBJECT, args);
        }
        this.ct = this.findElement(celist);
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("ContentElementURLConnection.connect() " + this + " => " + this.ct);
        }
    }

    private final ContentTransfer findElement(ContentElementList celist) {
        int eltNum = this.u.getEltNum();
        int eltSeqNum = this.u.getEltSeqNum();
        ContentElement celt = null;
        if (eltNum >= 0) {
            celt = this.findEltByPosition(celist, eltNum, eltSeqNum);
        } else if (eltSeqNum >= 0) {
            celt = this.findEltByESN(celist, eltSeqNum);
        } else {
            Object[] args = new Object[]{"<unknown>", this.eltUri};
            throw new EngineRuntimeException(ExceptionCode.EVENT_CM_ELTNO_NOT_FOUND, args);
        }
        if (celt instanceof ContentTransfer) {
            return (ContentTransfer)celt;
        }
        Object[] args = new Object[]{this.eltUri};
        throw new EngineRuntimeException(ExceptionCode.EVENT_CM_ELT_NOT_CT, args);
    }

    private final ContentElement findEltByPosition(ContentElementList celist, int eltNum, int eltSeqNum) {
        if (celist.size() < eltNum) {
            Object[] args = new Object[]{eltNum + "", this.eltUri};
            throw new EngineRuntimeException(ExceptionCode.EVENT_CM_ELTNO_NOT_FOUND, args);
        }
        ContentElement celt = (ContentElement)celist.get(eltNum);
        if (eltSeqNum >= 0 && celt.get_ElementSequenceNumber() != eltSeqNum) {
            Object[] args = new Object[]{eltNum + "", celt.get_ElementSequenceNumber() + "", this.eltUri};
            throw new EngineRuntimeException(ExceptionCode.EVENT_CM_ELT_NUMBERING_MISMATCH, args);
        }
        return celt;
    }

    private ContentElement findEltByESN(ContentElementList celist, int eltSeqNum) {
        for (ContentElement celt : celist) {
            if (celt.get_ElementSequenceNumber() != eltSeqNum) continue;
            return celt;
        }
        Object[] args = new Object[]{eltSeqNum + "", this.eltUri};
        throw new EngineRuntimeException(ExceptionCode.EVENT_CM_ESN_NOT_FOUND, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IndependentObject fetchDocOrAnn() {
        IndependentObject docOrAnn;
        Connection connection = this.u.getConnection();
        Domain domain = Factory.Domain.getInstance(connection, null);
        String osIdentity = this.u.getObjectStoreIdentity();
        ObjectStore os = Id.isId(osIdentity) ? Factory.ObjectStore.getInstance(domain, new Id(osIdentity)) : Factory.ObjectStore.getInstance(domain, osIdentity);
        String objectIdentity = this.u.getObjectIdentity();
        boolean previous = CodeModuleClassLoader.preRPC();
        try {
            docOrAnn = Id.isId(objectIdentity) ? os.fetchObject(this.u.getClassIdentity(), new Id(objectIdentity), FETCH_PF) : os.fetchObject(this.u.getClassIdentity(), objectIdentity, FETCH_PF);
        }
        finally {
            CodeModuleClassLoader.postRPC(previous);
        }
        return docOrAnn;
    }

    @Override
    public final int getContentLength() {
        this.checkConnect();
        return this.ct.get_ContentSize().intValue();
    }

    @Override
    public final String getContentType() {
        this.checkConnect();
        return this.ct.get_ContentType();
    }

    @Override
    public final InputStream getInputStream() {
        InputStream contentStream;
        this.checkConnect();
        boolean previous = CodeModuleClassLoader.preRPC();
        try {
            contentStream = this.ct.accessContentStream();
        }
        finally {
            CodeModuleClassLoader.postRPC(previous);
        }
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("ContentElementURLConnection.getInputStream() => " + contentStream);
        }
        return contentStream;
    }

    @Override
    public final long getLastModified() {
        this.checkConnect();
        return this.lastModified.getTime();
    }

    @Override
    public Permission getPermission() {
        return null;
    }

    static {
        String props = "DateLastModified ContentElements ContentType ContentSize ElementSequenceNumber";
        FETCH_PF.addIncludeProperty(999, null, null, props, null);
    }
}

