/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util.json;

import com.filenet.apiimpl.util.json.JSONArray;
import com.filenet.apiimpl.util.json.JSONArtifact;
import com.filenet.apiimpl.util.json.JSONObject;
import com.filenet.apiimpl.util.json.Tokenizer;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;

public class JSON {
    public static JSONArtifact parse(String json) throws IOException {
        return JSON.parse(new StringReader(json));
    }

    public static JSONArtifact parse(InputStream stream) throws IOException {
        return JSON.parse(new InputStreamReader(stream));
    }

    public static JSONArtifact parse(Reader reader) throws IOException {
        Tokenizer tkr = new Tokenizer(reader);
        Tokenizer.Token tok = tkr.nextToken();
        if (tok.getTokenType().equals((Object)Tokenizer.TokenType.OPEN_BRACE)) {
            return new JSONObject(tkr);
        }
        if (tok.getTokenType().equals((Object)Tokenizer.TokenType.OPEN_SQUARE)) {
            return new JSONArray(tkr);
        }
        throw new RuntimeException("Unexpected token " + tok + " while parsing JSON object; expecting OPEN_BRACE or OPEN_SQUARE");
    }

    static Object decodeToken(Tokenizer.Token tok, Tokenizer tkr) throws IOException {
        Tokenizer.TokenType tt = tok.getTokenType();
        if (tt == Tokenizer.TokenType.OPEN_BRACE) {
            return new JSONObject(tkr);
        }
        if (tt == Tokenizer.TokenType.OPEN_SQUARE) {
            return new JSONArray(tkr);
        }
        if (tt == Tokenizer.TokenType.QUOTED_STRING) {
            return tok.getValue();
        }
        if (tt == Tokenizer.TokenType.UNQUOTED_STRING) {
            String val = tok.getValue();
            if (val.equalsIgnoreCase("null")) {
                return null;
            }
            if (val.equalsIgnoreCase("true")) {
                return Boolean.TRUE;
            }
            if (val.equalsIgnoreCase("false")) {
                return Boolean.FALSE;
            }
            try {
                return Long.valueOf(val);
            }
            catch (NumberFormatException nfe) {
                try {
                    return Double.valueOf(val);
                }
                catch (NumberFormatException nfe2) {
                    throw new RuntimeException("Unexpected '" + val + "' while parsing JSON; expecting numeric");
                }
            }
        }
        throw new RuntimeException("Unexpected token " + tok + " while parsing JSON; expecting element value");
    }

    static void toJsonString(StringBuilder sb, Object value) {
        if (value == null) {
            sb.append("null");
        } else if (value instanceof String) {
            String str = (String)value;
            sb.append('\"');
            for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (c == '\\' || c == '\"') {
                    sb.append("\\").append(c);
                    continue;
                }
                if (c == '\b') {
                    sb.append("\\b");
                    continue;
                }
                if (c == '\f') {
                    sb.append("\\f");
                    continue;
                }
                if (c == '\n') {
                    sb.append("\\n");
                    continue;
                }
                if (c == '\r') {
                    sb.append("\\r");
                    continue;
                }
                if (c == '\t') {
                    sb.append("\\t");
                    continue;
                }
                sb.append(c);
            }
            sb.append('\"');
        } else if (value instanceof Boolean) {
            Boolean b = (Boolean)value;
            sb.append(b != false ? "true" : "false");
        } else if (value instanceof JSONObject) {
            ((JSONObject)value).toJsonString(sb);
        } else if (value instanceof JSONArray) {
            ((JSONArray)value).toJsonString(sb);
        } else {
            sb.append(value);
        }
    }
}

