/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util.json;

import com.filenet.api.core.Connection;
import com.filenet.api.core.EngineObject;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.property.Property;
import com.filenet.apiimpl.collection.AbstractEngineSet;
import com.filenet.apiimpl.collection.RepositoryRowCollectionImpl;
import com.filenet.apiimpl.core.ObjectReferenceBase;
import com.filenet.apiimpl.property.PropertyEngineObjectImpl;
import com.filenet.apiimpl.property.PropertyEngineObjectListImpl;
import com.filenet.apiimpl.property.PropertyEngineObjectSetImpl;
import com.filenet.apiimpl.util.json.JSONObject;
import com.filenet.apiimpl.wsi.serialization.SerializerContext;
import com.filenet.apiimpl.wsi.serialization.TokenWriterJson;
import com.filenet.apiimpl.wsi.serialization.Util;
import com.filenet.apiimpl.wsi.serialization.core.CollectionTerminatorSerialization;
import com.filenet.apiimpl.wsi.serialization.core.EngineObjectSerialization;
import com.filenet.apiimpl.wsi.serialization.core.RepositoryRowSerialization;
import com.filenet.apiimpl.wsi.serialization.operation.GetObjectsResponseSerialization;
import com.filenet.apiimpl.wsi.serialization.property.PropertyDeserializerCall;
import java.io.StringWriter;

public class Serialization {
    public static EngineObject deserializeEngineObject(JSONObject o, Connection conn, boolean hasDeltasFlag) {
        PropertyDeserializerCall call = new PropertyDeserializerCall((ObjectReferenceBase)null);
        return (EngineObject)EngineObjectSerialization.INSTANCE.deserializeJson(conn, o, "object", hasDeltasFlag, call);
    }

    public static JSONObject serializeEngineObjectResponse(EngineObject eo) {
        try {
            StringWriter writer = new StringWriter();
            TokenWriterJson tokenWriter = new TokenWriterJson(writer, "fetchInstance");
            SerializerContext sCtx = null;
            com.filenet.apiimpl.wsi.serialization.Serialization ser = GetObjectsResponseSerialization.ENGINE_OBJECT;
            sCtx = new SerializerContext(false, "http://www.filenet.com/ns/fnce/2006/11/ws/SOAP/wsdl", tokenWriter, false);
            sCtx.setShouldSortProperties(true);
            tokenWriter.startDocument();
            ser.serialize(eo, sCtx);
            tokenWriter.endDocument();
            tokenWriter.flush();
            tokenWriter.close();
            String s = writer.toString();
            return JSONObject.parse(s);
        }
        catch (EngineRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String serializeProperty(Property po) {
        try {
            StringWriter writer = new StringWriter();
            TokenWriterJson tokenWriter = new TokenWriterJson(writer, "fetchInstance");
            SerializerContext sCtx = null;
            com.filenet.apiimpl.wsi.serialization.Serialization ser = null;
            if (po instanceof PropertyEngineObjectImpl) {
                ser = GetObjectsResponseSerialization.PROPERTY_OBJECT;
            } else if (po instanceof PropertyEngineObjectSetImpl) {
                ser = GetObjectsResponseSerialization.PROPERTY_SET;
            } else if (po instanceof PropertyEngineObjectListImpl) {
                ser = GetObjectsResponseSerialization.PROPERTY_LIST;
            } else {
                throw new UnsupportedOperationException("Unknown property type: " + po.getPropertyName());
            }
            sCtx = new SerializerContext(false, "http://www.filenet.com/ns/fnce/2006/11/ws/SOAP/wsdl", tokenWriter, false);
            sCtx.setShouldSortProperties(true);
            tokenWriter.startDocument();
            ser.serialize(po, sCtx);
            tokenWriter.endDocument();
            tokenWriter.flush();
            tokenWriter.close();
            return writer.toString();
        }
        catch (EngineRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String serializeObjectSet(AbstractEngineSet set, String op) {
        try {
            StringWriter writer = new StringWriter();
            TokenWriterJson tokenWriter = new TokenWriterJson(writer, op);
            SerializerContext sCtx = null;
            sCtx = new SerializerContext(false, "http://www.filenet.com/ns/fnce/2006/11/ws/MTOM/wsdl", tokenWriter, false);
            sCtx.setShouldSortProperties(true);
            EngineObjectSerialization ser = EngineObjectSerialization.INSTANCE;
            Util util = Util.INSTANCE;
            tokenWriter.startDocument();
            sCtx.enterElement("ObjectSet", sCtx.getOptionalSchemaType("ObjectSetType"));
            if (set instanceof RepositoryRowCollectionImpl) {
                sCtx.serializeObjectArray("Object", RepositoryRowSerialization.INSTANCE, Util.objects(set));
            } else {
                sCtx.serializeObjectArray("Object", EngineObjectSerialization.INSTANCE, Util.objects(set));
            }
            if (set.getTraversalError() == null) {
                sCtx.serializeObject("CollectionTerminator", CollectionTerminatorSerialization.INSTANCE, (Object)Util.nullAsEmpty(Util.continuation(set)));
            } else {
                sCtx.serializeObject("CollectionTerminator", CollectionTerminatorSerialization.INSTANCE, (Object)set.getTraversalError());
            }
            sCtx.leaveElement();
            tokenWriter.endDocument();
            tokenWriter.flush();
            String s = writer.toString();
            return s;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

