/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi.serialization;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.exception.ExceptionContext;
import com.filenet.apiimpl.transport.TransportLogger;
import com.filenet.apiimpl.util.ConfigValueLookup;
import com.filenet.apiimpl.util.SubSystem;
import com.filenet.apiimpl.wsi.ServiceSessionNst;
import com.filenet.apiimpl.wsi.serialization.TokenReader;
import com.filenet.apiimpl.wsi.serialization.TokenWriterNst;
import com.filenet.apiimpl.wsi.serialization.Util;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public final class TokenReaderNst
implements TokenReader {
    private static final TransportLogger logger = TransportLogger.getLogger(TokenReaderNst.class, SubSystem.WSI);
    private static XMLInputFactory sIF;
    private static final String XLXP_FACTORY_IMPL = "com.ibm.xml.xlxp.api.stax.XMLInputFactoryImpl";
    private static boolean STAX_DTD_FIX_WORKED;
    private XMLStreamReader sR;
    private final ServiceSessionNst session;
    private String opName;
    private final List path = new ArrayList();
    private int pathSize = 0;
    private final boolean trace;
    private TokenWriterNst tW = null;
    private OutputStream cloneToStream = null;

    private static void initFactory(ServiceSessionNst session) {
        String desiredStax = ConfigValueLookup.getValue("FileNet.WSI.stax.XMLInputFactory", XLXP_FACTORY_IMPL);
        try {
            sIF = XMLInputFactory.newFactory();
        }
        catch (Throwable t) {
            throw Util.ereOrIoe_common(t, ExceptionCode.TRANSPORT_WSI_DESERIALIZATION_ERROR, new String[]{"<init>", "<init>"}, ExceptionContext.TRANSPORT_WSI_NO_STAX_PARSER, null, ExceptionContext.E_DURATION_WAS_MS, session.durationWas());
        }
        try {
            sIF.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        }
        catch (IllegalArgumentException e) {
            logger.traceDetail("Not honored by XMLInputFactory: javax.xml.stream.isCoalescing=true");
            String sifClassName = sIF.getClass().getName();
            logger.traceDetail("XMLInputFactory is of class " + sifClassName);
            throw new EngineRuntimeException(e, ExceptionCode.TRANSPORT_WSI_DESERIALIZATION_ERROR, new Object[]{"<init>", "<init>"}, ExceptionContext.TRANSPORT_WSI_STAX_MUST_COALESCE, new Object[]{sifClassName}, ExceptionContext.E_DURATION_WAS_MS, session.durationWas());
        }
        try {
            sIF.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
            STAX_DTD_FIX_WORKED = true;
            logger.traceDetail("Disabled DTD support for WSI serialization. Value of 'com.ibm.xml.xlxp.support.dtd.compat.mode' is " + System.getProperty("com.ibm.xml.xlxp.support.dtd.compat.mode"));
        }
        catch (IllegalArgumentException e) {
            logger.traceDetail("Not honored by XMLInputFactory: javax.xml.stream.supportDTD=false");
            String sifClassName = sIF.getClass().getName();
            logger.traceDetail("XMLInputFactory is of class " + sifClassName);
            throw new EngineRuntimeException(e, ExceptionCode.TRANSPORT_WSI_DESERIALIZATION_ERROR, new Object[]{"<init>", "<init>"}, ExceptionContext.TRANSPORT_WSI_STAX_MUST_DISABLE_DTD, new Object[]{sifClassName}, ExceptionContext.E_DURATION_WAS_MS, session.durationWas());
        }
    }

    public TokenReaderNst(ServiceSessionNst ssn, InputStream is, String opName) {
        this.session = ssn;
        this.opName = opName;
        this.trace = logger.isDetailTraceEnabled();
        if (sIF == null) {
            TokenReaderNst.initFactory(this.session);
        }
        try {
            if (STAX_DTD_FIX_WORKED) {
                this.sR = sIF.createXMLStreamReader(is);
            } else {
                this.doExpensivePerInstanceSAXFallback(is);
            }
        }
        catch (EngineRuntimeException ere) {
            throw ere;
        }
        catch (Throwable t) {
            throw Util.ereOrIoe_common(t, ExceptionCode.TRANSPORT_WSI_DESERIALIZATION_ERROR, new String[]{opName, this.getPath()}, ExceptionContext.TRANSPORT_WSI_NO_STAX_PARSER, null, ExceptionContext.E_DURATION_WAS_MS, this.session.durationWas());
        }
    }

    private void doExpensivePerInstanceSAXFallback(InputStream is) throws SAXNotRecognizedException, SAXNotSupportedException, SAXException, XMLStreamException {
        XMLStreamReader xmlStreamReader;
        block7: {
            xmlStreamReader = null;
            SAXParserFactory spf = SAXParserFactory.newInstance();
            try {
                String FEATURE = "http://apache.org/xml/features/disallow-doctype-decl";
                spf.setFeature(FEATURE, true);
                SAXParser sp = spf.newSAXParser();
                xmlStreamReader = sIF.createXMLStreamReader(new SAXSource(sp.getXMLReader(), new InputSource(is)));
            }
            catch (ParserConfigurationException pce) {
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail("Could not disable DTD support using Xerces feature. " + pce);
                }
                try {
                    String FEATURE = "http://xml.org/sax/features/external-general-entities";
                    spf.setFeature(FEATURE, false);
                    FEATURE = "http://xml.org/sax/features/external-parameter-entities";
                    spf.setFeature(FEATURE, false);
                    SAXParser sp = spf.newSAXParser();
                    xmlStreamReader = sIF.createXMLStreamReader(new SAXSource(sp.getXMLReader(), new InputSource(is)));
                }
                catch (ParserConfigurationException pce2) {
                    if (!logger.isDetailTraceEnabled()) break block7;
                    logger.traceDetail("Could not disable DTD support using JDK7+ feature. " + pce2);
                }
            }
        }
        if (xmlStreamReader == null) {
            logger.traceDetail("WSI DTD support might not be disabled unless this JVM argument is set: com.ibm.xml.xlxp.support.dtd.compat.mode=false");
            this.sR = sIF.createXMLStreamReader(is);
        } else {
            this.sR = xmlStreamReader;
        }
    }

    public void setOpName(String opName) {
        this.opName = opName;
    }

    @Override
    public TokenReader.State currentState() {
        return this.stt2tt(this.sR.getEventType());
    }

    @Override
    public int depth() {
        return this.currentState() == TokenReader.State.END_TOKEN ? this.pathSize : this.pathSize - 1;
    }

    @Override
    public String getAttributeValue(String name) {
        return this.getAttributeValue(null, name);
    }

    @Override
    public String getAttributeValue(String uri, String name) {
        return this.sR.getAttributeValue(uri, name);
    }

    @Override
    public String getLocalName() {
        return this.sR.getLocalName();
    }

    @Override
    public String getNamespace() {
        return this.sR.getNamespaceURI();
    }

    @Override
    public TokenReader.State next() {
        try {
            this.sR.next();
            this.cloneCurrentToken();
            TokenReader.State currentState = this.currentState();
            if (currentState == TokenReader.State.START_TOKEN) {
                PathItem pathItem = new PathItem();
                pathItem.setElementName(this.getLocalName());
                pathItem.setClassId(this.getAttributeValue("classId"));
                pathItem.setObjectId(this.getAttributeValue("objectId"));
                this.pushToken(pathItem);
            } else if (currentState == TokenReader.State.END_TOKEN) {
                this.popToken();
            }
            if (this.trace) {
                this.trace();
            }
            return currentState;
        }
        catch (Throwable t) {
            throw Util.ereOrIoeD(t, new String[]{this.opName, this.getPath()}, ExceptionContext.TRANSPORT_WSI_PARSING_XML, null, ExceptionContext.E_DURATION_WAS_MS, this.session.durationWas());
        }
    }

    @Override
    public String readContent() {
        return this.sR.getText();
    }

    @Override
    public InputStream referenceAttachment(String contentId) {
        return this.session.getContentInputStream(contentId);
    }

    private TokenReader.State stt2tt(int stt) {
        switch (stt) {
            case 1: {
                return TokenReader.State.START_TOKEN;
            }
            case 2: {
                return TokenReader.State.END_TOKEN;
            }
            case 4: {
                return TokenReader.State.CONTENT;
            }
        }
        return TokenReader.State.UNKNOWN;
    }

    @Override
    public String getPath() {
        int size = this.pathSize;
        if (size == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer(32 * size);
        for (int i = 0; i < size; ++i) {
            String objectId;
            if (buffer.length() > 0) {
                buffer.append('/');
            }
            PathItem pathItem = (PathItem)this.path.get(i);
            buffer.append(pathItem.getElementName());
            String classId = pathItem.getClassId();
            String string = objectId = classId == null ? null : pathItem.getObjectId();
            if (objectId == null) continue;
            buffer.append('[');
            buffer.append(classId);
            buffer.append(',');
            buffer.append(objectId);
            buffer.append(']');
        }
        return buffer.toString();
    }

    private void pushToken(PathItem toke) {
        PathItem pathToken;
        if (this.pathSize == this.path.size()) {
            pathToken = new PathItem();
            this.path.add(pathToken);
        } else {
            pathToken = (PathItem)this.path.get(this.pathSize);
        }
        ++this.pathSize;
        pathToken.setClassId(toke.getClassId());
        pathToken.setObjectId(toke.getObjectId());
        pathToken.setElementName(toke.getElementName());
    }

    private void popToken() {
        if (this.pathSize == 0) {
            throw new IndexOutOfBoundsException();
        }
        --this.pathSize;
    }

    private void trace() {
        TokenReader.State currentState = this.currentState();
        String type = currentState.toString();
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("token=").append(type);
        if (currentState == TokenReader.State.START_TOKEN || currentState == TokenReader.State.END_TOKEN) {
            buffer.append(" name=").append(this.getLocalName());
        }
        buffer.append(" depth=").append(this.depth());
        if (currentState == TokenReader.State.START_TOKEN) {
            buffer.append(" prefix=").append(this.sR.getPrefix());
            buffer.append(" ns=").append(this.sR.getNamespaceURI());
        }
        int aCount = 0;
        if (currentState == TokenReader.State.START_TOKEN) {
            aCount = this.sR.getAttributeCount();
            buffer.append(" attributeCount=" + aCount);
        }
        logger.traceDetail(buffer);
        for (int ii = 0; ii < aCount; ++ii) {
            String aLocalName = this.sR.getAttributeLocalName(ii);
            String aNamespace = this.sR.getAttributeNamespace(ii);
            String aValue = this.sR.getAttributeValue(ii);
            String aPre = this.sR.getAttributePrefix(ii);
            logger.traceDetail("  attribute name=" + aLocalName + " value=" + aValue + " prefix=" + aPre + " ns=" + aNamespace);
        }
    }

    private void cloneCurrentToken() {
        if (this.tW == null) {
            return;
        }
        TokenReader.State ts = this.currentState();
        if (ts == TokenReader.State.START_TOKEN) {
            String srPre = this.sR.getPrefix();
            String srNS = this.getNamespace();
            TokenReaderNst.twiddleWriterNamespacePrefix(this.tW, srPre, srNS);
            this.tW.enter(srNS, this.getLocalName());
            int aCount = this.sR.getAttributeCount();
            for (int ii = 0; ii < aCount; ++ii) {
                String aLocalName = this.sR.getAttributeLocalName(ii);
                String aNamespace = this.sR.getAttributeNamespace(ii);
                String aValue = this.sR.getAttributeValue(ii);
                String aPre = this.sR.getAttributePrefix(ii);
                TokenReaderNst.twiddleWriterNamespacePrefix(this.tW, aPre, aNamespace);
                this.tW.writeAttribute(aNamespace, aLocalName, aValue);
            }
        } else if (ts == TokenReader.State.END_TOKEN) {
            this.tW.leave();
        } else if (ts == TokenReader.State.CONTENT) {
            this.tW.writeContent(this.readContent());
        }
    }

    private static void twiddleWriterNamespacePrefix(TokenWriterNst t, String srPre, String srNS) {
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("twiddle prefix=" + srPre + ", namespace=" + srNS);
        }
        if (srPre == null || srPre.length() == 0) {
            return;
        }
        if (srNS == null || srNS.length() == 0) {
            return;
        }
        String p = t.getPrefixForNamespace(srNS);
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("twiddle p=" + p + " (" + srPre.equals(p) + ")");
        }
        if (srPre.equals(p)) {
            return;
        }
        t.setPrefixForNamespace(srPre, srNS);
    }

    @Override
    public boolean canClone() {
        return true;
    }

    @Override
    public void startCloning(OutputStream cloneToStream) {
        if (this.tW != null) {
            throw new IllegalStateException(this.getClass().getName() + " already cloning input.");
        }
        this.cloneToStream = cloneToStream;
        this.tW = new TokenWriterNst(this.session, cloneToStream, "clone:" + this.getLocalName());
        String namespace = this.sR.getNamespaceURI("");
        if (namespace != null && namespace.length() > 0) {
            this.tW.setPrefixForNamespace(null, namespace);
        }
        this.cloneCurrentToken();
    }

    @Override
    public void stopCloning() {
        if (this.tW == null) {
            throw new IllegalStateException(this.getClass().getName() + " not cloning input.");
        }
        this.tW.endDocument();
        this.tW.flush();
        this.tW.close();
        if (this.cloneToStream instanceof ByteArrayOutputStream && logger.isDetailTraceEnabled()) {
            ByteArrayOutputStream baos = (ByteArrayOutputStream)this.cloneToStream;
            logger.traceDetail("clone: " + baos.toString());
        }
        this.tW = null;
    }

    static {
        try {
            Class<XMLInputFactory> clazz = XMLInputFactory.class;
        }
        catch (NoClassDefFoundError e) {
            throw new EngineRuntimeException(e, ExceptionCode.TRANSPORT_WSI_DESERIALIZATION_ERROR, new String[]{"<init>", "<init>"}, ExceptionContext.TRANSPORT_WSI_NO_STAX_PARSER, null);
        }
        sIF = null;
        STAX_DTD_FIX_WORKED = false;
    }

    private static class PathItem {
        private String elementName;
        private String classId;
        private String objectId;

        public PathItem() {
        }

        public PathItem(String elementName, String classId, String objectId) {
            this.elementName = elementName;
            this.classId = classId;
            this.objectId = objectId;
        }

        private String getElementName() {
            return this.elementName;
        }

        private String getClassId() {
            return this.classId;
        }

        private String getObjectId() {
            return this.objectId;
        }

        private void setElementName(String elementName) {
            this.elementName = elementName;
        }

        private void setClassId(String classId) {
            this.classId = classId;
        }

        private void setObjectId(String objectId) {
            this.objectId = objectId;
        }
    }
}

