/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi.serialization;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.exception.ExceptionContext;
import com.filenet.apiimpl.wsi.ServiceSessionNst;
import com.filenet.apiimpl.wsi.serialization.SerializerContext;
import com.filenet.apiimpl.wsi.serialization.TokenWriter;
import com.filenet.apiimpl.wsi.serialization.Util;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class TokenWriterNst
implements TokenWriter {
    private static XMLOutputFactory sOF = null;
    private final XMLStreamWriter sW;
    private final String operationName;
    private final ServiceSessionNst session;
    private List namespacesToWrite = new ArrayList();
    private boolean justDidContent = false;
    private static String aNL = "\n";
    private static String aSP = " ";
    private SerializerContext sCtx = null;

    private static void initFactory(ServiceSessionNst session) {
        try {
            sOF = XMLOutputFactory.newFactory();
        }
        catch (Throwable t) {
            throw Util.ereOrIoe_common(t, ExceptionCode.TRANSPORT_WSI_SERIALIZATION_ERROR, new String[]{"<init>"}, ExceptionContext.TRANSPORT_WSI_NO_STAX_PARSER, null, ExceptionContext.E_DURATION_WAS_MS, session.durationWas());
        }
        try {
            sOF.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.TRUE);
        }
        catch (IllegalArgumentException e) {
            String sifClassName = sOF.getClass().getName();
            throw new EngineRuntimeException(e, ExceptionCode.TRANSPORT_WSI_SERIALIZATION_ERROR, new String[]{"<init>"}, ExceptionContext.TRANSPORT_WSI_STAX_MUST_REPAIR_NAMESPACES, new Object[]{sifClassName}, ExceptionContext.E_DURATION_WAS_MS, session.durationWas());
        }
    }

    public TokenWriterNst(ServiceSessionNst ssn, OutputStream os, String opName) {
        this.session = ssn;
        this.operationName = opName;
        if (sOF == null) {
            TokenWriterNst.initFactory(this.session);
        }
        try {
            this.sW = sOF.createXMLStreamWriter(os, "UTF-8");
        }
        catch (EngineRuntimeException ere) {
            throw ere;
        }
        catch (Throwable t) {
            throw Util.ereOrIoe_common(t, ExceptionCode.TRANSPORT_WSI_SERIALIZATION_ERROR, new String[]{this.operationName}, ExceptionContext.TRANSPORT_WSI_COMPOSING_XML, null, ExceptionContext.E_DURATION_WAS_MS, this.session.durationWas());
        }
    }

    @Override
    public void flush() {
        try {
            this.sW.flush();
        }
        catch (Throwable t) {
            throw Util.ereOrIoeS(t, new String[]{this.operationName}, ExceptionContext.TRANSPORT_WSI_COMPOSING_XML, null, ExceptionContext.E_DURATION_WAS_MS, this.session.durationWas());
        }
    }

    public void close() {
        try {
            this.sW.close();
        }
        catch (Throwable t) {
            throw Util.ereOrIoeS(t, new String[]{this.operationName}, ExceptionContext.TRANSPORT_WSI_COMPOSING_XML, null, ExceptionContext.E_DURATION_WAS_MS, this.session.durationWas());
        }
    }

    @Override
    public String getPrefixForNamespace(String namespace) {
        try {
            return this.sW.getPrefix(namespace);
        }
        catch (Throwable t) {
            throw Util.ereOrIoeS(t, new String[]{this.operationName}, ExceptionContext.TRANSPORT_WSI_COMPOSING_XML, null, ExceptionContext.E_DURATION_WAS_MS, this.session.durationWas());
        }
    }

    @Override
    public void setPrefixForNamespace(String prefix, String namespace) {
        if (namespace == null || namespace.length() == 0) {
            return;
        }
        try {
            if (prefix == null || prefix.length() == 0) {
                this.sW.setDefaultNamespace(namespace);
                this.namespacesToWrite.add(new String[]{null, namespace});
            } else {
                this.sW.setPrefix(prefix, namespace);
                this.namespacesToWrite.add(new String[]{prefix, namespace});
            }
        }
        catch (Throwable t) {
            throw Util.ereOrIoeS(t, new String[]{this.operationName}, ExceptionContext.TRANSPORT_WSI_COMPOSING_XML, null, ExceptionContext.E_DURATION_WAS_MS, this.session.durationWas());
        }
    }

    @Override
    public void enter(String namespace, String eltName) {
        try {
            this.newLineIndent(0);
            if (namespace == null) {
                this.sW.writeStartElement(eltName);
            } else {
                this.sW.writeStartElement(namespace, eltName);
            }
            this.flushNamespaces();
        }
        catch (Throwable t) {
            throw Util.ereOrIoeS(t, new String[]{this.operationName}, ExceptionContext.TRANSPORT_WSI_COMPOSING_XML, null, ExceptionContext.E_DURATION_WAS_MS, this.session.durationWas());
        }
        this.justDidContent = false;
    }

    private void flushNamespaces() throws XMLStreamException {
        if (this.namespacesToWrite.size() > 0) {
            for (String[] pnPair : this.namespacesToWrite) {
                String prefix = pnPair[0];
                String namespace = pnPair[1];
                if (prefix == null || prefix.length() == 0) {
                    this.sW.writeDefaultNamespace(namespace);
                    continue;
                }
                this.sW.writeNamespace(prefix, namespace);
            }
            this.namespacesToWrite.clear();
        }
    }

    @Override
    public void leave() {
        try {
            if (!this.justDidContent) {
                this.newLineIndent(-1);
            }
            this.sW.writeEndElement();
        }
        catch (Throwable t) {
            throw Util.ereOrIoeS(t, new String[]{this.operationName}, ExceptionContext.TRANSPORT_WSI_COMPOSING_XML, null, ExceptionContext.E_DURATION_WAS_MS, this.session.durationWas());
        }
        this.justDidContent = false;
    }

    @Override
    public String registerAttachment(int attachmentMode, InputStream stream) {
        return this.session.registerAttachment(attachmentMode, stream);
    }

    @Override
    public void writeAttribute(String namespace, String attrName, String attrValue) {
        try {
            if (namespace == null) {
                this.sW.writeAttribute(attrName, attrValue);
            } else {
                this.sW.writeAttribute(namespace, attrName, attrValue);
            }
        }
        catch (Throwable t) {
            throw Util.ereOrIoeS(t, new String[]{this.operationName}, ExceptionContext.TRANSPORT_WSI_COMPOSING_XML, null, ExceptionContext.E_DURATION_WAS_MS, this.session.durationWas());
        }
    }

    @Override
    public void writeContent(String contentValue) {
        try {
            this.sW.writeCharacters(contentValue);
        }
        catch (Throwable t) {
            throw Util.ereOrIoeS(t, new String[]{this.operationName}, ExceptionContext.TRANSPORT_WSI_COMPOSING_XML, null, ExceptionContext.E_DURATION_WAS_MS, this.session.durationWas());
        }
        this.justDidContent = true;
    }

    private void newLineIndent(int adjust) throws XMLStreamException {
        if (this.sCtx != null && this.sCtx.isForTrace()) {
            this.sW.writeCharacters(aNL);
            int indentSize = (this.sCtx.getDepth() + adjust) * 2;
            for (int ii = 0; ii < indentSize; ++ii) {
                this.sW.writeCharacters(aSP);
            }
        }
    }

    public void setSerializerContext(SerializerContext sCtx) {
        this.sCtx = sCtx;
    }

    public void startDocument() {
        try {
            this.sW.writeStartDocument();
        }
        catch (Throwable t) {
            throw Util.ereOrIoeS(t, new String[]{this.operationName}, ExceptionContext.TRANSPORT_WSI_COMPOSING_XML, null, ExceptionContext.E_DURATION_WAS_MS, this.session.durationWas());
        }
    }

    public void endDocument() {
        try {
            this.sW.writeEndDocument();
        }
        catch (Throwable t) {
            throw Util.ereOrIoeS(t, new String[]{this.operationName}, ExceptionContext.TRANSPORT_WSI_COMPOSING_XML, null, ExceptionContext.E_DURATION_WAS_MS, this.session.durationWas());
        }
    }
}

