/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi.serialization.comm;

import com.filenet.api.util.Id;
import com.filenet.apiimpl.transport.comm.CommRequest;
import com.filenet.apiimpl.wsi.serialization.DeserializerContext;
import com.filenet.apiimpl.wsi.serialization.Serialization;
import com.filenet.apiimpl.wsi.serialization.SerializerContext;
import com.filenet.apiimpl.wsi.serialization.Util;

public class CommSerialization
extends Serialization {
    public static final CommSerialization INSTANCE = new CommSerialization();

    @Override
    public void serialize(Object object, SerializerContext context) throws Exception {
        CommRequest request = (CommRequest)object;
        context.writeAttribute("id", request.getCorrelationId());
        context.writeAttribute("objectStore", Util.toIdString(request.getObjectStoreId()));
    }

    @Override
    public Object deserialize(Object object, DeserializerContext context) throws Exception {
        CommRequest request = (CommRequest)object;
        String correlationId = context.getAttribute("id");
        request.setCorrelationId(correlationId);
        Id objectStoreId = Util.parseId(context.getAttribute("objectStore"));
        request.setObjectStoreId(objectStoreId);
        return null;
    }
}

