/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi.serialization.operation;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.util.Id;
import com.filenet.apiimpl.transport.comm.CommBatchResponse;
import com.filenet.apiimpl.transport.comm.CommResponse;
import com.filenet.apiimpl.transport.comm.StorageDeviceContentOpResponse;
import com.filenet.apiimpl.wsi.serialization.DeserializerContext;
import com.filenet.apiimpl.wsi.serialization.Serialization;
import com.filenet.apiimpl.wsi.serialization.SerializerContext;
import com.filenet.apiimpl.wsi.serialization.Util;
import com.filenet.apiimpl.wsi.serialization.comm.CommResponseSerialization;
import com.filenet.apiimpl.wsi.serialization.comm.StorageDeviceContentOpResponseSerialization;
import com.filenet.apiimpl.wsi.serialization.core.ExceptionSerialization;
import java.util.ArrayList;

public class CommBatchResponseSerialization
extends Serialization {
    public static final CommBatchResponseSerialization INSTANCE = new CommBatchResponseSerialization();

    @Override
    public void serialize(Object object, SerializerContext context) throws Exception {
        CommBatchResponse batchResponse = (CommBatchResponse)object;
        context.writeAttribute("destServerId", Util.toIdString(batchResponse.getDestServerId()));
        context.writeAttribute("destServerElapsedTime", Util.toUnsignedLongString(batchResponse.getDestServerElapsedTime()));
        context.writeAttribute("destServerEndTime", Util.toUnsignedLongString(batchResponse.getDestServerEndTime()));
        CommResponse[] batch = batchResponse.getCommBatchResponse();
        if (batch != null) {
            context.writeSchemaType("CommResponseType");
            for (int i = 0; i < batch.length; ++i) {
                CommResponse response = batch[i];
                if (response instanceof StorageDeviceContentOpResponse) {
                    context.enterElement("CommResponse", "StorageDeviceResponseType");
                    context.serializeObject("StorageDeviceContentOpResponse", response.getClass(), (Object)response);
                    context.leaveElement();
                } else if (response instanceof CommResponse) {
                    context.serializeObject("CommResponse", response.getClass(), (Object)response);
                }
                context.leaveElement();
            }
        } else if (batchResponse.getException() != null) {
            EngineRuntimeException ert = batchResponse.getException();
            context.writeSchemaType("CommErrorResponseType");
            context.serializeObject("ErrorStack", ExceptionSerialization.INSTANCE, (Object)ert);
        }
        context.leaveElement();
    }

    @Override
    public Object deserialize(Object object, DeserializerContext context) throws Exception {
        CommBatchResponse batchResponse = new CommBatchResponse();
        Id destServerId = Util.parseId(context.getAttribute("destServerId"));
        batchResponse.setDestServerId(destServerId);
        Long destServerElapsedTime = Util.parseLong(context.getAttribute("destServerElapsedTime"));
        batchResponse.setDestServerElapsedTime(destServerElapsedTime);
        Long destServerEndTime = Util.parseLong(context.getAttribute("destServerEndTime"));
        batchResponse.setDestServerEndTime(destServerEndTime);
        String batchResponseType = context.getXsiType();
        if (batchResponseType.equals("CommErrorResponseType")) {
            context.nextElementToken();
            EngineRuntimeException ert = (EngineRuntimeException)context.deserializeObject("ErrorStack", ExceptionSerialization.INSTANCE, null);
            batchResponse.setException(ert);
        } else {
            ArrayList<CommResponse> responses = new ArrayList<CommResponse>();
            while (Util.isStartToken(context.nextElementToken())) {
                CommResponse response = null;
                String type = context.getXsiType();
                if (type.equals("CommErrorResponseType")) {
                    String correlationId = context.getAttribute("id");
                    response = new CommResponse();
                    response.setCorrelationId(correlationId);
                    context.nextElementToken();
                    Object value = context.deserializeObject("ErrorStack", ExceptionSerialization.INSTANCE, null);
                    response.putValue(value);
                } else if (type.equals("StorageDeviceResponseType")) {
                    context.nextElementToken();
                    response = new StorageDeviceContentOpResponse();
                    context.deserializeObject(StorageDeviceContentOpResponseSerialization.INSTANCE, (Object)response);
                } else if (type.equals("CommResponseType")) {
                    response = new CommResponse();
                    context.deserializeObject(CommResponseSerialization.INSTANCE, (Object)response);
                    context.nextElementToken();
                } else {
                    context.throwException(ExceptionCode.TRANSPORT_WSI_INVALID_CONTENT_RESPONSE_TYPE, type);
                }
                responses.add(response);
                context.checkEndToken();
            }
            CommResponse[] batch = responses.toArray(new CommResponse[responses.size()]);
            batchResponse.setCommBatchResponse(batch);
        }
        context.checkEndToken();
        return batchResponse;
    }
}

