/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi.serialization.operation;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.apiimpl.collection.AbstractEngineSet;
import com.filenet.apiimpl.collection.RepositoryRowCollectionImpl;
import com.filenet.apiimpl.constants.SearchMode;
import com.filenet.apiimpl.core.SubSetImpl;
import com.filenet.apiimpl.transport.SearchRequest;
import com.filenet.apiimpl.transport.SearchResponse;
import com.filenet.apiimpl.wsi.serialization.DeserializerContext;
import com.filenet.apiimpl.wsi.serialization.Serialization;
import com.filenet.apiimpl.wsi.serialization.SerializerContext;
import com.filenet.apiimpl.wsi.serialization.Util;
import com.filenet.apiimpl.wsi.serialization.core.CollectionTerminatorSerialization;
import com.filenet.apiimpl.wsi.serialization.core.EngineObjectSerialization;
import com.filenet.apiimpl.wsi.serialization.core.RepositoryRowSerialization;
import com.filenet.apiimpl.wsi.serialization.property.PropertyDeserializerCall;
import java.util.List;

public class ExecuteSearchResponseSerialization
extends Serialization {
    public static final ExecuteSearchResponseSerialization INSTANCE = new ExecuteSearchResponseSerialization();

    @Override
    public void serialize(Object object, SerializerContext context) throws Exception {
        SearchResponse response = (SearchResponse)object;
        AbstractEngineSet set = response.getEngineSet();
        String continuation = Util.nullAsEmpty(Util.continuation(set));
        if (set instanceof RepositoryRowCollectionImpl) {
            context.serializeObjectArray("Object", RepositoryRowSerialization.INSTANCE, Util.objects(set));
        } else {
            context.serializeObjectArray("Object", EngineObjectSerialization.INSTANCE, Util.objects(set));
        }
        if (set.getTraversalError() == null) {
            context.serializeObject("CollectionTerminator", CollectionTerminatorSerialization.INSTANCE, (Object)continuation);
        } else {
            context.serializeObject("CollectionTerminator", CollectionTerminatorSerialization.INSTANCE, (Object)set.getTraversalError());
        }
        context.leaveElement();
    }

    @Override
    public Object deserialize(Object object, DeserializerContext context) throws Exception {
        SearchRequest request = (SearchRequest)context.getRequest();
        SearchResponse response = new SearchResponse();
        context.nextElementToken();
        PropertyDeserializerCall call = new PropertyDeserializerCall(request.getSearchScope(), request.getSearch().getPropertyFilter());
        if (request.getSearchMode() == SearchMode.ROWS) {
            List list = context.deserializeObjectList("Object", RepositoryRowSerialization.INSTANCE, call);
            Object collectionTerm = context.deserializeObject("CollectionTerminator", CollectionTerminatorSerialization.INSTANCE, null);
            String continuation = null;
            EngineRuntimeException traversalError = null;
            if (collectionTerm instanceof String) {
                continuation = (String)collectionTerm;
            } else if (collectionTerm instanceof EngineRuntimeException) {
                traversalError = (EngineRuntimeException)collectionTerm;
            }
            RepositoryRowCollectionImpl rrc = new RepositoryRowCollectionImpl(context.getConnection());
            rrc.setList(list);
            rrc.setTraversalError(traversalError);
            if (continuation != null) {
                rrc.getPaging().setContinuation(continuation);
            }
            response.setRepositoryRowSet(rrc);
        } else {
            List list = context.deserializeObjectList("Object", EngineObjectSerialization.INSTANCE, call);
            Object collectionTerm = context.deserializeObject("CollectionTerminator", CollectionTerminatorSerialization.INSTANCE, null);
            String continuation = null;
            EngineRuntimeException traversalError = null;
            if (collectionTerm instanceof String) {
                continuation = (String)collectionTerm;
            } else if (collectionTerm instanceof EngineRuntimeException) {
                traversalError = (EngineRuntimeException)collectionTerm;
            }
            SubSetImpl set = Util.createIndependentObjectSet(context.getConnection(), list, continuation, null, null, request.getSearch().getPropertyFilter(), request.getMaxElements());
            set.setTraversalError(traversalError);
            response.setIndependentObjectSet(set);
        }
        context.checkEndToken();
        return response;
    }
}

