/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi.serialization.property;

import com.filenet.api.core.Connection;
import com.filenet.api.util.Id;
import com.filenet.apiimpl.collection.IdListImpl;
import com.filenet.apiimpl.property.PropertyIdListImpl;
import com.filenet.apiimpl.util.json.JSONArray;
import com.filenet.apiimpl.util.json.JSONObject;
import com.filenet.apiimpl.wsi.serialization.DeserializerContext;
import com.filenet.apiimpl.wsi.serialization.SerializerContext;
import com.filenet.apiimpl.wsi.serialization.Util;
import com.filenet.apiimpl.wsi.serialization.property.PropertyDeserializerCall;
import com.filenet.apiimpl.wsi.serialization.property.PropertySerialization;
import java.util.ArrayList;

public class IdListSerialization
extends PropertySerialization {
    public static final IdListSerialization INSTANCE = new IdListSerialization();

    @Override
    public void serialize(Object object, SerializerContext context) throws Exception {
        this.serializeList("ListOfId", context.getOptionalSchemaType("GuidType"), object, context);
    }

    @Override
    protected String toString(Object value) {
        return Util.toIdString((Id)value);
    }

    @Override
    public Object deserialize(Object object, DeserializerContext context) throws Exception {
        PropertyDeserializerCall call = this.enter(object, context);
        PropertyIdListImpl property = new PropertyIdListImpl(call.propertyId, new IdListImpl(this.readList(context)), call.propertyAccess);
        return this.leave(property, call, context);
    }

    @Override
    public Object deserializeJson(Connection connection, JSONObject json, String name, boolean hasDeltas, PropertyDeserializerCall call) {
        this.prepare(call, name, json, hasDeltas);
        ArrayList<Id> values = new ArrayList<Id>();
        JSONArray jsonVals = (JSONArray)json.get("value");
        if (jsonVals != null) {
            for (int i = 0; i < jsonVals.size(); ++i) {
                values.add(Util.parseId(jsonVals.getString(i)));
            }
        }
        PropertyIdListImpl property = new PropertyIdListImpl(call.propertyId, new IdListImpl(values), call.propertyAccess);
        return this.respond(property, call);
    }

    @Override
    protected Object parseValue(String text) {
        return Util.parseId(text);
    }
}

