/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi.serialization.property;

import com.filenet.api.core.ObjectReference;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.core.ObjectReferenceBase;
import com.filenet.apiimpl.property.UnevaluatedPropertyValue;
import com.filenet.apiimpl.wsi.serialization.DeserializerContext;
import com.filenet.apiimpl.wsi.serialization.Serialization;
import com.filenet.apiimpl.wsi.serialization.SerializerContext;
import com.filenet.apiimpl.wsi.serialization.Util;
import com.filenet.apiimpl.wsi.serialization.property.PropertyDeserializerCall;
import com.filenet.apiimpl.wsi.serialization.property.PropertySerializerCall;
import com.filenet.apiimpl.wsi.serialization.reference.ObjectReferenceSerialization;

public class UnevaluatedValueSerialization
extends Serialization {
    public static final UnevaluatedValueSerialization INSTANCE = new UnevaluatedValueSerialization();

    @Override
    public void serialize(Object object, SerializerContext context) throws Exception {
        PropertySerializerCall call = (PropertySerializerCall)object;
        context.writeSchemaType("Unevaluated");
        if (context.getVersion() > 300 && call.parent == null) {
            ObjectReference propertyReference = call.property.getObjectReference();
            ObjectReference parentReference = ((UnevaluatedPropertyValue)propertyReference).getParentReference();
            context.serializeObject("ParentReference", parentReference.getClass(), (Object)parentReference);
        }
        context.leaveElement();
    }

    @Override
    public Object deserialize(Object object, DeserializerContext context) throws Exception {
        PropertyDeserializerCall call = (PropertyDeserializerCall)object;
        ObjectReferenceBase parent = null;
        if (Util.isStartToken(context.nextElementToken())) {
            parent = (ObjectReferenceBase)context.deserializeObject(ObjectReferenceSerialization.INSTANCE, null);
        }
        if (parent == null) {
            if (call.parent != null) {
                parent = (ObjectReferenceBase)call.parent.getObjectReference();
            }
            if (parent == null) {
                throw new EngineRuntimeException(ExceptionCode.TRANSPORT_WSI_VALUE_EXPECTED, "ParentReference");
            }
        }
        context.checkEndToken();
        return new UnevaluatedPropertyValue(parent, call.propertyId);
    }
}

