/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.repository.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DataBufferOutputStream
extends OutputStream {
    public static final int DefaultCapacity = 0x500000;
    public static final String DefaultPrefix = "PQRY";
    public static final String DefaultSuffix = "Buffer.dat";
    private File tempFile = null;
    private byte[] bytes;
    private OutputStream outputStream;
    private String dataFilePrefix;
    private String dataFileSuffix;
    private File dataFileDirectory = null;
    private int capacity;
    private int counter;
    private boolean outputClosed;

    public DataBufferOutputStream() {
        this(0x500000, DefaultPrefix, DefaultSuffix, null);
    }

    public DataBufferOutputStream(int n2, String string, String string2, File file) {
        this.capacity = n2;
        this.dataFilePrefix = string;
        this.dataFileSuffix = string2;
        if (file != null) {
            this.dataFileDirectory = file;
        } else {
            String string3 = System.getProperty("java.io.tmpdir");
            this.dataFileDirectory = new File(string3);
        }
        this.counter = 0;
        this.outputStream = new ByteArrayOutputStream(n2);
        this.outputClosed = false;
    }

    @Override
    public void write(int n2) throws IOException {
        this.ensureCapacity(1);
        this.outputStream.write((byte)n2);
    }

    public boolean isOutputClosed() {
        return this.outputClosed;
    }

    @Override
    public void close() throws IOException {
        if (this.isCachingInMemory()) {
            this.bytes = ((ByteArrayOutputStream)this.outputStream).toByteArray();
        }
        this.outputStream.close();
        this.outputClosed = true;
    }

    @Override
    public void flush() throws IOException {
        this.outputStream.flush();
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.ensureCapacity(byArray.length);
        this.outputStream.write(byArray);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        this.ensureCapacity(n3);
        this.outputStream.write(byArray, n2, n3);
    }

    public InputStream getInputStream() {
        if (this.bytes == null && this.tempFile == null) {
            throw new RuntimeException("Databuffer cache removed");
        }
        if (!this.outputClosed) {
            throw new RuntimeException("Databuffer cache not ready");
        }
        if (this.isCachingInMemory()) {
            return new ByteArrayInputStream(this.bytes){

                @Override
                public void close() throws IOException {
                    super.close();
                    DataBufferOutputStream.this.dispose();
                }
            };
        }
        try {
            return new FileInputStream(this.tempFile){

                @Override
                public void close() throws IOException {
                    super.close();
                    DataBufferOutputStream.this.dispose();
                }
            };
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException("Databuffer cache not ready", fileNotFoundException);
        }
    }

    public long getLength() {
        long l10 = -1L;
        if (this.isCachingInMemory()) {
            l10 = this.counter;
        } else if (this.tempFile != null) {
            l10 = this.tempFile.length();
        }
        return l10;
    }

    public void dispose() {
        if (this.tempFile != null) {
            this.tempFile.delete();
            this.tempFile = null;
        } else {
            this.bytes = null;
        }
    }

    public String getDataFileName() {
        String string = null;
        if (this.tempFile != null) {
            string = this.tempFile.getAbsolutePath();
        }
        return string;
    }

    private void ensureCapacity(int n2) throws IOException {
        if (this.isCachingInMemory()) {
            if (this.counter + n2 > this.capacity) {
                this.tempFile = File.createTempFile(this.dataFilePrefix, this.dataFileSuffix, this.dataFileDirectory);
                this.tempFile.deleteOnExit();
                byte[] byArray = ((ByteArrayOutputStream)this.outputStream).toByteArray();
                this.outputStream = new FileOutputStream(this.tempFile);
                this.outputStream.write(byArray);
                this.counter = -1;
            } else {
                this.counter += n2;
            }
        }
    }

    public boolean isCachingInMemory() {
        return this.counter >= 0;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.dispose();
    }
}

