--
-- Licensed Materials - Property of IBM
-- 5737-I23
-- Copyright IBM Corp. 2018 - 2022. All Rights Reserved.
-- U.S. Government Users Restricted Rights:
-- Use, duplication or disclosure restricted by GSA ADP Schedule
-- Contract with IBM Corp.
--

alter table error_log alter column id restart with 0;
alter table processed_file alter column id restart with 0;
alter table smartpages_options alter column id restart with 0;

load from doc_class.del of ixf lobs from ./ modified by identityignore replace into doc_class;
load from doc_alias.del of ixf lobs from ./ modified by identityignore replace into doc_alias;
load from object_type.del of ixf lobs from ./ modified by identityignore replace into object_type;
load from key_class.del of ixf lobs from ./ modified by identityignore replace into key_class;
load from key_alias.del of ixf lobs from ./ modified by identityignore replace into key_alias;
load from value_metrics.del of ixf lobs from ./ modified by identityignore replace into value_metrics;
load from attribute_alias.del of ixf lobs from ./ modified by identityignore replace into attribute_alias;
load from cword.del of ixf lobs from ./ modified by identityignore replace into cword;
load from heading.del of ixf lobs from ./ modified by identityignore replace into heading;
load from heading_alias.del of ixf lobs from ./ modified by identityignore replace into heading_alias;
load from user_detail.del of ixf lobs from ./ modified by identityignore replace into user_detail;
load from login_detail.del of ixf lobs from ./ modified by identityignore replace into login_detail;
load from integration.del of ixf lobs from ./ modified by identityignore replace into integration;
load from import_ontology.del of ixf lobs from ./ modified by identityignore replace into import_ontology;
load from api_integrations_objectsstore.del of ixf lobs from ./ modified by identityignore replace into api_integrations_objectsstore;
load from smartpages_options.del of ixf lobs from ./ modified by identityignore replace into smartpages_options;
load from feature.del of ixf lobs from ./ modified by identityignore replace into feature;
load from training_log.del of ixf lobs from ./ modified by identityignore replace into training_log;
load from templates.del of ixf lobs from ./ modified by identityignore replace into templates;
load from models.del of ixf lobs from ./ modified by identityignore replace into models;
load from published_models.del of ixf lobs from ./ modified by identityignore replace into published_models;
load from processed_file.del of ixf lobs from ./ modified by identityignore replace into processed_file;
load from error_log.del of ixf lobs from ./ modified by identityignore replace into error_log;
load from audit_ontology.del of ixf lobs from ./ modified by identityignore replace into audit_ontology;
load from audit_login_activity.del of ixf lobs from ./ modified by identityignore replace into audit_login_activity;
load from audit_processed_files.del of ixf lobs from ./ modified by identityignore replace into audit_processed_files;
load from audit_user_activity.del of ixf lobs from ./ modified by identityignore replace into audit_user_activity;
load from audit_api_activity.del of ixf lobs from ./ modified by identityignore replace into audit_api_activity;
load from audit_system_activity.del of ixf lobs from ./ modified by identityignore replace into audit_system_activity;
load from audit_integration_activity.del of ixf lobs from ./ modified by identityignore replace into audit_integration_activity;
load from implementation.del of ixf lobs from ./ modified by identityignore replace into implementation;
load from implementation_kc.del of ixf lobs from ./ modified by identityignore replace into implementation_kc;
load from systemt_models.del of ixf lobs from ./ modified by identityignore replace into systemt_models;
load from systemt_model_metadata.del of ixf lobs from ./ modified by identityignore replace into systemt_model_metadata;
load from runtime_doc.del of ixf lobs from ./ modified by identityignore replace into runtime_doc;
load from kvp_model_detail.del of ixf lobs from ./ modified by identityignore replace into kvp_model_detail;
load from runtime_page.del of ixf lobs from ./ modified by identityignore replace into runtime_page;
load from models_testing_doc.del of ixf lobs from ./ modified by identityignore replace into models_testing_doc;
load from feedback.del of ixf lobs from ./ modified by identityignore replace into feedback;
load from system_options.del of ixf lobs from ./ modified by identityignore replace into system_options;
load from webhook.del of ixf lobs from ./ modified by identityignore replace into webhook;

set integrity for doc_class immediate checked;
set integrity for doc_alias immediate checked;
set integrity for object_type immediate checked;
set integrity for key_class immediate checked;
set integrity for key_alias immediate checked;
set integrity for attribute_alias immediate checked;
set integrity for cword immediate checked;
set integrity for heading immediate checked;
set integrity for heading_alias immediate checked;
set integrity for user_detail immediate checked;
set integrity for login_detail immediate checked;
set integrity for integration immediate checked;
set integrity for import_ontology immediate checked;
set integrity for api_integrations_objectsstore immediate checked;
set integrity for smartpages_options immediate checked;
set integrity for fonts immediate checked;
set integrity for fonts_transid immediate checked;
set integrity for key_spacing immediate checked;
set integrity for feature immediate checked;
set integrity for training_log immediate checked;
set integrity for templates immediate checked;
set integrity for models immediate checked;
set integrity for value_metrics immediate checked;
set integrity for published_models immediate checked;
set integrity for processed_file immediate checked;
set integrity for error_log immediate checked;
set integrity for audit_ontology immediate checked;
set integrity for audit_login_activity immediate checked;
set integrity for audit_processed_files immediate checked;
set integrity for audit_user_activity immediate checked;
set integrity for audit_api_activity immediate checked;
set integrity for audit_system_activity immediate checked;
set integrity for audit_integration_activity immediate checked;
set integrity for implementation immediate checked;
set integrity for implementation_kc immediate checked;
set integrity for systemt_models immediate checked;
set integrity for systemt_model_metadata immediate checked;
set integrity for runtime_doc immediate checked;
set integrity for kvp_model_detail immediate checked;
set integrity for runtime_page immediate checked;
set integrity for feedback immediate checked;
set integrity for models_testing_doc immediate checked;
set integrity for system_options immediate checked;
set integrity for webhook immediate checked;

reorg table doc_class;
reorg table doc_alias;
reorg table object_type;
reorg table key_class;
reorg table key_alias;
reorg table value_metrics;
reorg table attribute_alias;
reorg table cword;
reorg table heading;
reorg table heading_alias;
reorg table user_detail;
reorg table login_detail;
reorg table integration;
reorg table import_ontology;
reorg table api_integrations_objectsstore;
reorg table smartpages_options;
reorg table fonts;
reorg table fonts_transid;
reorg table key_spacing;
reorg table feature;
reorg table training_log;
reorg table templates;
reorg table models;
reorg table published_models;
reorg table processed_file;
reorg table error_log;
reorg table audit_ontology;
reorg table audit_login_activity;
reorg table audit_processed_files;
reorg table audit_user_activity;
reorg table audit_api_activity;
reorg table audit_system_activity;
reorg table audit_integration_activity;
reorg table implementation;
reorg table implementation_kc;
reorg table systemt_models;
reorg table systemt_model_metadata;
reorg table runtime_doc;
reorg table kvp_model_detail;
reorg table runtime_page;
reorg table feedback;
reorg table models_testing_doc;
reorg table system_options;
reorg table webhook;

runstats on table doc_class and indexes all;
runstats on table doc_alias and indexes all;
runstats on table object_type and indexes all;
runstats on table key_class and indexes all;
runstats on table key_alias and indexes all;
runstats on table value_metrics and indexes all;
runstats on table attribute_alias and indexes all;
runstats on table cword and indexes all;
runstats on table heading and indexes all;
runstats on table heading_alias and indexes all;
runstats on table user_detail and indexes all;
runstats on table login_detail and indexes all;
runstats on table integration and indexes all;
runstats on table import_ontology and indexes all;
runstats on table api_integrations_objectsstore and indexes all;
runstats on table smartpages_options and indexes all;
runstats on table fonts and indexes all;
runstats on table fonts_transid and indexes all;
runstats on table key_spacing and indexes all;
runstats on table feature and indexes all;
runstats on table training_log and indexes all;
runstats on table templates and indexes all;
runstats on table models and indexes all;
runstats on table published_models and indexes all;
runstats on table processed_file and indexes all;
runstats on table error_log and indexes all;
runstats on table audit_ontology and indexes all;
runstats on table audit_login_activity and indexes all;
runstats on table audit_processed_files and indexes all;
runstats on table audit_user_activity and indexes all;
runstats on table audit_api_activity and indexes all;
runstats on table audit_system_activity and indexes all;
runstats on table audit_integration_activity and indexes all;
runstats on table implementation and indexes all;
runstats on table implementation_kc and indexes all;
runstats on table systemt_models and indexes all;
runstats on table systemt_model_metadata and indexes all;
runstats on table runtime_doc and indexes all;
runstats on table kvp_model_detail and indexes all;
runstats on table runtime_page and indexes all;
runstats on table feedback and indexes all;
runstats on table models_testing_doc and indexes all;
runstats on table system_options and indexes all;
runstats on table webhook and indexes all;
