#!/bin/bash
###############################################################################
#
# Licensed Materials - Property of IBM
#
# (C) Copyright IBM Corp. 2021. All Rights Reserved.
#
# US Government Users Restricted Rights - Use, duplication or
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
#
###############################################################################
# CUR_DIR set to full path to scripts folder
CUR_DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"
PARENT_DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )/.." && pwd )"
TEMP_FOLDER=${CUR_DIR}/.tmp
OLM_SUBSCRIPTION=${PARENT_DIR}/descriptors/op-olm/subscription.yaml
OLM_SUBSCRIPTION_TMP=${TEMP_FOLDER}/.subscription.yaml

function select_uninstall_type(){
    local returnValue
    if [[ $RUNTIME_MODE == "baw" || $RUNTIME_MODE == "baw-dev" ]];then
       kubectl get subscription -n $NAMESPACE| grep ibm-baw-operator-catalog-subscription >/dev/null 2>&1
    else
       kubectl get subscription -n $NAMESPACE| grep ibm-cp4a-operator-catalog-subscription >/dev/null 2>&1
    fi
    returnValue=$?
    if [ "$returnValue" == 0 ] ; then
        uninstall_olm_cp4a
    elif [ "$returnValue" == 1 ] ; then
        uninstall_cp4a
    fi
}

function uninstall_cp4a(){
    printf "\n"
    printf "\x1B[1mUninstall CP4A Operator...\n\x1B[0m"
    kubectl delete -f ${CUR_DIR}/../descriptors/operator.yaml -n $NAMESPACE >/dev/null 2>&1
    kubectl delete -f ${CUR_DIR}/../descriptors/role_binding.yaml -n $NAMESPACE >/dev/null 2>&1
    kubectl delete -f ${CUR_DIR}/../descriptors/role.yaml -n $NAMESPACE >/dev/null 2>&1
    kubectl delete -f ${CUR_DIR}/../descriptors/service_account.yaml -n $NAMESPACE >/dev/null 2>&1
    echo "All descriptors have been successfully deleted."
}

function uninstall_olm_cp4a(){
    local csvName
    local subsArr
    printf "\n"
    printf "\x1B[1mUninstall CP4BA Operator Subscription...\n\x1B[0m"
    if [[ $RUNTIME_MODE == "baw" ]];then
      OLM_SUBSCRIPTION=${PARENT_DIR}/descriptors/baw-olm/subscription.yaml
    elif [[ $RUNTIME_MODE == "baw-dev" ]];then
      OLM_SUBSCRIPTION=${PARENT_DIR}/descriptors/baw-olm/devsubscription.yaml
    fi
    ${COPY_CMD} -rf "${OLM_SUBSCRIPTION}" "${OLM_SUBSCRIPTION_TMP}"
    ${SED_COMMAND} '/namespace: /d' ${OLM_SUBSCRIPTION_TMP}
    if [[ $RUNTIME_MODE == "baw" || $RUNTIME_MODE == "baw-dev" ]];then
       # - get csv name
       csvName=$(kubectl get subscription "ibm-baw-operator-catalog-subscription" -n $NAMESPACE -o go-template --template '{{.status.installedCSV}}')
       # - remove the subscription
       kubectl delete -f ${OLM_SUBSCRIPTION_TMP} -n $NAMESPACE >/dev/null 2>&1
       # - remove the CSV which was generated by the subscription but does not get garbage collected
       kubectl delete clusterserviceversion "${csvName}" -n $NAMESPACE >/dev/null 2>&1
    else
       subsArr=$(kubectl get subscriptions.operators.coreos.com -n $NAMESPACE|grep v23.1|awk '{if(NR>0){if(NR==1){ arr=$1; }else{ arr=arr" "$1; }} } END{ print arr }')
       for word in $subsArr
        do
            echo "***********************************"
            echo $word
            # - get csv name
            csvName=$(kubectl get subscription "$word" -n $NAMESPACE -o go-template --template '{{.status.installedCSV}}')
            # - remove the subscription
            echo "removing the subscription for "$word
            kubectl delete subscription $word -n $NAMESPACE >/dev/null 2>&1
            # - remove the CSV
            echo "removing the CSV for "${csvName}
            kubectl delete clusterserviceversion "${csvName}" -n $NAMESPACE >/dev/null 2>&1
       done
    fi
    echo "***************The CP4BA Operator Subscription has been successfully deleted.******************"
}

function show_help {
    echo -e "\nPrerequisite:"
    echo -e "1. Login your cluster;"
    echo -e "2. CR was applied in your project."
    echo -e "Usage for other platform: deleteOperator.sh -n namespace\n"
    echo "Options:"
    echo "  -h  Display help"
    echo "  -n  The namespace to delete Operator"
    echo "  -m  Delete baw Operator, the usage could be '-m baw' "
}

if [[ $1 == "" ]]
then
    show_help
    exit -1
else
    while getopts "h?n:m:" opt; do
        case "$opt" in
        h|\?)
            show_help
            exit 0
            ;;
        n) NAMESPACE=$OPTARG
            ;;
        m) RUNTIME_MODE=$OPTARG
           if [[ $RUNTIME_MODE == "baw" || $RUNTIME_MODE == "baw-dev" ]];then
               echo
            else
               echo "Use a valid value: -m [baw] "
               show_help
               exit -1
            fi        
            ;;    
        :)  echo "Invalid option: -$OPTARG requires an argument"
            show_help
            exit -1
            ;;
        esac
    done
fi

mkdir -p $TEMP_FOLDER >/dev/null 2>&1
source ${CUR_DIR}/helper/common.sh
select_uninstall_type
rm -rf ${TEMP_FOLDER} >/dev/null 2>&1

