# OpenLDAP Deployment for OpenShift

This repository contains OpenShift manifests for deploying an OpenLDAP server with phpLDAPadmin web interface.

## Overview

- **OpenLDAP Server**: Bitnami OpenLDAP 2.6.7 with custom configuration
- **Web Admin**: phpLDAPadmin for web-based LDAP management
- **Domain**: `cp.internal` (dc=cp,dc=internal)
- **Namespace**: `cp4ba-ldap`
- **Storage**: Persistent storage using CephFS

## Prerequisites

- OpenShift cluster with admin access
- OpenShift Data Foundation with CephFS storage class
- Namespace `cp4ba-ldap` (created automatically during deployment)

## Quick Deployment

### 1. Deploy All Components
```bash
# Deploy OpenLDAP server and phpLDAPadmin
oc apply -f openldap/
oc apply -f phpldapadmin/
```

### 2. Verify Deployment
```bash
# Check pod status
oc get pods -n cp4ba-ldap

# Check services
oc get services -n cp4ba-ldap

# Check routes (for web access)
oc get routes -n cp4ba-ldap
```

## Detailed Deployment Steps

### Step 1: Deploy OpenLDAP Server
```bash
# Create namespace (if not exists)
oc new-project cp4ba-ldap

# Deploy OpenLDAP components
oc apply -f openldap/configmap-env.yaml
oc apply -f openldap/configmap-customldif.yaml
oc apply -f openldap/ldap-secret.yaml
oc apply -f openldap/pvc.yaml
oc apply -f openldap/service.yaml
oc apply -f openldap/deployment.yaml
```

### Step 2: Deploy phpLDAPadmin Web Interface
```bash
# Create service account and grant permissions
oc apply -f phpldapadmin/serviceaccount.yaml
oc adm policy add-scc-to-user anyuid -z phpldapadmin-sa -n cp4ba-ldap

# Deploy phpLDAPadmin components
oc apply -f phpldapadmin/configmap.yaml
oc apply -f phpldapadmin/service.yaml
oc apply -f phpldapadmin/deployment.yaml
oc apply -f phpldapadmin/route.yaml
```

### Step 3: Verify Installation
```bash
# Wait for pods to be ready
oc get pods -n cp4ba-ldap -w

# Check if services are running
oc get svc -n cp4ba-ldap

# Get web interface URL
oc get route phpldapadmin -n cp4ba-ldap -o jsonpath='{.spec.host}'
```

## Access Information

### LDAP Server Access
- **Host**: `openldap.cp4ba-ldap.svc.cluster.local`
- **Port**: `389`
- **Base DN**: `dc=cp,dc=internal`
- **Admin DN**: `cn=cpadmin,dc=cp,dc=internal`
- **Admin Password**: (stored in `ldap-secret`)

### Web Interface Access
- **URL**: `https://[route-host]` (get via `oc get route`)
- **Login DN**: `cn=cpadmin,dc=cp,dc=internal`
- **Password**: Same as LDAP admin password

### Default Users and Groups

**Admin User**:
- Username: `cpadmin`
- DN: `cn=cpadmin,dc=cp,dc=internal`
- Group: `cpadmins`

**Regular User**:
- Username: `cpuser`
- DN: `cn=cpuser,dc=cp,dc=internal`
- Group: `cpusers`

## Testing LDAP Connectivity

### From within the cluster:
```bash
# Test LDAP search
oc exec deployment/openldap -n cp4ba-ldap -- ldapsearch -x -H ldap://localhost:1389 -D "cn=cpadmin,dc=cp,dc=internal" -W -b "dc=cp,dc=internal"

# Test user authentication
oc exec deployment/openldap -n cp4ba-ldap -- ldapwhoami -x -H ldap://localhost:1389 -D "cn=cpuser,dc=cp,dc=internal" -W
```

### From external client:
```bash
# Get service endpoint
LDAP_HOST=$(oc get service openldap -n cp4ba-ldap -o jsonpath='{.status.loadBalancer.ingress[0].ip}')
LDAP_PORT=389

# Test connection
ldapsearch -x -H ldap://$LDAP_HOST:$LDAP_PORT -D "cn=cpadmin,dc=cp,dc=internal" -W -b "dc=cp,dc=internal"
```

## Configuration Management

### Updating LDAP Configuration
1. Edit the configmaps:
   - `openldap/configmap-env.yaml` - Environment variables
   - `openldap/configmap-customldif.yaml` - LDAP directory structure

2. Apply changes:
```bash
oc apply -f openldap/configmap-env.yaml
oc apply -f openldap/configmap-customldif.yaml
```

3. Restart the deployment:
```bash
oc rollout restart deployment/openldap -n cp4ba-ldap
```

### Updating Admin Password
1. Update the base64-encoded password in `openldap/ldap-secret.yaml`
2. Apply the secret:
```bash
oc apply -f openldap/ldap-secret.yaml
```
3. Restart the deployment:
```bash
oc rollout restart deployment/openldap -n cp4ba-ldap
```

## Troubleshooting

### Common Issues

**Pods not starting**:
```bash
# Check pod events
oc describe pod [pod-name] -n cp4ba-ldap

# Check logs
oc logs deployment/openldap -n cp4ba-ldap
oc logs deployment/phpldapadmin -n cp4ba-ldap
```

**Storage issues**:
```bash
# Check PVC status
oc get pvc -n cp4ba-ldap

# Check storage class
oc get storageclass
```

**Network connectivity**:
```bash
# Test internal service resolution
oc exec deployment/phpldapadmin -n cp4ba-ldap -- nslookup openldap.cp4ba-ldap.svc.cluster.local

# Check service endpoints
oc get endpoints -n cp4ba-ldap
```

### Logs and Monitoring
```bash
# Monitor OpenLDAP logs
oc logs -f deployment/openldap -n cp4ba-ldap

# Monitor phpLDAPadmin logs
oc logs -f deployment/phpldapadmin -n cp4ba-ldap

# Check resource usage
oc top pods -n cp4ba-ldap
```

## Security Considerations

- Admin passwords are stored in OpenShift secrets
- Non-root containers with security contexts
- TLS termination at OpenShift route level
- Network policies should be configured for production use
- Consider using external secret management for production deployments

## Cleanup

```bash
# Remove all resources
oc delete -f phpldapadmin/
oc delete -f openldap/

# Delete namespace (optional)
oc delete project cp4ba-ldap
```

## Support

For issues and questions:
1. Check the logs using the troubleshooting commands above
2. Verify all prerequisites are met
3. Ensure proper network connectivity between components